/*
 * CyberSource Merged Spec
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package Model;

import java.util.Objects;
import Model.Ptsv2paymentsPointOfSaleInformationEmv;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Ptsv2paymentsPointOfSaleInformation
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2022-09-11T23:41:38.291+05:30")
public class Ptsv2paymentsPointOfSaleInformation {
  @SerializedName("terminalId")
  private String terminalId = null;

  @SerializedName("terminalSerialNumber")
  private String terminalSerialNumber = null;

  @SerializedName("cardholderVerificationMethodUsed")
  private Integer cardholderVerificationMethodUsed = null;

  @SerializedName("laneNumber")
  private String laneNumber = null;

  @SerializedName("catLevel")
  private Integer catLevel = null;

  @SerializedName("entryMode")
  private String entryMode = null;

  @SerializedName("terminalCapability")
  private Integer terminalCapability = null;

  @SerializedName("operatingEnvironment")
  private String operatingEnvironment = null;

  @SerializedName("emv")
  private Ptsv2paymentsPointOfSaleInformationEmv emv = null;

  @SerializedName("amexCapnData")
  private String amexCapnData = null;

  @SerializedName("trackData")
  private String trackData = null;

  @SerializedName("storeAndForwardIndicator")
  private String storeAndForwardIndicator = null;

  @SerializedName("cardholderVerificationMethod")
  private List<String> cardholderVerificationMethod = null;

  @SerializedName("terminalInputCapability")
  private List<String> terminalInputCapability = null;

  @SerializedName("terminalCardCaptureCapability")
  private String terminalCardCaptureCapability = null;

  @SerializedName("terminalOutputCapability")
  private String terminalOutputCapability = null;

  @SerializedName("terminalPinCapability")
  private Integer terminalPinCapability = null;

  @SerializedName("deviceId")
  private String deviceId = null;

  @SerializedName("pinBlockEncodingFormat")
  private Integer pinBlockEncodingFormat = null;

  @SerializedName("encryptedPin")
  private String encryptedPin = null;

  @SerializedName("encryptedKeySerialNumber")
  private String encryptedKeySerialNumber = null;

  @SerializedName("partnerSdkVersion")
  private String partnerSdkVersion = null;

  @SerializedName("emvApplicationIdentifierAndDedicatedFileName")
  private String emvApplicationIdentifierAndDedicatedFileName = null;

  @SerializedName("terminalCompliance")
  private String terminalCompliance = null;

  @SerializedName("isDedicatedHardwareTerminal")
  private String isDedicatedHardwareTerminal = null;

  @SerializedName("terminalModel")
  private String terminalModel = null;

  @SerializedName("terminalMake")
  private String terminalMake = null;

  @SerializedName("serviceCode")
  private String serviceCode = null;

  public Ptsv2paymentsPointOfSaleInformation terminalId(String terminalId) {
    this.terminalId = terminalId;
    return this;
  }

   /**
   * Identifier for the terminal at your retail location. You can define this value yourself, but consult the processor for requirements.  #### CyberSource through VisaNet A list of all possible values is stored in your CyberSource account. If terminal ID validation is enabled for your CyberSource account, the value you send for this field is validated against the list each time you include the field in a request. To enable or disable terminal ID validation, contact CyberSource Customer Support.  When you do not include this field in a request, CyberSource uses the default value that is defined in your CyberSource account.  #### FDC Nashville Global To have your account configured to support this field, contact CyberSource Customer Support. This value must be a value that FDC Nashville Global issued to you.  #### For Payouts This field is applicable for CyberSource through VisaNet.  #### GPX Identifier for the terminal at your retail location. A list of all possible values is stored in your account. If terminal ID validation is enabled for your account, the value you send for this field is validated against the list each time you include the field in a request. To enable or disable terminal ID validation, contact customer support.  When you do not include this field in a request, the default value that is defined in your account is used.  Optional for authorizations.  #### Used by **Authorization** Optional for the following processors. When you do not include this field in a request, the default value that is defined in your account is used.   - American Express Direct   - Credit Mutuel-CIC   - FDC Nashville Global   - SIX - Chase Paymentech Solutions: Optional field. If you include this field in your request, you must also include &#x60;pointOfSaleInformation.catLevel&#x60;. - FDMS Nashville: The default value that is defined in your account is used. - GPX - OmniPay Direct: Optional field.  For the following processors, this field is not used. - GPN - JCN Gateway - RBS WorldPay Atlanta - TSYS Acquiring Solutions - Worldpay VAP  #### Card Present reply Terminal identifier assigned by the acquirer. This value must be printed on the receipt. 
   * @return terminalId
  **/
  @ApiModelProperty(value = "Identifier for the terminal at your retail location. You can define this value yourself, but consult the processor for requirements.  #### CyberSource through VisaNet A list of all possible values is stored in your CyberSource account. If terminal ID validation is enabled for your CyberSource account, the value you send for this field is validated against the list each time you include the field in a request. To enable or disable terminal ID validation, contact CyberSource Customer Support.  When you do not include this field in a request, CyberSource uses the default value that is defined in your CyberSource account.  #### FDC Nashville Global To have your account configured to support this field, contact CyberSource Customer Support. This value must be a value that FDC Nashville Global issued to you.  #### For Payouts This field is applicable for CyberSource through VisaNet.  #### GPX Identifier for the terminal at your retail location. A list of all possible values is stored in your account. If terminal ID validation is enabled for your account, the value you send for this field is validated against the list each time you include the field in a request. To enable or disable terminal ID validation, contact customer support.  When you do not include this field in a request, the default value that is defined in your account is used.  Optional for authorizations.  #### Used by **Authorization** Optional for the following processors. When you do not include this field in a request, the default value that is defined in your account is used.   - American Express Direct   - Credit Mutuel-CIC   - FDC Nashville Global   - SIX - Chase Paymentech Solutions: Optional field. If you include this field in your request, you must also include `pointOfSaleInformation.catLevel`. - FDMS Nashville: The default value that is defined in your account is used. - GPX - OmniPay Direct: Optional field.  For the following processors, this field is not used. - GPN - JCN Gateway - RBS WorldPay Atlanta - TSYS Acquiring Solutions - Worldpay VAP  #### Card Present reply Terminal identifier assigned by the acquirer. This value must be printed on the receipt. ")
  public String getTerminalId() {
    return terminalId;
  }

  public void setTerminalId(String terminalId) {
    this.terminalId = terminalId;
  }

  public Ptsv2paymentsPointOfSaleInformation terminalSerialNumber(String terminalSerialNumber) {
    this.terminalSerialNumber = terminalSerialNumber;
    return this;
  }

   /**
   * Terminal serial number assigned by the hardware manufacturer. This value is provided by the client software that is installed on the POS terminal.  This value is not forwarded to the processor. Instead, the value is forwarded to the reporting functionality.  #### Used by **Authorization and Credit** Optional. This field is supported only by client software that is installed on your POS terminals for the following processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX 
   * @return terminalSerialNumber
  **/
  @ApiModelProperty(value = "Terminal serial number assigned by the hardware manufacturer. This value is provided by the client software that is installed on the POS terminal.  This value is not forwarded to the processor. Instead, the value is forwarded to the reporting functionality.  #### Used by **Authorization and Credit** Optional. This field is supported only by client software that is installed on your POS terminals for the following processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX ")
  public String getTerminalSerialNumber() {
    return terminalSerialNumber;
  }

  public void setTerminalSerialNumber(String terminalSerialNumber) {
    this.terminalSerialNumber = terminalSerialNumber;
  }

  public Ptsv2paymentsPointOfSaleInformation cardholderVerificationMethodUsed(Integer cardholderVerificationMethodUsed) {
    this.cardholderVerificationMethodUsed = cardholderVerificationMethodUsed;
    return this;
  }

   /**
   * Method that was used to verify the cardholder&#39;s identity. Possible values:    - &#x60;0&#x60;: No verification   - &#x60;1&#x60;: Signature   - &#x60;2&#x60;: PIN   - &#x60;3&#x60;: Cardholder device CVM 
   * @return cardholderVerificationMethodUsed
  **/
  @ApiModelProperty(value = "Method that was used to verify the cardholder's identity. Possible values:    - `0`: No verification   - `1`: Signature   - `2`: PIN   - `3`: Cardholder device CVM ")
  public Integer getCardholderVerificationMethodUsed() {
    return cardholderVerificationMethodUsed;
  }

  public void setCardholderVerificationMethodUsed(Integer cardholderVerificationMethodUsed) {
    this.cardholderVerificationMethodUsed = cardholderVerificationMethodUsed;
  }

  public Ptsv2paymentsPointOfSaleInformation laneNumber(String laneNumber) {
    this.laneNumber = laneNumber;
    return this;
  }

   /**
   * Identifier for an alternate terminal at your retail location. You define the value for this field.  This field is supported only for MasterCard transactions on FDC Nashville Global. Otherwise, this field is not used by all other processors. Use the &#x60;terminalId&#x60; field to identify the main terminal at your retail location. If your retail location has multiple terminals, use this &#x60;laneNumber&#x60; field to identify the terminal used for the transaction.  This field is a pass-through, which means that the value is not checked or modified in any way before sending it to the processor.  Optional field.  #### Card present reply messaging Identifier for an alternate terminal at your retail location. You defined the value for this field in the request message. This value must be printed on the receipt.  This field is supported only for MasterCard transactions on FDC Nashville Global. 
   * @return laneNumber
  **/
  @ApiModelProperty(value = "Identifier for an alternate terminal at your retail location. You define the value for this field.  This field is supported only for MasterCard transactions on FDC Nashville Global. Otherwise, this field is not used by all other processors. Use the `terminalId` field to identify the main terminal at your retail location. If your retail location has multiple terminals, use this `laneNumber` field to identify the terminal used for the transaction.  This field is a pass-through, which means that the value is not checked or modified in any way before sending it to the processor.  Optional field.  #### Card present reply messaging Identifier for an alternate terminal at your retail location. You defined the value for this field in the request message. This value must be printed on the receipt.  This field is supported only for MasterCard transactions on FDC Nashville Global. ")
  public String getLaneNumber() {
    return laneNumber;
  }

  public void setLaneNumber(String laneNumber) {
    this.laneNumber = laneNumber;
  }

  public Ptsv2paymentsPointOfSaleInformation catLevel(Integer catLevel) {
    this.catLevel = catLevel;
    return this;
  }

   /**
   * Type of cardholder-activated terminal. Possible values:   - 1: Automated dispensing machine  - 2: Self-service terminal  - 3: Limited amount terminal  - 4: In-flight commerce (IFC) terminal  - 5: Radio frequency device  - 6: Mobile acceptance terminal  - 7: Electronic cash register  - 8: E-commerce device at your location  - 9: Terminal or cash register that uses a dialup connection to connect to the transaction processing network  #### Chase Paymentech Solutions Only values 1, 2, and 3 are supported.  Required if &#x60;pointOfSaleInformation.terminalID&#x60; is included in the request; otherwise, optional.  #### CyberSource through VisaNet Values 1 through 6 are supported on CyberSource through VisaNet, but some acquirers do not support all six values.  Optional field.  #### FDC Nashville Global Only values 7, 8, and 9 are supported.  Optional field for EMV transactions; otherwise, not used.  #### GPN Only values 6, 7, 8, and 9 are supported.  Required field.  #### JCN Gateway Only values 6, 7, 8, and 9 are supported.  Required field.  #### TSYS Acquiring Solutions Only value 6 is supported.  Required for transactions from mobile devices; otherwise, not used.  #### All other processors Not used.  Nonnegative integer. 
   * minimum: 1
   * maximum: 9
   * @return catLevel
  **/
  @ApiModelProperty(value = "Type of cardholder-activated terminal. Possible values:   - 1: Automated dispensing machine  - 2: Self-service terminal  - 3: Limited amount terminal  - 4: In-flight commerce (IFC) terminal  - 5: Radio frequency device  - 6: Mobile acceptance terminal  - 7: Electronic cash register  - 8: E-commerce device at your location  - 9: Terminal or cash register that uses a dialup connection to connect to the transaction processing network  #### Chase Paymentech Solutions Only values 1, 2, and 3 are supported.  Required if `pointOfSaleInformation.terminalID` is included in the request; otherwise, optional.  #### CyberSource through VisaNet Values 1 through 6 are supported on CyberSource through VisaNet, but some acquirers do not support all six values.  Optional field.  #### FDC Nashville Global Only values 7, 8, and 9 are supported.  Optional field for EMV transactions; otherwise, not used.  #### GPN Only values 6, 7, 8, and 9 are supported.  Required field.  #### JCN Gateway Only values 6, 7, 8, and 9 are supported.  Required field.  #### TSYS Acquiring Solutions Only value 6 is supported.  Required for transactions from mobile devices; otherwise, not used.  #### All other processors Not used.  Nonnegative integer. ")
  public Integer getCatLevel() {
    return catLevel;
  }

  public void setCatLevel(Integer catLevel) {
    this.catLevel = catLevel;
  }

  public Ptsv2paymentsPointOfSaleInformation entryMode(String entryMode) {
    this.entryMode = entryMode;
    return this;
  }

   /**
   * Method of entering payment card information into the POS terminal. Possible values:   - &#x60;contact&#x60;: Read from direct contact with chip card.  - &#x60;contactless&#x60;: Read from a contactless interface using chip data.  - &#x60;keyed&#x60;: Manually keyed into POS terminal. This value is not supported on OmniPay Direct.  - &#x60;msd&#x60;: Read from a contactless interface using magnetic stripe data (MSD). This value is not supported on OmniPay Direct.  - &#x60;swiped&#x60;: Read from credit card magnetic stripe.  The &#x60;contact&#x60;, &#x60;contactless&#x60;, and &#x60;msd&#x60; values are supported only for EMV transactions.  #### Used by **Authorization** Required field.  #### Card Present Card present information about EMV applies only to credit card processing and PIN debit processing. All other card present information applies only to credit card processing.  #### PIN debit Required for a PIN debit purchase and a PIN debit credit request. 
   * @return entryMode
  **/
  @ApiModelProperty(value = "Method of entering payment card information into the POS terminal. Possible values:   - `contact`: Read from direct contact with chip card.  - `contactless`: Read from a contactless interface using chip data.  - `keyed`: Manually keyed into POS terminal. This value is not supported on OmniPay Direct.  - `msd`: Read from a contactless interface using magnetic stripe data (MSD). This value is not supported on OmniPay Direct.  - `swiped`: Read from credit card magnetic stripe.  The `contact`, `contactless`, and `msd` values are supported only for EMV transactions.  #### Used by **Authorization** Required field.  #### Card Present Card present information about EMV applies only to credit card processing and PIN debit processing. All other card present information applies only to credit card processing.  #### PIN debit Required for a PIN debit purchase and a PIN debit credit request. ")
  public String getEntryMode() {
    return entryMode;
  }

  public void setEntryMode(String entryMode) {
    this.entryMode = entryMode;
  }

  public Ptsv2paymentsPointOfSaleInformation terminalCapability(Integer terminalCapability) {
    this.terminalCapability = terminalCapability;
    return this;
  }

   /**
   * POS terminal’s capability. Possible values:   - &#x60;1&#x60;: Terminal has a magnetic stripe reader only.  - &#x60;2&#x60;: Terminal has a magnetic stripe reader and manual entry capability.  - &#x60;3&#x60;: Terminal has manual entry capability only.  - &#x60;4&#x60;: Terminal can read chip cards.  - &#x60;5&#x60;: Terminal can read contactless chip cards; cannot use contact to read chip cards.  For an EMV transaction, the value of this field must be &#x60;4&#x60; or &#x60;5&#x60;.  #### PIN debit Required for PIN debit purchase and PIN debit credit request.  #### Used by **Authorization** Required for the following processors: - American Express Direct - Chase Paymentech Solutions - Credit Mutuel-CIC - FDC Nashville Global - FDMS Nashville - OmniPay Direct - SIX - Worldpay VAP  Optional for the following processors: - CyberSource through VisaNet - GPN - GPX - JCN Gateway - RBS WorldPay Atlanta - TSYS Acquiring Solutions 
   * minimum: 1
   * maximum: 5
   * @return terminalCapability
  **/
  @ApiModelProperty(value = "POS terminal’s capability. Possible values:   - `1`: Terminal has a magnetic stripe reader only.  - `2`: Terminal has a magnetic stripe reader and manual entry capability.  - `3`: Terminal has manual entry capability only.  - `4`: Terminal can read chip cards.  - `5`: Terminal can read contactless chip cards; cannot use contact to read chip cards.  For an EMV transaction, the value of this field must be `4` or `5`.  #### PIN debit Required for PIN debit purchase and PIN debit credit request.  #### Used by **Authorization** Required for the following processors: - American Express Direct - Chase Paymentech Solutions - Credit Mutuel-CIC - FDC Nashville Global - FDMS Nashville - OmniPay Direct - SIX - Worldpay VAP  Optional for the following processors: - CyberSource through VisaNet - GPN - GPX - JCN Gateway - RBS WorldPay Atlanta - TSYS Acquiring Solutions ")
  public Integer getTerminalCapability() {
    return terminalCapability;
  }

  public void setTerminalCapability(Integer terminalCapability) {
    this.terminalCapability = terminalCapability;
  }

  public Ptsv2paymentsPointOfSaleInformation operatingEnvironment(String operatingEnvironment) {
    this.operatingEnvironment = operatingEnvironment;
    return this;
  }

   /**
   * Operating environment.  Possible values for all card types except Mastercard: - &#x60;0&#x60;: No terminal used or unknown environment. - &#x60;1&#x60;: On merchant premises, attended. - &#x60;2&#x60;: On merchant premises, unattended. Examples: oil, kiosks, self-checkout, mobile telephone, personal digital assistant (PDA). - &#x60;3&#x60;: Off merchant premises, attended. Examples: portable POS devices at trade shows, at service calls, or in taxis. - &#x60;4&#x60;: Off merchant premises, unattended. Examples: vending machines, home computer, mobile telephone, PDA. - &#x60;5&#x60;: On premises of cardholder, unattended. - &#x60;9&#x60;: Unknown delivery mode. - &#x60;S&#x60;: Electronic delivery of product. Examples: music, software, or eTickets that are downloaded over the internet. - &#x60;T&#x60;: Physical delivery of product. Examples: music or software that is delivered by mail or by a courier.  #### Possible values for Mastercard: - &#x60;2&#x60;: On merchant premises, unattended, or cardholder terminal. Examples: oil, kiosks, self-checkout, home computer, mobile telephone, personal digital assistant (PDA). Cardholder terminal is supported only for Mastercard transactions on CyberSource through VisaNet. - &#x60;4&#x60;: Off merchant premises, unattended, or cardholder terminal. Examples: vending machines, home computer, mobile telephone, PDA. Cardholder terminal is supported only for Mastercard transactions on CyberSource through VisaNet.  This field is supported only for American Express Direct and CyberSource through VisaNet. 
   * @return operatingEnvironment
  **/
  @ApiModelProperty(value = "Operating environment.  Possible values for all card types except Mastercard: - `0`: No terminal used or unknown environment. - `1`: On merchant premises, attended. - `2`: On merchant premises, unattended. Examples: oil, kiosks, self-checkout, mobile telephone, personal digital assistant (PDA). - `3`: Off merchant premises, attended. Examples: portable POS devices at trade shows, at service calls, or in taxis. - `4`: Off merchant premises, unattended. Examples: vending machines, home computer, mobile telephone, PDA. - `5`: On premises of cardholder, unattended. - `9`: Unknown delivery mode. - `S`: Electronic delivery of product. Examples: music, software, or eTickets that are downloaded over the internet. - `T`: Physical delivery of product. Examples: music or software that is delivered by mail or by a courier.  #### Possible values for Mastercard: - `2`: On merchant premises, unattended, or cardholder terminal. Examples: oil, kiosks, self-checkout, home computer, mobile telephone, personal digital assistant (PDA). Cardholder terminal is supported only for Mastercard transactions on CyberSource through VisaNet. - `4`: Off merchant premises, unattended, or cardholder terminal. Examples: vending machines, home computer, mobile telephone, PDA. Cardholder terminal is supported only for Mastercard transactions on CyberSource through VisaNet.  This field is supported only for American Express Direct and CyberSource through VisaNet. ")
  public String getOperatingEnvironment() {
    return operatingEnvironment;
  }

  public void setOperatingEnvironment(String operatingEnvironment) {
    this.operatingEnvironment = operatingEnvironment;
  }

  public Ptsv2paymentsPointOfSaleInformation emv(Ptsv2paymentsPointOfSaleInformationEmv emv) {
    this.emv = emv;
    return this;
  }

   /**
   * Get emv
   * @return emv
  **/
  @ApiModelProperty(value = "")
  public Ptsv2paymentsPointOfSaleInformationEmv getEmv() {
    return emv;
  }

  public void setEmv(Ptsv2paymentsPointOfSaleInformationEmv emv) {
    this.emv = emv;
  }

  public Ptsv2paymentsPointOfSaleInformation amexCapnData(String amexCapnData) {
    this.amexCapnData = amexCapnData;
    return this;
  }

   /**
   * Point-of-sale details for the transaction. This value is returned only for **American Express Direct**. CyberSource generates this value, which consists of a series of codes that identify terminal capability, security data, and specific conditions present at the time the transaction occurred. To comply with the CAPN requirements, this value must be included in all subsequent follow-on requests, such as captures and follow-on credits.  When you perform authorizations, captures, and credits through CyberSource, CyberSource passes this value from the authorization service to the subsequent services for you. However, when you perform authorizations through CyberSource and perform subsequent services through other financial institutions, you must ensure that your requests for captures and credits include this value.  For details, see &#x60;auth_pos_data&#x60; field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) 
   * @return amexCapnData
  **/
  @ApiModelProperty(value = "Point-of-sale details for the transaction. This value is returned only for **American Express Direct**. CyberSource generates this value, which consists of a series of codes that identify terminal capability, security data, and specific conditions present at the time the transaction occurred. To comply with the CAPN requirements, this value must be included in all subsequent follow-on requests, such as captures and follow-on credits.  When you perform authorizations, captures, and credits through CyberSource, CyberSource passes this value from the authorization service to the subsequent services for you. However, when you perform authorizations through CyberSource and perform subsequent services through other financial institutions, you must ensure that your requests for captures and credits include this value.  For details, see `auth_pos_data` field description in [Credit Card Services Using the SCMP API.](https://apps.cybersource.com/library/documentation/dev_guides/CC_Svcs_SCMP_API/html/) ")
  public String getAmexCapnData() {
    return amexCapnData;
  }

  public void setAmexCapnData(String amexCapnData) {
    this.amexCapnData = amexCapnData;
  }

  public Ptsv2paymentsPointOfSaleInformation trackData(String trackData) {
    this.trackData = trackData;
    return this;
  }

   /**
   * Card’s track 1 and 2 data. For all processors except FDMS Nashville, this value consists of one of the following:   - Track 1 data  - Track 2 data  - Data for both tracks 1 and 2  For FDMS Nashville, this value consists of one of the following:  - Track 1 data  - Data for both tracks 1 and 2  Example: %B4111111111111111^SMITH/JOHN ^1612101976110000868000000?;4111111111111111&#x3D;16121019761186800000?  #### Used by **Authorization** Required for Chase Paymentech Solutions, Credit Mutuel-CIC, CyberSource through VisaNet, FDC Nashville Global, JCN Gateway, OmniPay Direct, and SIX if &#x60;pointOfSaleInformation.entryMode&#x60; is equal to one of these values: - &#x60;contact&#x60; - &#x60;contactless&#x60; - &#x60;msd&#x60; - &#x60;swiped&#x60; Otherwise, this field not used.  Required for all other processors if &#x60;pointOfSaleInformation.entryMode&#x3D;swiped&#x60;; otherwise, this field is not used.  #### GPX This field only supports transactions from the following card types: - Visa - Mastercard - AMEX - Discover - Diners - JCB - Union Pay International  #### PIN debit Track 2 data from the debit card. The sentinels are required. Required field for a PIN debit purchase and a PIN debit credit. 
   * @return trackData
  **/
  @ApiModelProperty(value = "Card’s track 1 and 2 data. For all processors except FDMS Nashville, this value consists of one of the following:   - Track 1 data  - Track 2 data  - Data for both tracks 1 and 2  For FDMS Nashville, this value consists of one of the following:  - Track 1 data  - Data for both tracks 1 and 2  Example: %B4111111111111111^SMITH/JOHN ^1612101976110000868000000?;4111111111111111=16121019761186800000?  #### Used by **Authorization** Required for Chase Paymentech Solutions, Credit Mutuel-CIC, CyberSource through VisaNet, FDC Nashville Global, JCN Gateway, OmniPay Direct, and SIX if `pointOfSaleInformation.entryMode` is equal to one of these values: - `contact` - `contactless` - `msd` - `swiped` Otherwise, this field not used.  Required for all other processors if `pointOfSaleInformation.entryMode=swiped`; otherwise, this field is not used.  #### GPX This field only supports transactions from the following card types: - Visa - Mastercard - AMEX - Discover - Diners - JCB - Union Pay International  #### PIN debit Track 2 data from the debit card. The sentinels are required. Required field for a PIN debit purchase and a PIN debit credit. ")
  public String getTrackData() {
    return trackData;
  }

  public void setTrackData(String trackData) {
    this.trackData = trackData;
  }

  public Ptsv2paymentsPointOfSaleInformation storeAndForwardIndicator(String storeAndForwardIndicator) {
    this.storeAndForwardIndicator = storeAndForwardIndicator;
    return this;
  }

   /**
   * When connectivity is unavailable, the client software that is installed on the POS terminal can store a transaction in its memory and send it for authorization when connectivity is restored. This value is provided by the client software that is installed on the POS terminal.  This value is not forwarded to the processor. Instead, the value is forwarded to the reporting functionality.  Possible values: - &#x60;Y&#x60;: Transaction was stored and then forwarded. - &#x60;N&#x60; (default): Transaction was not stored and then forwarded.  For authorizations and credits, this field is supported only on these processors: - American Express Direct - FDC Nashville Global - OmniPay Direct - SIX  Optional field. 
   * @return storeAndForwardIndicator
  **/
  @ApiModelProperty(value = "When connectivity is unavailable, the client software that is installed on the POS terminal can store a transaction in its memory and send it for authorization when connectivity is restored. This value is provided by the client software that is installed on the POS terminal.  This value is not forwarded to the processor. Instead, the value is forwarded to the reporting functionality.  Possible values: - `Y`: Transaction was stored and then forwarded. - `N` (default): Transaction was not stored and then forwarded.  For authorizations and credits, this field is supported only on these processors: - American Express Direct - FDC Nashville Global - OmniPay Direct - SIX  Optional field. ")
  public String getStoreAndForwardIndicator() {
    return storeAndForwardIndicator;
  }

  public void setStoreAndForwardIndicator(String storeAndForwardIndicator) {
    this.storeAndForwardIndicator = storeAndForwardIndicator;
  }

  public Ptsv2paymentsPointOfSaleInformation cardholderVerificationMethod(List<String> cardholderVerificationMethod) {
    this.cardholderVerificationMethod = cardholderVerificationMethod;
    return this;
  }

  public Ptsv2paymentsPointOfSaleInformation addCardholderVerificationMethodItem(String cardholderVerificationMethodItem) {
    if (this.cardholderVerificationMethod == null) {
      this.cardholderVerificationMethod = new ArrayList<String>();
    }
    this.cardholderVerificationMethod.add(cardholderVerificationMethodItem);
    return this;
  }

   /**
   * Complete list of cardholder verification methods (CVMs) supported by the terminal. Optional field. Possible values: - &#x60;PIN&#x60;: For terminals with a PIN Pad - &#x60;Signature&#x60;: For terminals capable of receiving a signature - &#x60;pinOnGlass&#x60;: For terminals where PIN is entered on a glass-based capture mechanism  **EXAMPLE**: [\&quot;PIN\&quot;,\&quot;Signature\&quot;]; [\&quot;pinOnGlass\&quot;,\&quot;Signature\&quot;] 
   * @return cardholderVerificationMethod
  **/
  @ApiModelProperty(value = "Complete list of cardholder verification methods (CVMs) supported by the terminal. Optional field. Possible values: - `PIN`: For terminals with a PIN Pad - `Signature`: For terminals capable of receiving a signature - `pinOnGlass`: For terminals where PIN is entered on a glass-based capture mechanism  **EXAMPLE**: [\"PIN\",\"Signature\"]; [\"pinOnGlass\",\"Signature\"] ")
  public List<String> getCardholderVerificationMethod() {
    return cardholderVerificationMethod;
  }

  public void setCardholderVerificationMethod(List<String> cardholderVerificationMethod) {
    this.cardholderVerificationMethod = cardholderVerificationMethod;
  }

  public Ptsv2paymentsPointOfSaleInformation terminalInputCapability(List<String> terminalInputCapability) {
    this.terminalInputCapability = terminalInputCapability;
    return this;
  }

  public Ptsv2paymentsPointOfSaleInformation addTerminalInputCapabilityItem(String terminalInputCapabilityItem) {
    if (this.terminalInputCapability == null) {
      this.terminalInputCapability = new ArrayList<String>();
    }
    this.terminalInputCapability.add(terminalInputCapabilityItem);
    return this;
  }

   /**
   * Complete list of card input methods supported by the terminal.  Possible values: - &#x60;Keyed&#x60;: Terminal can accept card data that is entered manually. - &#x60;Swiped&#x60;: Terminal can accept card data from a magnetic stripe reader. - &#x60;Contact&#x60;: Terminal can accept card data in EMV contact mode (\&quot;dipping a card\&quot;). - &#x60;Contactless&#x60;: Terminal can accept card data in EMV contactless mode (\&quot;tapping a card\&quot;). - &#x60;BarCode&#x60;: Terminal can read bar codes. - &#x60;QRcode&#x60;: Terminal can read or scan QR codes. - &#x60;OCR&#x60;: Terminal can perform optical character recognition (OCT) on the card.  **EXAMPLE**: [\&quot;Keyed\&quot;,\&quot;Swiped\&quot;,\&quot;Contact\&quot;,\&quot;Contactless\&quot;]  #### Used by **Authorization and Credit** Optional. This field is supported only by client software that is installed on your POS terminals for the following processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX 
   * @return terminalInputCapability
  **/
  @ApiModelProperty(value = "Complete list of card input methods supported by the terminal.  Possible values: - `Keyed`: Terminal can accept card data that is entered manually. - `Swiped`: Terminal can accept card data from a magnetic stripe reader. - `Contact`: Terminal can accept card data in EMV contact mode (\"dipping a card\"). - `Contactless`: Terminal can accept card data in EMV contactless mode (\"tapping a card\"). - `BarCode`: Terminal can read bar codes. - `QRcode`: Terminal can read or scan QR codes. - `OCR`: Terminal can perform optical character recognition (OCT) on the card.  **EXAMPLE**: [\"Keyed\",\"Swiped\",\"Contact\",\"Contactless\"]  #### Used by **Authorization and Credit** Optional. This field is supported only by client software that is installed on your POS terminals for the following processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX ")
  public List<String> getTerminalInputCapability() {
    return terminalInputCapability;
  }

  public void setTerminalInputCapability(List<String> terminalInputCapability) {
    this.terminalInputCapability = terminalInputCapability;
  }

  public Ptsv2paymentsPointOfSaleInformation terminalCardCaptureCapability(String terminalCardCaptureCapability) {
    this.terminalCardCaptureCapability = terminalCardCaptureCapability;
    return this;
  }

   /**
   * Indicates whether the terminal can capture the card.  Possible values: - &#x60;1&#x60;: Terminal can capture card. - &#x60;0&#x60;: Terminal cannot capture card.  For authorizations and credits, this field is supported only by these processors: - American Express Direct - Credit Mutuel-CIC - OmniPay Direct  Optional field. 
   * @return terminalCardCaptureCapability
  **/
  @ApiModelProperty(value = "Indicates whether the terminal can capture the card.  Possible values: - `1`: Terminal can capture card. - `0`: Terminal cannot capture card.  For authorizations and credits, this field is supported only by these processors: - American Express Direct - Credit Mutuel-CIC - OmniPay Direct  Optional field. ")
  public String getTerminalCardCaptureCapability() {
    return terminalCardCaptureCapability;
  }

  public void setTerminalCardCaptureCapability(String terminalCardCaptureCapability) {
    this.terminalCardCaptureCapability = terminalCardCaptureCapability;
  }

  public Ptsv2paymentsPointOfSaleInformation terminalOutputCapability(String terminalOutputCapability) {
    this.terminalOutputCapability = terminalOutputCapability;
    return this;
  }

   /**
   * Indicates whether the terminal can print or display messages.  Possible values: - 1: Neither - 2: Print only - 3: Display only - 4: Print and display  This field is supported for authorizations and credits only on the following processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX  Optional field. 
   * @return terminalOutputCapability
  **/
  @ApiModelProperty(value = "Indicates whether the terminal can print or display messages.  Possible values: - 1: Neither - 2: Print only - 3: Display only - 4: Print and display  This field is supported for authorizations and credits only on the following processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX  Optional field. ")
  public String getTerminalOutputCapability() {
    return terminalOutputCapability;
  }

  public void setTerminalOutputCapability(String terminalOutputCapability) {
    this.terminalOutputCapability = terminalOutputCapability;
  }

  public Ptsv2paymentsPointOfSaleInformation terminalPinCapability(Integer terminalPinCapability) {
    this.terminalPinCapability = terminalPinCapability;
    return this;
  }

   /**
   * Maximum PIN length that the terminal can capture.  Possible values: -  0: No PIN capture capability -  1: PIN capture capability unknown -  4: Four characters -  5: Five characters -  6: Six characters -  7: Seven characters -  8: Eight characters -  9: Nine characters - 10: Ten characters - 11: Eleven characters - 12: Twelve characters  This field is supported for authorizations and credits only on the following processors: - American Express Direct - Credit Mutuel-CIC - OmniPay Direct - SIX  Required field for authorization or credit of PIN transactions. 
   * @return terminalPinCapability
  **/
  @ApiModelProperty(value = "Maximum PIN length that the terminal can capture.  Possible values: -  0: No PIN capture capability -  1: PIN capture capability unknown -  4: Four characters -  5: Five characters -  6: Six characters -  7: Seven characters -  8: Eight characters -  9: Nine characters - 10: Ten characters - 11: Eleven characters - 12: Twelve characters  This field is supported for authorizations and credits only on the following processors: - American Express Direct - Credit Mutuel-CIC - OmniPay Direct - SIX  Required field for authorization or credit of PIN transactions. ")
  public Integer getTerminalPinCapability() {
    return terminalPinCapability;
  }

  public void setTerminalPinCapability(Integer terminalPinCapability) {
    this.terminalPinCapability = terminalPinCapability;
  }

  public Ptsv2paymentsPointOfSaleInformation deviceId(String deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * Value created by the client software that uniquely identifies the POS device. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX. 
   * @return deviceId
  **/
  @ApiModelProperty(value = "Value created by the client software that uniquely identifies the POS device. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX. ")
  public String getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(String deviceId) {
    this.deviceId = deviceId;
  }

  public Ptsv2paymentsPointOfSaleInformation pinBlockEncodingFormat(Integer pinBlockEncodingFormat) {
    this.pinBlockEncodingFormat = pinBlockEncodingFormat;
    return this;
  }

   /**
   * Format that is used to encode the PIN block. This value is provided by the client software that is installed on the POS terminal.  Possible values: - &#x60;0&#x60;: ISO 9564 format 0 - &#x60;1&#x60;: ISO 9564 format 1 - &#x60;2&#x60;: ISO 9564 format 2 - &#x60;3&#x60;: ISO 9564 format 3  #### Used by **Authorization, PIN Debit** - Required when the cardholder enters a PIN and the card cannot verify the PIN, which means that the issuer must verify the PIN. - Required for PIN debit credit or PIN debit purchase.  For authorizations, this field is supported only on these processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX  This field is also supported by processors that support chip and online PIN transactions. The following table lists the EMV Cards and Cardholder Verification Methods (CVMs) that these processors support:  | Processor | Chip and Offline PIN | Chip and Online PIN | Chip and Signature | | --- | --- | --- | --- | | American Express Direct | Yes | Yes | Yes | | Chase Paymentech Solutions | No | No | Yes | | Credit Mutuel-CIC | Yes | Yes | Yes | | CyberSource through VisaNet | Yes | No | Yes | | FDC Nashville Global | Yes | Yes | Yes | | GPN | No | No | Yes | | OmniPay Direct | Yes | No | Yes | | SIX | Yes | Yes | Yes |  #### GPX For chip and online PIN transactions for authorization, GPX supports the following EMV Cards and Cardholder Verification Methods (CVMs): - Chip and Offline PIN - Chip and Signature  For PIN Debit Purchase and Credit Service transactions, GPX supports the following EMV Cards and Cardholder Verification Methods (CVMs): - Chip and Online PIN 
   * maximum: 9
   * @return pinBlockEncodingFormat
  **/
  @ApiModelProperty(value = "Format that is used to encode the PIN block. This value is provided by the client software that is installed on the POS terminal.  Possible values: - `0`: ISO 9564 format 0 - `1`: ISO 9564 format 1 - `2`: ISO 9564 format 2 - `3`: ISO 9564 format 3  #### Used by **Authorization, PIN Debit** - Required when the cardholder enters a PIN and the card cannot verify the PIN, which means that the issuer must verify the PIN. - Required for PIN debit credit or PIN debit purchase.  For authorizations, this field is supported only on these processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX  This field is also supported by processors that support chip and online PIN transactions. The following table lists the EMV Cards and Cardholder Verification Methods (CVMs) that these processors support:  | Processor | Chip and Offline PIN | Chip and Online PIN | Chip and Signature | | --- | --- | --- | --- | | American Express Direct | Yes | Yes | Yes | | Chase Paymentech Solutions | No | No | Yes | | Credit Mutuel-CIC | Yes | Yes | Yes | | CyberSource through VisaNet | Yes | No | Yes | | FDC Nashville Global | Yes | Yes | Yes | | GPN | No | No | Yes | | OmniPay Direct | Yes | No | Yes | | SIX | Yes | Yes | Yes |  #### GPX For chip and online PIN transactions for authorization, GPX supports the following EMV Cards and Cardholder Verification Methods (CVMs): - Chip and Offline PIN - Chip and Signature  For PIN Debit Purchase and Credit Service transactions, GPX supports the following EMV Cards and Cardholder Verification Methods (CVMs): - Chip and Online PIN ")
  public Integer getPinBlockEncodingFormat() {
    return pinBlockEncodingFormat;
  }

  public void setPinBlockEncodingFormat(Integer pinBlockEncodingFormat) {
    this.pinBlockEncodingFormat = pinBlockEncodingFormat;
  }

  public Ptsv2paymentsPointOfSaleInformation encryptedPin(String encryptedPin) {
    this.encryptedPin = encryptedPin;
    return this;
  }

   /**
   * Encrypted PIN.  This value is provided by the client software that is installed on the POS terminal.  #### Used by **Authorization, PIN Debit** Required when the cardholder enters a PIN and the card cannot verify the PIN, which means that the issuer must verify the PIN. Required for PIN debit credit or PIN debit purchase. Required for online PIN transactions.  For authorizations, this field is supported only on these processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX  This field is also used by processors that support chip and online PIN transactions. The following table lists the EMV Cards and Cardholder Verification Methods (CVMs) that these processors support:  | Processor | Chip and Offline PIN | Chip and Online PIN | Chip and Signature | | --- | --- | --- | --- | | American Express Direct | Yes | Yes | Yes | | Chase Paymentech Solutions | No | No | Yes | | Credit Mutuel-CIC | Yes | Yes | Yes | | CyberSource through VisaNet | Yes | No | Yes | | FDC Nashville Global | Yes | Yes | Yes | | GPN | No | No | Yes | | OmniPay Direct | Yes | No | Yes | | SIX | Yes | Yes | Yes | 
   * @return encryptedPin
  **/
  @ApiModelProperty(value = "Encrypted PIN.  This value is provided by the client software that is installed on the POS terminal.  #### Used by **Authorization, PIN Debit** Required when the cardholder enters a PIN and the card cannot verify the PIN, which means that the issuer must verify the PIN. Required for PIN debit credit or PIN debit purchase. Required for online PIN transactions.  For authorizations, this field is supported only on these processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX  This field is also used by processors that support chip and online PIN transactions. The following table lists the EMV Cards and Cardholder Verification Methods (CVMs) that these processors support:  | Processor | Chip and Offline PIN | Chip and Online PIN | Chip and Signature | | --- | --- | --- | --- | | American Express Direct | Yes | Yes | Yes | | Chase Paymentech Solutions | No | No | Yes | | Credit Mutuel-CIC | Yes | Yes | Yes | | CyberSource through VisaNet | Yes | No | Yes | | FDC Nashville Global | Yes | Yes | Yes | | GPN | No | No | Yes | | OmniPay Direct | Yes | No | Yes | | SIX | Yes | Yes | Yes | ")
  public String getEncryptedPin() {
    return encryptedPin;
  }

  public void setEncryptedPin(String encryptedPin) {
    this.encryptedPin = encryptedPin;
  }

  public Ptsv2paymentsPointOfSaleInformation encryptedKeySerialNumber(String encryptedKeySerialNumber) {
    this.encryptedKeySerialNumber = encryptedKeySerialNumber;
    return this;
  }

   /**
   * Combination of the device&#39;s unique identifier and a transaction counter that is used in the process of decrypting the encrypted PIN. The entity that injected the PIN encryption keys into the terminal decrypts the encrypted PIN and creates this value.  For all terminals that are using derived unique key per transaction (DUKPT) encryption, this is generated as a single number within the terminal.  #### Used by **Authorization, PIN Debit** - Required when the cardholder enters a PIN and the card cannot verify the PIN, which means that the issuer must verify the PIN. - Required for PIN debit credit or PIN debit purchase. - Required for online PIN transactions  For authorizations, this field is supported only on these processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX  This field is also used by processors that support chip and online PIN transactions. The following table lists the EMV Cards and Cardholder Verification Methods (CVMs) that these processors support:  | Processor | Chip and Offline PIN | Chip and Online PIN | Chip and Signature | | --- | --- | --- | --- | | American Express Direct | Yes | Yes | Yes | | Chase Paymentech Solutions | No | No | Yes | | Credit Mutuel-CIC | Yes | Yes | Yes | | CyberSource through VisaNet | Yes | No | Yes | | FDC Nashville Global | Yes | Yes | Yes | | GPN | No | No | Yes | | OmniPay Direct | Yes | No | Yes | | SIX | Yes | Yes | Yes | 
   * @return encryptedKeySerialNumber
  **/
  @ApiModelProperty(value = "Combination of the device's unique identifier and a transaction counter that is used in the process of decrypting the encrypted PIN. The entity that injected the PIN encryption keys into the terminal decrypts the encrypted PIN and creates this value.  For all terminals that are using derived unique key per transaction (DUKPT) encryption, this is generated as a single number within the terminal.  #### Used by **Authorization, PIN Debit** - Required when the cardholder enters a PIN and the card cannot verify the PIN, which means that the issuer must verify the PIN. - Required for PIN debit credit or PIN debit purchase. - Required for online PIN transactions  For authorizations, this field is supported only on these processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX  This field is also used by processors that support chip and online PIN transactions. The following table lists the EMV Cards and Cardholder Verification Methods (CVMs) that these processors support:  | Processor | Chip and Offline PIN | Chip and Online PIN | Chip and Signature | | --- | --- | --- | --- | | American Express Direct | Yes | Yes | Yes | | Chase Paymentech Solutions | No | No | Yes | | Credit Mutuel-CIC | Yes | Yes | Yes | | CyberSource through VisaNet | Yes | No | Yes | | FDC Nashville Global | Yes | Yes | Yes | | GPN | No | No | Yes | | OmniPay Direct | Yes | No | Yes | | SIX | Yes | Yes | Yes | ")
  public String getEncryptedKeySerialNumber() {
    return encryptedKeySerialNumber;
  }

  public void setEncryptedKeySerialNumber(String encryptedKeySerialNumber) {
    this.encryptedKeySerialNumber = encryptedKeySerialNumber;
  }

  public Ptsv2paymentsPointOfSaleInformation partnerSdkVersion(String partnerSdkVersion) {
    this.partnerSdkVersion = partnerSdkVersion;
    return this;
  }

   /**
   * Version of the software installed on the POS terminal. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX.  For authorizations and credits, this field is supported only on these processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX 
   * @return partnerSdkVersion
  **/
  @ApiModelProperty(value = "Version of the software installed on the POS terminal. This value is provided by the client software that is installed on the POS terminal.  CyberSource does not forward this value to the processor. Instead, the value is forwarded to the CyberSource reporting functionality.  This field is supported only on American Express Direct, FDC Nashville Global, and SIX.  For authorizations and credits, this field is supported only on these processors: - American Express Direct - Credit Mutuel-CIC - FDC Nashville Global - OmniPay Direct - SIX ")
  public String getPartnerSdkVersion() {
    return partnerSdkVersion;
  }

  public void setPartnerSdkVersion(String partnerSdkVersion) {
    this.partnerSdkVersion = partnerSdkVersion;
  }

  public Ptsv2paymentsPointOfSaleInformation emvApplicationIdentifierAndDedicatedFileName(String emvApplicationIdentifierAndDedicatedFileName) {
    this.emvApplicationIdentifierAndDedicatedFileName = emvApplicationIdentifierAndDedicatedFileName;
    return this;
  }

   /**
   * This 32 byte length-maximum EBCDIC-K value is used to identify which chip application was performed between the terminal and the chip product. The included values are the Application Identifier (AID) and the Dedicated File (DF) name. It is available to early- or full-option VSDC issuers. Only single byte Katakana characters that can map to the EBCDIC-K table expected in the name. 
   * @return emvApplicationIdentifierAndDedicatedFileName
  **/
  @ApiModelProperty(value = "This 32 byte length-maximum EBCDIC-K value is used to identify which chip application was performed between the terminal and the chip product. The included values are the Application Identifier (AID) and the Dedicated File (DF) name. It is available to early- or full-option VSDC issuers. Only single byte Katakana characters that can map to the EBCDIC-K table expected in the name. ")
  public String getEmvApplicationIdentifierAndDedicatedFileName() {
    return emvApplicationIdentifierAndDedicatedFileName;
  }

  public void setEmvApplicationIdentifierAndDedicatedFileName(String emvApplicationIdentifierAndDedicatedFileName) {
    this.emvApplicationIdentifierAndDedicatedFileName = emvApplicationIdentifierAndDedicatedFileName;
  }

  public Ptsv2paymentsPointOfSaleInformation terminalCompliance(String terminalCompliance) {
    this.terminalCompliance = terminalCompliance;
    return this;
  }

   /**
   * Flag that indicates whether the terminal is compliant with standards mandated by the Reserve Bank of India for card-present domestic transactions in India.  Format: - First character indicates whether the terminal supports terminal line encryption (TLE). Possible values:   - 1: Not certified   - 2: Certified - Second character indicates whether the terminal supports Unique Key Per Transaction (UKPT) and Derived Unique Key Per Transaction (DUKPT). Possible values:   - 1: Not certified   - 2: Certified  **Example** &#x60;21&#x60; indicates that the terminal supports TLE but does not support UKPT/DUKPT.  You and the terminal vendors are responsible for terminal certification. If you have questions, contact your acquirer.  This field is supported only for Mastercard transactions on CyberSource through VisaNet.  **Note** On CyberSource through VisaNet, the value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR6 - Position: 92-93 - Field: Mastercard Terminal Compliance Indicator  The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant’s acquirer, who uses this information to facilitate end-of-day clearing processing with payment networks.  #### Used by **Authorization** Required for card-present transactions in India. Otherwise, not used. 
   * @return terminalCompliance
  **/
  @ApiModelProperty(value = "Flag that indicates whether the terminal is compliant with standards mandated by the Reserve Bank of India for card-present domestic transactions in India.  Format: - First character indicates whether the terminal supports terminal line encryption (TLE). Possible values:   - 1: Not certified   - 2: Certified - Second character indicates whether the terminal supports Unique Key Per Transaction (UKPT) and Derived Unique Key Per Transaction (DUKPT). Possible values:   - 1: Not certified   - 2: Certified  **Example** `21` indicates that the terminal supports TLE but does not support UKPT/DUKPT.  You and the terminal vendors are responsible for terminal certification. If you have questions, contact your acquirer.  This field is supported only for Mastercard transactions on CyberSource through VisaNet.  **Note** On CyberSource through VisaNet, the value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR6 - Position: 92-93 - Field: Mastercard Terminal Compliance Indicator  The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant’s acquirer, who uses this information to facilitate end-of-day clearing processing with payment networks.  #### Used by **Authorization** Required for card-present transactions in India. Otherwise, not used. ")
  public String getTerminalCompliance() {
    return terminalCompliance;
  }

  public void setTerminalCompliance(String terminalCompliance) {
    this.terminalCompliance = terminalCompliance;
  }

  public Ptsv2paymentsPointOfSaleInformation isDedicatedHardwareTerminal(String isDedicatedHardwareTerminal) {
    this.isDedicatedHardwareTerminal = isDedicatedHardwareTerminal;
    return this;
  }

   /**
   * Type of mPOS device. Possible values: - 0: Dongle - 1: Phone or tablet  This optional field is supported only for Mastercard transactions on CyberSource through VisaNet.  The value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR6 - Position: 141 - Field: Mastercard mPOS Transaction  The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant’s acquirer, who uses this information to facilitate end-of-day clearing processing with payment networks. 
   * @return isDedicatedHardwareTerminal
  **/
  @ApiModelProperty(value = "Type of mPOS device. Possible values: - 0: Dongle - 1: Phone or tablet  This optional field is supported only for Mastercard transactions on CyberSource through VisaNet.  The value for this field corresponds to the following data in the TC 33 capture file: - Record: CP01 TCR6 - Position: 141 - Field: Mastercard mPOS Transaction  The TC 33 Capture file contains information about the purchases and refunds that a merchant submits to CyberSource. CyberSource through VisaNet creates the TC 33 Capture file at the end of the day and sends it to the merchant’s acquirer, who uses this information to facilitate end-of-day clearing processing with payment networks. ")
  public String getIsDedicatedHardwareTerminal() {
    return isDedicatedHardwareTerminal;
  }

  public void setIsDedicatedHardwareTerminal(String isDedicatedHardwareTerminal) {
    this.isDedicatedHardwareTerminal = isDedicatedHardwareTerminal;
  }

  public Ptsv2paymentsPointOfSaleInformation terminalModel(String terminalModel) {
    this.terminalModel = terminalModel;
    return this;
  }

   /**
   * This is the model name of the reader which is used to accept the payment. Possible values:  - E3555  - P400  - A920 
   * @return terminalModel
  **/
  @ApiModelProperty(value = "This is the model name of the reader which is used to accept the payment. Possible values:  - E3555  - P400  - A920 ")
  public String getTerminalModel() {
    return terminalModel;
  }

  public void setTerminalModel(String terminalModel) {
    this.terminalModel = terminalModel;
  }

  public Ptsv2paymentsPointOfSaleInformation terminalMake(String terminalMake) {
    this.terminalMake = terminalMake;
    return this;
  }

   /**
   * This is the manufacturer name of the reader which is used to accept the payment. Possible values:  - PAX  - Verifone  - Ingenico 
   * @return terminalMake
  **/
  @ApiModelProperty(value = "This is the manufacturer name of the reader which is used to accept the payment. Possible values:  - PAX  - Verifone  - Ingenico ")
  public String getTerminalMake() {
    return terminalMake;
  }

  public void setTerminalMake(String terminalMake) {
    this.terminalMake = terminalMake;
  }

  public Ptsv2paymentsPointOfSaleInformation serviceCode(String serviceCode) {
    this.serviceCode = serviceCode;
    return this;
  }

   /**
   * #### Visa Platform Connect Mastercard service code that is included in the track data. You can extract the service code from the track data and provide it in this API field. This field is supported only for Mastercard on Visa Platform Connect. 
   * @return serviceCode
  **/
  @ApiModelProperty(value = "#### Visa Platform Connect Mastercard service code that is included in the track data. You can extract the service code from the track data and provide it in this API field. This field is supported only for Mastercard on Visa Platform Connect. ")
  public String getServiceCode() {
    return serviceCode;
  }

  public void setServiceCode(String serviceCode) {
    this.serviceCode = serviceCode;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Ptsv2paymentsPointOfSaleInformation ptsv2paymentsPointOfSaleInformation = (Ptsv2paymentsPointOfSaleInformation) o;
    return Objects.equals(this.terminalId, ptsv2paymentsPointOfSaleInformation.terminalId) &&
        Objects.equals(this.terminalSerialNumber, ptsv2paymentsPointOfSaleInformation.terminalSerialNumber) &&
        Objects.equals(this.cardholderVerificationMethodUsed, ptsv2paymentsPointOfSaleInformation.cardholderVerificationMethodUsed) &&
        Objects.equals(this.laneNumber, ptsv2paymentsPointOfSaleInformation.laneNumber) &&
        Objects.equals(this.catLevel, ptsv2paymentsPointOfSaleInformation.catLevel) &&
        Objects.equals(this.entryMode, ptsv2paymentsPointOfSaleInformation.entryMode) &&
        Objects.equals(this.terminalCapability, ptsv2paymentsPointOfSaleInformation.terminalCapability) &&
        Objects.equals(this.operatingEnvironment, ptsv2paymentsPointOfSaleInformation.operatingEnvironment) &&
        Objects.equals(this.emv, ptsv2paymentsPointOfSaleInformation.emv) &&
        Objects.equals(this.amexCapnData, ptsv2paymentsPointOfSaleInformation.amexCapnData) &&
        Objects.equals(this.trackData, ptsv2paymentsPointOfSaleInformation.trackData) &&
        Objects.equals(this.storeAndForwardIndicator, ptsv2paymentsPointOfSaleInformation.storeAndForwardIndicator) &&
        Objects.equals(this.cardholderVerificationMethod, ptsv2paymentsPointOfSaleInformation.cardholderVerificationMethod) &&
        Objects.equals(this.terminalInputCapability, ptsv2paymentsPointOfSaleInformation.terminalInputCapability) &&
        Objects.equals(this.terminalCardCaptureCapability, ptsv2paymentsPointOfSaleInformation.terminalCardCaptureCapability) &&
        Objects.equals(this.terminalOutputCapability, ptsv2paymentsPointOfSaleInformation.terminalOutputCapability) &&
        Objects.equals(this.terminalPinCapability, ptsv2paymentsPointOfSaleInformation.terminalPinCapability) &&
        Objects.equals(this.deviceId, ptsv2paymentsPointOfSaleInformation.deviceId) &&
        Objects.equals(this.pinBlockEncodingFormat, ptsv2paymentsPointOfSaleInformation.pinBlockEncodingFormat) &&
        Objects.equals(this.encryptedPin, ptsv2paymentsPointOfSaleInformation.encryptedPin) &&
        Objects.equals(this.encryptedKeySerialNumber, ptsv2paymentsPointOfSaleInformation.encryptedKeySerialNumber) &&
        Objects.equals(this.partnerSdkVersion, ptsv2paymentsPointOfSaleInformation.partnerSdkVersion) &&
        Objects.equals(this.emvApplicationIdentifierAndDedicatedFileName, ptsv2paymentsPointOfSaleInformation.emvApplicationIdentifierAndDedicatedFileName) &&
        Objects.equals(this.terminalCompliance, ptsv2paymentsPointOfSaleInformation.terminalCompliance) &&
        Objects.equals(this.isDedicatedHardwareTerminal, ptsv2paymentsPointOfSaleInformation.isDedicatedHardwareTerminal) &&
        Objects.equals(this.terminalModel, ptsv2paymentsPointOfSaleInformation.terminalModel) &&
        Objects.equals(this.terminalMake, ptsv2paymentsPointOfSaleInformation.terminalMake) &&
        Objects.equals(this.serviceCode, ptsv2paymentsPointOfSaleInformation.serviceCode);
  }

  @Override
  public int hashCode() {
    return Objects.hash(terminalId, terminalSerialNumber, cardholderVerificationMethodUsed, laneNumber, catLevel, entryMode, terminalCapability, operatingEnvironment, emv, amexCapnData, trackData, storeAndForwardIndicator, cardholderVerificationMethod, terminalInputCapability, terminalCardCaptureCapability, terminalOutputCapability, terminalPinCapability, deviceId, pinBlockEncodingFormat, encryptedPin, encryptedKeySerialNumber, partnerSdkVersion, emvApplicationIdentifierAndDedicatedFileName, terminalCompliance, isDedicatedHardwareTerminal, terminalModel, terminalMake, serviceCode);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Ptsv2paymentsPointOfSaleInformation {\n");
    
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    terminalSerialNumber: ").append(toIndentedString(terminalSerialNumber)).append("\n");
    sb.append("    cardholderVerificationMethodUsed: ").append(toIndentedString(cardholderVerificationMethodUsed)).append("\n");
    sb.append("    laneNumber: ").append(toIndentedString(laneNumber)).append("\n");
    sb.append("    catLevel: ").append(toIndentedString(catLevel)).append("\n");
    sb.append("    entryMode: ").append(toIndentedString(entryMode)).append("\n");
    sb.append("    terminalCapability: ").append(toIndentedString(terminalCapability)).append("\n");
    sb.append("    operatingEnvironment: ").append(toIndentedString(operatingEnvironment)).append("\n");
    sb.append("    emv: ").append(toIndentedString(emv)).append("\n");
    sb.append("    amexCapnData: ").append(toIndentedString(amexCapnData)).append("\n");
    sb.append("    trackData: ").append(toIndentedString(trackData)).append("\n");
    sb.append("    storeAndForwardIndicator: ").append(toIndentedString(storeAndForwardIndicator)).append("\n");
    sb.append("    cardholderVerificationMethod: ").append(toIndentedString(cardholderVerificationMethod)).append("\n");
    sb.append("    terminalInputCapability: ").append(toIndentedString(terminalInputCapability)).append("\n");
    sb.append("    terminalCardCaptureCapability: ").append(toIndentedString(terminalCardCaptureCapability)).append("\n");
    sb.append("    terminalOutputCapability: ").append(toIndentedString(terminalOutputCapability)).append("\n");
    sb.append("    terminalPinCapability: ").append(toIndentedString(terminalPinCapability)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    pinBlockEncodingFormat: ").append(toIndentedString(pinBlockEncodingFormat)).append("\n");
    sb.append("    encryptedPin: ").append(toIndentedString(encryptedPin)).append("\n");
    sb.append("    encryptedKeySerialNumber: ").append(toIndentedString(encryptedKeySerialNumber)).append("\n");
    sb.append("    partnerSdkVersion: ").append(toIndentedString(partnerSdkVersion)).append("\n");
    sb.append("    emvApplicationIdentifierAndDedicatedFileName: ").append(toIndentedString(emvApplicationIdentifierAndDedicatedFileName)).append("\n");
    sb.append("    terminalCompliance: ").append(toIndentedString(terminalCompliance)).append("\n");
    sb.append("    isDedicatedHardwareTerminal: ").append(toIndentedString(isDedicatedHardwareTerminal)).append("\n");
    sb.append("    terminalModel: ").append(toIndentedString(terminalModel)).append("\n");
    sb.append("    terminalMake: ").append(toIndentedString(terminalMake)).append("\n");
    sb.append("    serviceCode: ").append(toIndentedString(serviceCode)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

