/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.CreateAdhocReportRequest;
import Model.ReportingV3ReportsGet200Response;
import Model.ReportingV3ReportsIdGet200Response;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import utilities.tracking.SdkTracker;

public class ReportsApi {
    private static Logger logger = LogManager.getLogger(ReportsApi.class);
    private ApiClient apiClient;

    public ReportsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ReportsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createReportCall(CreateAdhocReportRequest createAdhocReportRequest, String organizationId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(createAdhocReportRequest, CreateAdhocReportRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment());
        String localVarPath = "/reporting/v3/reports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (organizationId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "organizationId", organizationId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createReportValidateBeforeCall(CreateAdhocReportRequest createAdhocReportRequest, String organizationId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (createAdhocReportRequest == null) {
            logger.error("Missing the required parameter 'createAdhocReportRequest' when calling createReport(Async)");
            throw new ApiException("Missing the required parameter 'createAdhocReportRequest' when calling createReport(Async)");
        }
        Call call = this.createReportCall(createAdhocReportRequest, organizationId, progressListener, progressRequestListener);
        return call;
    }

    public void createReport(CreateAdhocReportRequest createAdhocReportRequest, String organizationId) throws ApiException {
        logger.info("CALL TO METHOD 'createReport' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        this.createReportWithHttpInfo(createAdhocReportRequest, organizationId);
    }

    public ApiResponse<Void> createReportWithHttpInfo(CreateAdhocReportRequest createAdhocReportRequest, String organizationId) throws ApiException {
        Call call = this.createReportValidateBeforeCall(createAdhocReportRequest, organizationId, null, null);
        return this.apiClient.execute(call);
    }

    public Call createReportAsync(CreateAdhocReportRequest createAdhocReportRequest, String organizationId, final ApiCallback<Void> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createReportValidateBeforeCall(createAdhocReportRequest, organizationId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getReportByReportIdCall(String reportId, String organizationId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        String localVarPath = "/reporting/v3/reports/{reportId}".replaceAll("\\{reportId\\}", this.apiClient.escapeString(reportId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (organizationId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "organizationId", organizationId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json", "application/xml"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getReportByReportIdValidateBeforeCall(String reportId, String organizationId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (reportId == null) {
            logger.error("Missing the required parameter 'reportId' when calling getReportByReportId(Async)");
            throw new ApiException("Missing the required parameter 'reportId' when calling getReportByReportId(Async)");
        }
        Call call = this.getReportByReportIdCall(reportId, organizationId, progressListener, progressRequestListener);
        return call;
    }

    public ReportingV3ReportsIdGet200Response getReportByReportId(String reportId, String organizationId) throws ApiException {
        logger.info("CALL TO METHOD 'getReportByReportId' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<ReportingV3ReportsIdGet200Response> resp = this.getReportByReportIdWithHttpInfo(reportId, organizationId);
        logger.info("CALL TO METHOD 'getReportByReportId' ENDED");
        return resp.getData();
    }

    public ApiResponse<ReportingV3ReportsIdGet200Response> getReportByReportIdWithHttpInfo(String reportId, String organizationId) throws ApiException {
        Call call = this.getReportByReportIdValidateBeforeCall(reportId, organizationId, null, null);
        Type localVarReturnType = new TypeToken<ReportingV3ReportsIdGet200Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getReportByReportIdAsync(String reportId, String organizationId, final ApiCallback<ReportingV3ReportsIdGet200Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getReportByReportIdValidateBeforeCall(reportId, organizationId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ReportingV3ReportsIdGet200Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call searchReportsCall(DateTime startTime, DateTime endTime, String timeQueryType, String organizationId, String reportMimeType, String reportFrequency, String reportName, Integer reportDefinitionId, String reportStatus, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        String localVarPath = "/reporting/v3/reports";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (organizationId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "organizationId", organizationId));
        }
        if (startTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "startTime", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "endTime", endTime));
        }
        if (timeQueryType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "timeQueryType", timeQueryType));
        }
        if (reportMimeType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "reportMimeType", reportMimeType));
        }
        if (reportFrequency != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "reportFrequency", reportFrequency));
        }
        if (reportName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "reportName", reportName));
        }
        if (reportDefinitionId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "reportDefinitionId", reportDefinitionId));
        }
        if (reportStatus != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "reportStatus", reportStatus));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call searchReportsValidateBeforeCall(DateTime startTime, DateTime endTime, String timeQueryType, String organizationId, String reportMimeType, String reportFrequency, String reportName, Integer reportDefinitionId, String reportStatus, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (startTime == null) {
            logger.error("Missing the required parameter 'startTime' when calling searchReports(Async)");
            throw new ApiException("Missing the required parameter 'startTime' when calling searchReports(Async)");
        }
        if (endTime == null) {
            logger.error("Missing the required parameter 'endTime' when calling searchReports(Async)");
            throw new ApiException("Missing the required parameter 'endTime' when calling searchReports(Async)");
        }
        if (timeQueryType == null) {
            logger.error("Missing the required parameter 'timeQueryType' when calling searchReports(Async)");
            throw new ApiException("Missing the required parameter 'timeQueryType' when calling searchReports(Async)");
        }
        Call call = this.searchReportsCall(startTime, endTime, timeQueryType, organizationId, reportMimeType, reportFrequency, reportName, reportDefinitionId, reportStatus, progressListener, progressRequestListener);
        return call;
    }

    public ReportingV3ReportsGet200Response searchReports(DateTime startTime, DateTime endTime, String timeQueryType, String organizationId, String reportMimeType, String reportFrequency, String reportName, Integer reportDefinitionId, String reportStatus) throws ApiException {
        logger.info("CALL TO METHOD 'searchReports' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<ReportingV3ReportsGet200Response> resp = this.searchReportsWithHttpInfo(startTime, endTime, timeQueryType, organizationId, reportMimeType, reportFrequency, reportName, reportDefinitionId, reportStatus);
        logger.info("CALL TO METHOD 'searchReports' ENDED");
        return resp.getData();
    }

    public ApiResponse<ReportingV3ReportsGet200Response> searchReportsWithHttpInfo(DateTime startTime, DateTime endTime, String timeQueryType, String organizationId, String reportMimeType, String reportFrequency, String reportName, Integer reportDefinitionId, String reportStatus) throws ApiException {
        Call call = this.searchReportsValidateBeforeCall(startTime, endTime, timeQueryType, organizationId, reportMimeType, reportFrequency, reportName, reportDefinitionId, reportStatus, null, null);
        Type localVarReturnType = new TypeToken<ReportingV3ReportsGet200Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call searchReportsAsync(DateTime startTime, DateTime endTime, String timeQueryType, String organizationId, String reportMimeType, String reportFrequency, String reportName, Integer reportDefinitionId, String reportStatus, final ApiCallback<ReportingV3ReportsGet200Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.searchReportsValidateBeforeCall(startTime, endTime, timeQueryType, organizationId, reportMimeType, reportFrequency, reportName, reportDefinitionId, reportStatus, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ReportingV3ReportsGet200Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

