/*
 * Decompiled with CFR 0.152.
 */
package Model;

import Model.CardProcessingConfigCommonMerchantDescriptorInformation;
import Model.CardProcessingConfigCommonProcessors;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CardProcessingConfigCommon {
    @SerializedName(value="processors")
    private Map<String, CardProcessingConfigCommonProcessors> processors = null;
    @SerializedName(value="amexVendorCode")
    private String amexVendorCode = null;
    @SerializedName(value="defaultAuthTypeCode")
    private DefaultAuthTypeCodeEnum defaultAuthTypeCode = null;
    @SerializedName(value="masterCardAssignedId")
    private String masterCardAssignedId = null;
    @SerializedName(value="enablePartialAuth")
    private Boolean enablePartialAuth = null;
    @SerializedName(value="merchantCategoryCode")
    private String merchantCategoryCode = null;
    @SerializedName(value="sicCode")
    private String sicCode = null;
    @SerializedName(value="foodAndConsumerServiceId")
    private String foodAndConsumerServiceId = null;
    @SerializedName(value="enableSplitShipment")
    private Boolean enableSplitShipment = null;
    @SerializedName(value="enableInterchangeOptimization")
    private Boolean enableInterchangeOptimization = null;
    @SerializedName(value="visaDelegatedAuthenticationId")
    private String visaDelegatedAuthenticationId = null;
    @SerializedName(value="creditCardRefundLimitPercent")
    private String creditCardRefundLimitPercent = null;
    @SerializedName(value="businessCenterCreditCardRefundLimitPercent")
    private String businessCenterCreditCardRefundLimitPercent = null;
    @SerializedName(value="allowCapturesGreaterThanAuthorizations")
    private Boolean allowCapturesGreaterThanAuthorizations = null;
    @SerializedName(value="enableDuplicateMerchantReferenceNumberBlocking")
    private Boolean enableDuplicateMerchantReferenceNumberBlocking = null;
    @SerializedName(value="domesticMerchantId")
    private Boolean domesticMerchantId = null;
    @SerializedName(value="processLevel3Data")
    private String processLevel3Data = null;
    @SerializedName(value="subMerchantId")
    private String subMerchantId = null;
    @SerializedName(value="subMerchantBusinessName")
    private String subMerchantBusinessName = null;
    @SerializedName(value="preferCobadgedSecondaryBrand")
    private Boolean preferCobadgedSecondaryBrand = null;
    @SerializedName(value="merchantDescriptorInformation")
    private CardProcessingConfigCommonMerchantDescriptorInformation merchantDescriptorInformation = null;

    public CardProcessingConfigCommon processors(Map<String, CardProcessingConfigCommonProcessors> processors) {
        this.processors = processors;
        return this;
    }

    public CardProcessingConfigCommon putProcessorsItem(String key, CardProcessingConfigCommonProcessors processorsItem) {
        if (this.processors == null) {
            this.processors = new HashMap<String, CardProcessingConfigCommonProcessors>();
        }
        this.processors.put(key, processorsItem);
        return this;
    }

    @ApiModelProperty(value="e.g. * amexdirect * barclays2 * CUP * EFTPOS * fdiglobal * gpx * smartfdc * tsys * vero * VPC  For VPC, CUP and EFTPOS processors, replace the processor name from VPC or CUP or EFTPOS to the actual processor name in the sample request. e.g. replace VPC with &lt;your vpc processor&gt; ")
    public Map<String, CardProcessingConfigCommonProcessors> getProcessors() {
        return this.processors;
    }

    public void setProcessors(Map<String, CardProcessingConfigCommonProcessors> processors) {
        this.processors = processors;
    }

    public CardProcessingConfigCommon amexVendorCode(String amexVendorCode) {
        this.amexVendorCode = amexVendorCode;
        return this;
    }

    @ApiModelProperty(value="Vendor code assigned by American Express. Applicable for TSYS (tsys) processor.")
    public String getAmexVendorCode() {
        return this.amexVendorCode;
    }

    public void setAmexVendorCode(String amexVendorCode) {
        this.amexVendorCode = amexVendorCode;
    }

    public CardProcessingConfigCommon defaultAuthTypeCode(DefaultAuthTypeCodeEnum defaultAuthTypeCode) {
        this.defaultAuthTypeCode = defaultAuthTypeCode;
        return this;
    }

    @ApiModelProperty(value="Authorization Finality indicator. Please note that the input can be in small case or capitals but response is in small case as of now. It will be made capitals everywhere in the next version. Applicable for Elavon Americas (elavonamericas), TSYS (tsys), Barclays (barclays2), Streamline (streamline2), Six (six), Barclays HISO (barclayshiso), GPN (gpn), FDI Global (fdiglobal), GPX (gpx), Paymentech Tampa (paymentechtampa), FDC Nashville (smartfdc), VPC and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>Barclays</td><td>cnp, cp, hybrid</td><td>No</td><td>FINAL</td></tr> <tr><td>Barclays HISO</td><td>cnp, cp, hybrid</td><td>Yes</td><td>FINAL</td></tr> </table> ")
    public DefaultAuthTypeCodeEnum getDefaultAuthTypeCode() {
        return this.defaultAuthTypeCode;
    }

    public void setDefaultAuthTypeCode(DefaultAuthTypeCodeEnum defaultAuthTypeCode) {
        this.defaultAuthTypeCode = defaultAuthTypeCode;
    }

    public CardProcessingConfigCommon masterCardAssignedId(String masterCardAssignedId) {
        this.masterCardAssignedId = masterCardAssignedId;
        return this;
    }

    @ApiModelProperty(value="MAID aka MasterCard assigned ID, MasterCard equivalent of Merchant Verification Value by Visa. Applicable for VPC, GPX (gpx) and FDI Global (fdiglobal) processors.")
    public String getMasterCardAssignedId() {
        return this.masterCardAssignedId;
    }

    public void setMasterCardAssignedId(String masterCardAssignedId) {
        this.masterCardAssignedId = masterCardAssignedId;
    }

    public CardProcessingConfigCommon enablePartialAuth(Boolean enablePartialAuth) {
        this.enablePartialAuth = enablePartialAuth;
        return this;
    }

    @ApiModelProperty(value="Allow merchants to accept partial authorization approvals. Applicable for Elavon Americas (elavonamericas), VPC, GPX (gpx), FDI Global (fdiglobal), FDC Nashville (smartfdc), GPN (gpn), TSYS (tsys), American Express Direct (amexdirect), Paymentech Tampa (paymentechtampa) and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Default Value</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>No</td></tr> </table> ")
    public Boolean getEnablePartialAuth() {
        return this.enablePartialAuth;
    }

    public void setEnablePartialAuth(Boolean enablePartialAuth) {
        this.enablePartialAuth = enablePartialAuth;
    }

    public CardProcessingConfigCommon merchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
        return this;
    }

    @ApiModelProperty(value="Indicates type of business product or service of the merchant. Applicable for Chase Paymentech Salem (chasepaymentechsalem), FDI Global (fdiglobal), RUPAY, Elavon Americas (elavonamericas), American Express Direct (amexdirect), CMCIC (cmcic), GPX (gpx), VPC, TSYS (tsys), EFTPOS, CUP, Paymentech Tampa (paymentechtampa), CB2A, Barclays (barclays2), Prisma (prisma) and GPN (gpn) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>Barclays</td><td>cnp</td><td>No</td><td>4</td><td>4</td><td>^[0-9]+$</td></tr> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>Yes</td><td>4</td><td>4</td><td>^[0-9]+$</td></tr> </table> ")
    public String getMerchantCategoryCode() {
        return this.merchantCategoryCode;
    }

    public void setMerchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
    }

    public CardProcessingConfigCommon sicCode(String sicCode) {
        this.sicCode = sicCode;
        return this;
    }

    @ApiModelProperty(value="The Standard Industrial Classification (SIC) are four-digit codes that categorize the industries that companies belong to based on their business activities. Standard Industrial Classification codes were mostly replaced by the six-digit North American Industry Classification System (NAICS). Applicable for VPC and GPX (gpx) processors.")
    public String getSicCode() {
        return this.sicCode;
    }

    public void setSicCode(String sicCode) {
        this.sicCode = sicCode;
    }

    public CardProcessingConfigCommon foodAndConsumerServiceId(String foodAndConsumerServiceId) {
        this.foodAndConsumerServiceId = foodAndConsumerServiceId;
        return this;
    }

    @ApiModelProperty(value="Food and Consumer Service ID. Identifies the merchant as being certified and approved to accept Food Stamps. Applicable for GPX (gpx) processor.")
    public String getFoodAndConsumerServiceId() {
        return this.foodAndConsumerServiceId;
    }

    public void setFoodAndConsumerServiceId(String foodAndConsumerServiceId) {
        this.foodAndConsumerServiceId = foodAndConsumerServiceId;
    }

    public CardProcessingConfigCommon enableSplitShipment(Boolean enableSplitShipment) {
        this.enableSplitShipment = enableSplitShipment;
        return this;
    }

    @ApiModelProperty(value="Enables you to split an order into multiple shipments with multiple captures. This feature is provided by CyberSource and supports three different scenarios:  * multiple authorizations * multiple captures * multiple authorizations with multiple captures  Applicable for VPC processors. ")
    public Boolean getEnableSplitShipment() {
        return this.enableSplitShipment;
    }

    public void setEnableSplitShipment(Boolean enableSplitShipment) {
        this.enableSplitShipment = enableSplitShipment;
    }

    public CardProcessingConfigCommon enableInterchangeOptimization(Boolean enableInterchangeOptimization) {
        this.enableInterchangeOptimization = enableInterchangeOptimization;
        return this;
    }

    @ApiModelProperty(value="Reduces your interchange fees by using automatic authorization refresh and automatic partial authorization reversal. Applicable for VPC processors.")
    public Boolean getEnableInterchangeOptimization() {
        return this.enableInterchangeOptimization;
    }

    public void setEnableInterchangeOptimization(Boolean enableInterchangeOptimization) {
        this.enableInterchangeOptimization = enableInterchangeOptimization;
    }

    public CardProcessingConfigCommon visaDelegatedAuthenticationId(String visaDelegatedAuthenticationId) {
        this.visaDelegatedAuthenticationId = visaDelegatedAuthenticationId;
        return this;
    }

    @ApiModelProperty(value="Identifier provided to merchants who opt for Visa's delegated authorization program. Applicable for VPC processors.")
    public String getVisaDelegatedAuthenticationId() {
        return this.visaDelegatedAuthenticationId;
    }

    public void setVisaDelegatedAuthenticationId(String visaDelegatedAuthenticationId) {
        this.visaDelegatedAuthenticationId = visaDelegatedAuthenticationId;
    }

    public CardProcessingConfigCommon creditCardRefundLimitPercent(String creditCardRefundLimitPercent) {
        this.creditCardRefundLimitPercent = creditCardRefundLimitPercent;
        return this;
    }

    @ApiModelProperty(value="Blocks over-refunds when the aggregated refund amount is higher than the percentage set for this field. Applicable for GPX (gpx), VPC and Chase Paymentech Salem (chasepaymentechsalem) processors.")
    public String getCreditCardRefundLimitPercent() {
        return this.creditCardRefundLimitPercent;
    }

    public void setCreditCardRefundLimitPercent(String creditCardRefundLimitPercent) {
        this.creditCardRefundLimitPercent = creditCardRefundLimitPercent;
    }

    public CardProcessingConfigCommon businessCenterCreditCardRefundLimitPercent(String businessCenterCreditCardRefundLimitPercent) {
        this.businessCenterCreditCardRefundLimitPercent = businessCenterCreditCardRefundLimitPercent;
        return this;
    }

    @ApiModelProperty(value="Limits refunds to the percentage set in this field. Applicable for GPX (gpx) and VPC processors.")
    public String getBusinessCenterCreditCardRefundLimitPercent() {
        return this.businessCenterCreditCardRefundLimitPercent;
    }

    public void setBusinessCenterCreditCardRefundLimitPercent(String businessCenterCreditCardRefundLimitPercent) {
        this.businessCenterCreditCardRefundLimitPercent = businessCenterCreditCardRefundLimitPercent;
    }

    public CardProcessingConfigCommon allowCapturesGreaterThanAuthorizations(Boolean allowCapturesGreaterThanAuthorizations) {
        this.allowCapturesGreaterThanAuthorizations = allowCapturesGreaterThanAuthorizations;
        return this;
    }

    @ApiModelProperty(value="Enables this merchant account to capture amounts greater than the authorization amount. Applicable for GPX (gpx), VPC, Paymentech Tampa (paymentechtampa) and Chase Paymentech Salem (chasepaymentechsalem) processors.")
    public Boolean getAllowCapturesGreaterThanAuthorizations() {
        return this.allowCapturesGreaterThanAuthorizations;
    }

    public void setAllowCapturesGreaterThanAuthorizations(Boolean allowCapturesGreaterThanAuthorizations) {
        this.allowCapturesGreaterThanAuthorizations = allowCapturesGreaterThanAuthorizations;
    }

    public CardProcessingConfigCommon enableDuplicateMerchantReferenceNumberBlocking(Boolean enableDuplicateMerchantReferenceNumberBlocking) {
        this.enableDuplicateMerchantReferenceNumberBlocking = enableDuplicateMerchantReferenceNumberBlocking;
        return this;
    }

    @ApiModelProperty(value="Helps prevent duplicate transactions. Applicable for VPC, GPX (gpx) and Chase Paymentech Salem (chasepaymentechsalem) processors.")
    public Boolean getEnableDuplicateMerchantReferenceNumberBlocking() {
        return this.enableDuplicateMerchantReferenceNumberBlocking;
    }

    public void setEnableDuplicateMerchantReferenceNumberBlocking(Boolean enableDuplicateMerchantReferenceNumberBlocking) {
        this.enableDuplicateMerchantReferenceNumberBlocking = enableDuplicateMerchantReferenceNumberBlocking;
    }

    public CardProcessingConfigCommon domesticMerchantId(Boolean domesticMerchantId) {
        this.domesticMerchantId = domesticMerchantId;
        return this;
    }

    @ApiModelProperty(value="This is a local merchant ID used by merchants in addition to the conventional merchant ID. This value is sent to the issuer. Applicable for VPC and Prisma (prisma) processors.")
    public Boolean getDomesticMerchantId() {
        return this.domesticMerchantId;
    }

    public void setDomesticMerchantId(Boolean domesticMerchantId) {
        this.domesticMerchantId = domesticMerchantId;
    }

    public CardProcessingConfigCommon processLevel3Data(String processLevel3Data) {
        this.processLevel3Data = processLevel3Data;
        return this;
    }

    @ApiModelProperty(value="Indicates whether merchant processes Level 3 transactions. Applicable for TSYS (tsys), Barclays (barclays2), Paymentech Tampa (paymentechtampa), FDI Global (fdiglobal), Elavon Americas (elavonamericas) and Chase Paymentech Salem (chasepaymentechsalem) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th></tr></thead> <tr><td>Barclays</td><td>cnp</td><td>No</td></tr> </table> ")
    public String getProcessLevel3Data() {
        return this.processLevel3Data;
    }

    public void setProcessLevel3Data(String processLevel3Data) {
        this.processLevel3Data = processLevel3Data;
    }

    public CardProcessingConfigCommon subMerchantId(String subMerchantId) {
        this.subMerchantId = subMerchantId;
        return this;
    }

    @ApiModelProperty(value="The ID assigned to the sub-merchant. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>1</td><td>20</td><td>^[0-9a-zA-Z&#92;-&#92;_&#92;,\\s.]+$</td></tr> </table> ")
    public String getSubMerchantId() {
        return this.subMerchantId;
    }

    public void setSubMerchantId(String subMerchantId) {
        this.subMerchantId = subMerchantId;
    }

    public CardProcessingConfigCommon subMerchantBusinessName(String subMerchantBusinessName) {
        this.subMerchantBusinessName = subMerchantBusinessName;
        return this;
    }

    @ApiModelProperty(value="Sub-merchant's business name. Applicable for American Express Direct (amexdirect) processor.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>1</td><td>37</td><td>^[0-9a-zA-Z&#92;-&#92;_&#92;,\\s.]+$</td></tr> </table> ")
    public String getSubMerchantBusinessName() {
        return this.subMerchantBusinessName;
    }

    public void setSubMerchantBusinessName(String subMerchantBusinessName) {
        this.subMerchantBusinessName = subMerchantBusinessName;
    }

    public CardProcessingConfigCommon preferCobadgedSecondaryBrand(Boolean preferCobadgedSecondaryBrand) {
        this.preferCobadgedSecondaryBrand = preferCobadgedSecondaryBrand;
        return this;
    }

    @ApiModelProperty(value="It denotes merchant's preference on secondary brand for routing in case of co-branded cards. Applicable for EFTPOS processors.")
    public Boolean getPreferCobadgedSecondaryBrand() {
        return this.preferCobadgedSecondaryBrand;
    }

    public void setPreferCobadgedSecondaryBrand(Boolean preferCobadgedSecondaryBrand) {
        this.preferCobadgedSecondaryBrand = preferCobadgedSecondaryBrand;
    }

    public CardProcessingConfigCommon merchantDescriptorInformation(CardProcessingConfigCommonMerchantDescriptorInformation merchantDescriptorInformation) {
        this.merchantDescriptorInformation = merchantDescriptorInformation;
        return this;
    }

    @ApiModelProperty(value="")
    public CardProcessingConfigCommonMerchantDescriptorInformation getMerchantDescriptorInformation() {
        return this.merchantDescriptorInformation;
    }

    public void setMerchantDescriptorInformation(CardProcessingConfigCommonMerchantDescriptorInformation merchantDescriptorInformation) {
        this.merchantDescriptorInformation = merchantDescriptorInformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardProcessingConfigCommon cardProcessingConfigCommon = (CardProcessingConfigCommon)o;
        return Objects.equals(this.processors, cardProcessingConfigCommon.processors) && Objects.equals(this.amexVendorCode, cardProcessingConfigCommon.amexVendorCode) && Objects.equals((Object)this.defaultAuthTypeCode, (Object)cardProcessingConfigCommon.defaultAuthTypeCode) && Objects.equals(this.masterCardAssignedId, cardProcessingConfigCommon.masterCardAssignedId) && Objects.equals(this.enablePartialAuth, cardProcessingConfigCommon.enablePartialAuth) && Objects.equals(this.merchantCategoryCode, cardProcessingConfigCommon.merchantCategoryCode) && Objects.equals(this.sicCode, cardProcessingConfigCommon.sicCode) && Objects.equals(this.foodAndConsumerServiceId, cardProcessingConfigCommon.foodAndConsumerServiceId) && Objects.equals(this.enableSplitShipment, cardProcessingConfigCommon.enableSplitShipment) && Objects.equals(this.enableInterchangeOptimization, cardProcessingConfigCommon.enableInterchangeOptimization) && Objects.equals(this.visaDelegatedAuthenticationId, cardProcessingConfigCommon.visaDelegatedAuthenticationId) && Objects.equals(this.creditCardRefundLimitPercent, cardProcessingConfigCommon.creditCardRefundLimitPercent) && Objects.equals(this.businessCenterCreditCardRefundLimitPercent, cardProcessingConfigCommon.businessCenterCreditCardRefundLimitPercent) && Objects.equals(this.allowCapturesGreaterThanAuthorizations, cardProcessingConfigCommon.allowCapturesGreaterThanAuthorizations) && Objects.equals(this.enableDuplicateMerchantReferenceNumberBlocking, cardProcessingConfigCommon.enableDuplicateMerchantReferenceNumberBlocking) && Objects.equals(this.domesticMerchantId, cardProcessingConfigCommon.domesticMerchantId) && Objects.equals(this.processLevel3Data, cardProcessingConfigCommon.processLevel3Data) && Objects.equals(this.subMerchantId, cardProcessingConfigCommon.subMerchantId) && Objects.equals(this.subMerchantBusinessName, cardProcessingConfigCommon.subMerchantBusinessName) && Objects.equals(this.preferCobadgedSecondaryBrand, cardProcessingConfigCommon.preferCobadgedSecondaryBrand) && Objects.equals(this.merchantDescriptorInformation, cardProcessingConfigCommon.merchantDescriptorInformation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.processors, this.amexVendorCode, this.defaultAuthTypeCode, this.masterCardAssignedId, this.enablePartialAuth, this.merchantCategoryCode, this.sicCode, this.foodAndConsumerServiceId, this.enableSplitShipment, this.enableInterchangeOptimization, this.visaDelegatedAuthenticationId, this.creditCardRefundLimitPercent, this.businessCenterCreditCardRefundLimitPercent, this.allowCapturesGreaterThanAuthorizations, this.enableDuplicateMerchantReferenceNumberBlocking, this.domesticMerchantId, this.processLevel3Data, this.subMerchantId, this.subMerchantBusinessName, this.preferCobadgedSecondaryBrand, this.merchantDescriptorInformation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardProcessingConfigCommon {\n");
        sb.append("    processors: ").append(this.toIndentedString(this.processors)).append("\n");
        sb.append("    amexVendorCode: ").append(this.toIndentedString(this.amexVendorCode)).append("\n");
        sb.append("    defaultAuthTypeCode: ").append(this.toIndentedString((Object)this.defaultAuthTypeCode)).append("\n");
        sb.append("    masterCardAssignedId: ").append(this.toIndentedString(this.masterCardAssignedId)).append("\n");
        sb.append("    enablePartialAuth: ").append(this.toIndentedString(this.enablePartialAuth)).append("\n");
        sb.append("    merchantCategoryCode: ").append(this.toIndentedString(this.merchantCategoryCode)).append("\n");
        sb.append("    sicCode: ").append(this.toIndentedString(this.sicCode)).append("\n");
        sb.append("    foodAndConsumerServiceId: ").append(this.toIndentedString(this.foodAndConsumerServiceId)).append("\n");
        sb.append("    enableSplitShipment: ").append(this.toIndentedString(this.enableSplitShipment)).append("\n");
        sb.append("    enableInterchangeOptimization: ").append(this.toIndentedString(this.enableInterchangeOptimization)).append("\n");
        sb.append("    visaDelegatedAuthenticationId: ").append(this.toIndentedString(this.visaDelegatedAuthenticationId)).append("\n");
        sb.append("    creditCardRefundLimitPercent: ").append(this.toIndentedString(this.creditCardRefundLimitPercent)).append("\n");
        sb.append("    businessCenterCreditCardRefundLimitPercent: ").append(this.toIndentedString(this.businessCenterCreditCardRefundLimitPercent)).append("\n");
        sb.append("    allowCapturesGreaterThanAuthorizations: ").append(this.toIndentedString(this.allowCapturesGreaterThanAuthorizations)).append("\n");
        sb.append("    enableDuplicateMerchantReferenceNumberBlocking: ").append(this.toIndentedString(this.enableDuplicateMerchantReferenceNumberBlocking)).append("\n");
        sb.append("    domesticMerchantId: ").append(this.toIndentedString(this.domesticMerchantId)).append("\n");
        sb.append("    processLevel3Data: ").append(this.toIndentedString(this.processLevel3Data)).append("\n");
        sb.append("    subMerchantId: ").append(this.toIndentedString(this.subMerchantId)).append("\n");
        sb.append("    subMerchantBusinessName: ").append(this.toIndentedString(this.subMerchantBusinessName)).append("\n");
        sb.append("    preferCobadgedSecondaryBrand: ").append(this.toIndentedString(this.preferCobadgedSecondaryBrand)).append("\n");
        sb.append("    merchantDescriptorInformation: ").append(this.toIndentedString(this.merchantDescriptorInformation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DefaultAuthTypeCodeEnum {
        PRE("PRE"),
        FINAL("FINAL"),
        UNDEFINED("UNDEFINED");

        private String value;

        private DefaultAuthTypeCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DefaultAuthTypeCodeEnum fromValue(String text) {
            for (DefaultAuthTypeCodeEnum b : DefaultAuthTypeCodeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DefaultAuthTypeCodeEnum> {
            public void write(JsonWriter jsonWriter, DefaultAuthTypeCodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DefaultAuthTypeCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DefaultAuthTypeCodeEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

