/*
 * CyberSource Merged Spec
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package Model;

import java.util.Objects;
import Model.PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationIvr;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation
 */

public class RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation {
  @SerializedName("accessToken")
  private String accessToken = null;

  @SerializedName("acsRenderingType")
  private String acsRenderingType = null;

  @SerializedName("acsTransactionId")
  private String acsTransactionId = null;

  @SerializedName("acsUrl")
  private String acsUrl = null;

  @SerializedName("authenticationPath")
  private String authenticationPath = null;

  @SerializedName("authorizationPayload")
  private String authorizationPayload = null;

  @SerializedName("authenticationType")
  private String authenticationType = null;

  @SerializedName("authenticationTransactionId")
  private String authenticationTransactionId = null;

  @SerializedName("authenticationTransactionContextId")
  private String authenticationTransactionContextId = null;

  @SerializedName("validityPeriod")
  private Integer validityPeriod = null;

  @SerializedName("cardholderMessage")
  private String cardholderMessage = null;

  @SerializedName("cavv")
  private String cavv = null;

  @SerializedName("cavvAlgorithm")
  private String cavvAlgorithm = null;

  @SerializedName("challengeCancelCode")
  private String challengeCancelCode = null;

  @SerializedName("challengeRequired")
  private String challengeRequired = null;

  @SerializedName("decoupledAuthenticationIndicator")
  private String decoupledAuthenticationIndicator = null;

  @SerializedName("directoryServerErrorCode")
  private String directoryServerErrorCode = null;

  @SerializedName("directoryServerErrorDescription")
  private String directoryServerErrorDescription = null;

  @SerializedName("ecommerceIndicator")
  private String ecommerceIndicator = null;

  @SerializedName("eci")
  private String eci = null;

  @SerializedName("eciRaw")
  private String eciRaw = null;

  @SerializedName("effectiveAuthenticationType")
  private String effectiveAuthenticationType = null;

  @SerializedName("ivr")
  private PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationIvr ivr = null;

  @SerializedName("networkScore")
  private String networkScore = null;

  @SerializedName("pareq")
  private String pareq = null;

  @SerializedName("paresStatus")
  private String paresStatus = null;

  @SerializedName("proofXml")
  private String proofXml = null;

  @SerializedName("proxyPan")
  private String proxyPan = null;

  @SerializedName("sdkTransactionId")
  private String sdkTransactionId = null;

  @SerializedName("signedParesStatusReason")
  private String signedParesStatusReason = null;

  @SerializedName("specificationVersion")
  private String specificationVersion = null;

  @SerializedName("stepUpUrl")
  private String stepUpUrl = null;

  @SerializedName("threeDSServerTransactionId")
  private String threeDSServerTransactionId = null;

  @SerializedName("ucafAuthenticationData")
  private String ucafAuthenticationData = null;

  @SerializedName("ucafCollectionIndicator")
  private String ucafCollectionIndicator = null;

  @SerializedName("veresEnrolled")
  private String veresEnrolled = null;

  @SerializedName("whiteListStatusSource")
  private String whiteListStatusSource = null;

  @SerializedName("xid")
  private String xid = null;

  @SerializedName("directoryServerTransactionId")
  private String directoryServerTransactionId = null;

  @SerializedName("acsOperatorID")
  private String acsOperatorID = null;

  @SerializedName("acsReferenceNumber")
  private String acsReferenceNumber = null;

  @SerializedName("idciDecision")
  private String idciDecision = null;

  @SerializedName("idciReasonCode1")
  private String idciReasonCode1 = null;

  @SerializedName("idciReasonCode2")
  private String idciReasonCode2 = null;

  @SerializedName("idciScore")
  private Integer idciScore = null;

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation accessToken(String accessToken) {
    this.accessToken = accessToken;
    return this;
  }

   /**
   * JSON Web Token (JWT) used to authenticate the consumer with the authentication provider, such as, CardinalCommerce or Rupay. Note - Max Length of this field is 2048 characters. 
   * @return accessToken
  **/
  @ApiModelProperty(value = "JSON Web Token (JWT) used to authenticate the consumer with the authentication provider, such as, CardinalCommerce or Rupay. Note - Max Length of this field is 2048 characters. ")
  public String getAccessToken() {
    return accessToken;
  }

  public void setAccessToken(String accessToken) {
    this.accessToken = accessToken;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation acsRenderingType(String acsRenderingType) {
    this.acsRenderingType = acsRenderingType;
    return this;
  }

   /**
   * Identifies the UI Type the ACS will use to complete the challenge. **NOTE**: Only available for App transactions using the Cardinal Mobile SDK. 
   * @return acsRenderingType
  **/
  @ApiModelProperty(value = "Identifies the UI Type the ACS will use to complete the challenge. **NOTE**: Only available for App transactions using the Cardinal Mobile SDK. ")
  public String getAcsRenderingType() {
    return acsRenderingType;
  }

  public void setAcsRenderingType(String acsRenderingType) {
    this.acsRenderingType = acsRenderingType;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation acsTransactionId(String acsTransactionId) {
    this.acsTransactionId = acsTransactionId;
    return this;
  }

   /**
   * Unique transaction identifier assigned by the ACS to identify a single transaction. 
   * @return acsTransactionId
  **/
  @ApiModelProperty(value = "Unique transaction identifier assigned by the ACS to identify a single transaction. ")
  public String getAcsTransactionId() {
    return acsTransactionId;
  }

  public void setAcsTransactionId(String acsTransactionId) {
    this.acsTransactionId = acsTransactionId;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation acsUrl(String acsUrl) {
    this.acsUrl = acsUrl;
    return this;
  }

   /**
   * URL for the card-issuing bank&#39;s authentication form that you receive when the card is enrolled. The value can be very large. 
   * @return acsUrl
  **/
  @ApiModelProperty(value = "URL for the card-issuing bank's authentication form that you receive when the card is enrolled. The value can be very large. ")
  public String getAcsUrl() {
    return acsUrl;
  }

  public void setAcsUrl(String acsUrl) {
    this.acsUrl = acsUrl;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation authenticationPath(String authenticationPath) {
    this.authenticationPath = authenticationPath;
    return this;
  }

   /**
   * Indicates what displays to the customer during the authentication process. This field can contain one of these values: - &#x60;ADS&#x60;: (Card not enrolled) customer prompted to activate the card during the checkout process. - &#x60;ATTEMPTS&#x60;: (Attempts processing) Processing briefly displays before the checkout process is completed. - &#x60;ENROLLED&#x60;: (Card enrolled) the card issuer&#39;s authentication window displays. - &#x60;UNKNOWN&#x60;: Card enrollment status cannot be determined. - &#x60;NOREDIRECT&#x60;: (Card not enrolled, authentication unavailable, or error occurred) nothing displays to the customer.  The following values can be returned if you are using rules-based payer authentication. - &#x60;RIBA&#x60;: The card-issuing bank supports risk-based authentication, but whether the cardholder is likely to be challenged cannot be determined. - &#x60;RIBA_PASS&#x60;: The card-issuing bank supports risk-based authentication and it is likely that the cardholder will not be challenged to provide credentials, also known as _silent authentication_.  For details about possible values, see &#x60;pa_enroll_authentication_path&#x60; field description and \&quot;Rules-Based Payer Authentication\&quot; in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/) 
   * @return authenticationPath
  **/
  @ApiModelProperty(value = "Indicates what displays to the customer during the authentication process. This field can contain one of these values: - `ADS`: (Card not enrolled) customer prompted to activate the card during the checkout process. - `ATTEMPTS`: (Attempts processing) Processing briefly displays before the checkout process is completed. - `ENROLLED`: (Card enrolled) the card issuer's authentication window displays. - `UNKNOWN`: Card enrollment status cannot be determined. - `NOREDIRECT`: (Card not enrolled, authentication unavailable, or error occurred) nothing displays to the customer.  The following values can be returned if you are using rules-based payer authentication. - `RIBA`: The card-issuing bank supports risk-based authentication, but whether the cardholder is likely to be challenged cannot be determined. - `RIBA_PASS`: The card-issuing bank supports risk-based authentication and it is likely that the cardholder will not be challenged to provide credentials, also known as _silent authentication_.  For details about possible values, see `pa_enroll_authentication_path` field description and \"Rules-Based Payer Authentication\" in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/) ")
  public String getAuthenticationPath() {
    return authenticationPath;
  }

  public void setAuthenticationPath(String authenticationPath) {
    this.authenticationPath = authenticationPath;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation authorizationPayload(String authorizationPayload) {
    this.authorizationPayload = authorizationPayload;
    return this;
  }

   /**
   * The Base64 encoded JSON Payload of CB specific Authorization Values returned in the challenge Flow 
   * @return authorizationPayload
  **/
  @ApiModelProperty(value = "The Base64 encoded JSON Payload of CB specific Authorization Values returned in the challenge Flow ")
  public String getAuthorizationPayload() {
    return authorizationPayload;
  }

  public void setAuthorizationPayload(String authorizationPayload) {
    this.authorizationPayload = authorizationPayload;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation authenticationType(String authenticationType) {
    this.authenticationType = authenticationType;
    return this;
  }

   /**
   * Indicates the type of authentication that will be used to challenge the card holder.  Possible Values:  01 - Static  02 - Dynamic  03 - OOB (Out of Band)  04 - Decoupled  20 - OTP hosted at merchant end. (Rupay S2S flow) **NOTE**:  EMV 3-D Secure version 2.1.0 supports values 01-03.  Version 2.2.0 supports values 01-04.  Decoupled authentication is not supported at this time. 
   * @return authenticationType
  **/
  @ApiModelProperty(value = "Indicates the type of authentication that will be used to challenge the card holder.  Possible Values:  01 - Static  02 - Dynamic  03 - OOB (Out of Band)  04 - Decoupled  20 - OTP hosted at merchant end. (Rupay S2S flow) **NOTE**:  EMV 3-D Secure version 2.1.0 supports values 01-03.  Version 2.2.0 supports values 01-04.  Decoupled authentication is not supported at this time. ")
  public String getAuthenticationType() {
    return authenticationType;
  }

  public void setAuthenticationType(String authenticationType) {
    this.authenticationType = authenticationType;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation authenticationTransactionId(String authenticationTransactionId) {
    this.authenticationTransactionId = authenticationTransactionId;
    return this;
  }

   /**
   * Payer authentication transaction identifier is used to link the check enrollment and validate authentication messages. For Rupay, this field should be passed as request only for Resend OTP use case. 
   * @return authenticationTransactionId
  **/
  @ApiModelProperty(value = "Payer authentication transaction identifier is used to link the check enrollment and validate authentication messages. For Rupay, this field should be passed as request only for Resend OTP use case. ")
  public String getAuthenticationTransactionId() {
    return authenticationTransactionId;
  }

  public void setAuthenticationTransactionId(String authenticationTransactionId) {
    this.authenticationTransactionId = authenticationTransactionId;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation authenticationTransactionContextId(String authenticationTransactionContextId) {
    this.authenticationTransactionContextId = authenticationTransactionContextId;
    return this;
  }

   /**
   * Payer authentication transaction identifier passed to link the validation and authorization calls. 
   * @return authenticationTransactionContextId
  **/
  @ApiModelProperty(value = "Payer authentication transaction identifier passed to link the validation and authorization calls. ")
  public String getAuthenticationTransactionContextId() {
    return authenticationTransactionContextId;
  }

  public void setAuthenticationTransactionContextId(String authenticationTransactionContextId) {
    this.authenticationTransactionContextId = authenticationTransactionContextId;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation validityPeriod(Integer validityPeriod) {
    this.validityPeriod = validityPeriod;
    return this;
  }

   /**
   * Describes validity of OTP in minutes for incoming transaction.        . 
   * @return validityPeriod
  **/
  @ApiModelProperty(value = "Describes validity of OTP in minutes for incoming transaction.        . ")
  public Integer getValidityPeriod() {
    return validityPeriod;
  }

  public void setValidityPeriod(Integer validityPeriod) {
    this.validityPeriod = validityPeriod;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation cardholderMessage(String cardholderMessage) {
    this.cardholderMessage = cardholderMessage;
    return this;
  }

   /**
   * Text provided by the ACS/Issuer to Cardholder during a Frictionless or Decoupled transaction.The Issuer can provide information to Cardholder. For example, \&quot;Additional authentication is needed for this transaction, please contact (Issuer Name) at xxx-xxx-xxxx.\&quot;. The Issuing Bank can optionally support this value. 
   * @return cardholderMessage
  **/
  @ApiModelProperty(value = "Text provided by the ACS/Issuer to Cardholder during a Frictionless or Decoupled transaction.The Issuer can provide information to Cardholder. For example, \"Additional authentication is needed for this transaction, please contact (Issuer Name) at xxx-xxx-xxxx.\". The Issuing Bank can optionally support this value. ")
  public String getCardholderMessage() {
    return cardholderMessage;
  }

  public void setCardholderMessage(String cardholderMessage) {
    this.cardholderMessage = cardholderMessage;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation cavv(String cavv) {
    this.cavv = cavv;
    return this;
  }

   /**
   * Unique identifier generated by the card-issuing bank for Visa, American Express, JCB, Diners Club, and Discover transactions after the customer is authenticated. The value is in base64. When you request the card authorization service, CyberSource automatically converts the value, not the field name, to the format required by your payment processor. 
   * @return cavv
  **/
  @ApiModelProperty(value = "Unique identifier generated by the card-issuing bank for Visa, American Express, JCB, Diners Club, and Discover transactions after the customer is authenticated. The value is in base64. When you request the card authorization service, CyberSource automatically converts the value, not the field name, to the format required by your payment processor. ")
  public String getCavv() {
    return cavv;
  }

  public void setCavv(String cavv) {
    this.cavv = cavv;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation cavvAlgorithm(String cavvAlgorithm) {
    this.cavvAlgorithm = cavvAlgorithm;
    return this;
  }

   /**
   * Field that is returned only when the CAVV is generated, which occurs when paresStatus contains the values Y (successful authentication) or A (attempted authentication). If you use the ATOS processor, send the value of this field in the &#x60;cavv_algorithm&#x60; request field of the authorization service. This field contains one of these values: - &#x60;2&#x60;: Visa, American Express, JCB, Diners Club, and Discover - &#x60;3&#x60;: Mastercard 
   * @return cavvAlgorithm
  **/
  @ApiModelProperty(value = "Field that is returned only when the CAVV is generated, which occurs when paresStatus contains the values Y (successful authentication) or A (attempted authentication). If you use the ATOS processor, send the value of this field in the `cavv_algorithm` request field of the authorization service. This field contains one of these values: - `2`: Visa, American Express, JCB, Diners Club, and Discover - `3`: Mastercard ")
  public String getCavvAlgorithm() {
    return cavvAlgorithm;
  }

  public void setCavvAlgorithm(String cavvAlgorithm) {
    this.cavvAlgorithm = cavvAlgorithm;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation challengeCancelCode(String challengeCancelCode) {
    this.challengeCancelCode = challengeCancelCode;
    return this;
  }

   /**
   * An indicator as to why the transaction was canceled. Possible Values:  - &#x60;01&#x60;: Cardholder selected Cancel. - &#x60;02&#x60;: Reserved for future EMVCo use (values invalid until defined by EMVCo). - &#x60;03&#x60;: Transaction Timed Out—Decoupled Authentication - &#x60;04&#x60;: Transaction timed out at ACS—other timeouts - &#x60;05&#x60;: Transaction Timed out at ACS - First CReq not received by ACS - &#x60;06&#x60;: Transaction Error - &#x60;07&#x60;: Unknown - &#x60;08&#x60;: Transaction Timed Out at SDK 
   * @return challengeCancelCode
  **/
  @ApiModelProperty(value = "An indicator as to why the transaction was canceled. Possible Values:  - `01`: Cardholder selected Cancel. - `02`: Reserved for future EMVCo use (values invalid until defined by EMVCo). - `03`: Transaction Timed Out—Decoupled Authentication - `04`: Transaction timed out at ACS—other timeouts - `05`: Transaction Timed out at ACS - First CReq not received by ACS - `06`: Transaction Error - `07`: Unknown - `08`: Transaction Timed Out at SDK ")
  public String getChallengeCancelCode() {
    return challengeCancelCode;
  }

  public void setChallengeCancelCode(String challengeCancelCode) {
    this.challengeCancelCode = challengeCancelCode;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation challengeRequired(String challengeRequired) {
    this.challengeRequired = challengeRequired;
    return this;
  }

   /**
   * Indicates whether a challenge is required in order to complete authentication. **Note** Regional mandates might determine that a challenge is required.  Possible values: - &#x60;Y&#x60;: Challenge required - &#x60;N&#x60;: Challenge not required **Note**  Used by the Hybrid integration. 
   * @return challengeRequired
  **/
  @ApiModelProperty(value = "Indicates whether a challenge is required in order to complete authentication. **Note** Regional mandates might determine that a challenge is required.  Possible values: - `Y`: Challenge required - `N`: Challenge not required **Note**  Used by the Hybrid integration. ")
  public String getChallengeRequired() {
    return challengeRequired;
  }

  public void setChallengeRequired(String challengeRequired) {
    this.challengeRequired = challengeRequired;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation decoupledAuthenticationIndicator(String decoupledAuthenticationIndicator) {
    this.decoupledAuthenticationIndicator = decoupledAuthenticationIndicator;
    return this;
  }

   /**
   * Indicates whether the 3DS Requestor requests the ACS to utilize Decoupled Authentication and agrees to utilize Decoupled Authentication if the ACS confirms its use.  Possible Values:  Y - Decoupled Authentication is supported and preferred if challenge is necessary  N - Do not use Decoupled Authentication  **Default Value**: N 
   * @return decoupledAuthenticationIndicator
  **/
  @ApiModelProperty(value = "Indicates whether the 3DS Requestor requests the ACS to utilize Decoupled Authentication and agrees to utilize Decoupled Authentication if the ACS confirms its use.  Possible Values:  Y - Decoupled Authentication is supported and preferred if challenge is necessary  N - Do not use Decoupled Authentication  **Default Value**: N ")
  public String getDecoupledAuthenticationIndicator() {
    return decoupledAuthenticationIndicator;
  }

  public void setDecoupledAuthenticationIndicator(String decoupledAuthenticationIndicator) {
    this.decoupledAuthenticationIndicator = decoupledAuthenticationIndicator;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation directoryServerErrorCode(String directoryServerErrorCode) {
    this.directoryServerErrorCode = directoryServerErrorCode;
    return this;
  }

   /**
   * The directory server error code indicating a problem with this transaction. Note - Max Length of this field is typically 3 characters. 
   * @return directoryServerErrorCode
  **/
  @ApiModelProperty(value = "The directory server error code indicating a problem with this transaction. Note - Max Length of this field is typically 3 characters. ")
  public String getDirectoryServerErrorCode() {
    return directoryServerErrorCode;
  }

  public void setDirectoryServerErrorCode(String directoryServerErrorCode) {
    this.directoryServerErrorCode = directoryServerErrorCode;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation directoryServerErrorDescription(String directoryServerErrorDescription) {
    this.directoryServerErrorDescription = directoryServerErrorDescription;
    return this;
  }

   /**
   * Directory server text and additional detail about the error for this transaction. 
   * @return directoryServerErrorDescription
  **/
  @ApiModelProperty(value = "Directory server text and additional detail about the error for this transaction. ")
  public String getDirectoryServerErrorDescription() {
    return directoryServerErrorDescription;
  }

  public void setDirectoryServerErrorDescription(String directoryServerErrorDescription) {
    this.directoryServerErrorDescription = directoryServerErrorDescription;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation ecommerceIndicator(String ecommerceIndicator) {
    this.ecommerceIndicator = ecommerceIndicator;
    return this;
  }

   /**
   * Commerce indicator for cards not enrolled. This field contains one of these values: - &#x60;internet&#x60;: Card not enrolled, or card type not supported by payer authentication. No liability shift. - &#x60;js_attempted&#x60;: Card not enrolled, but attempt to authenticate is recorded. Liability shift. - &#x60;js_failure&#x60;: J/Secure directory service is not available. No liability shift. - &#x60;spa&#x60;: Mastercard card not enrolled in the SecureCode program. No liability shift. - &#x60;vbv_attempted&#x60;: Card not enrolled, but attempt to authenticate is recorded. Liability shift. - &#x60;vbv_failure&#x60;: For payment processor Barclays, Streamline, AIBMS, or FDC Germany, you receive this result if Visa&#39;s directory service is not available. No liability shift. 
   * @return ecommerceIndicator
  **/
  @ApiModelProperty(value = "Commerce indicator for cards not enrolled. This field contains one of these values: - `internet`: Card not enrolled, or card type not supported by payer authentication. No liability shift. - `js_attempted`: Card not enrolled, but attempt to authenticate is recorded. Liability shift. - `js_failure`: J/Secure directory service is not available. No liability shift. - `spa`: Mastercard card not enrolled in the SecureCode program. No liability shift. - `vbv_attempted`: Card not enrolled, but attempt to authenticate is recorded. Liability shift. - `vbv_failure`: For payment processor Barclays, Streamline, AIBMS, or FDC Germany, you receive this result if Visa's directory service is not available. No liability shift. ")
  public String getEcommerceIndicator() {
    return ecommerceIndicator;
  }

  public void setEcommerceIndicator(String ecommerceIndicator) {
    this.ecommerceIndicator = ecommerceIndicator;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation eci(String eci) {
    this.eci = eci;
    return this;
  }

   /**
   * Note This field applies only to non-U.S-issued cards.  For enroll, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions when the card is not enrolled. For more information, see \&quot;Interpreting the Reply,\&quot; page 22.  If you are not using the CyberSource payment services, you must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - &#x60;06&#x60;: The card can be enrolled. Liability shift. - &#x60;07&#x60;: The card cannot be enrolled. No liability shift.  For validate, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions. The field is absent when authentication fails. You must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - &#x60;05&#x60;: Successful authentication - &#x60;06&#x60;: Authentication attempted - &#x60;07&#x60;: Failed authentication (No response from the merchant because of a problem.) 
   * @return eci
  **/
  @ApiModelProperty(value = "Note This field applies only to non-U.S-issued cards.  For enroll, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions when the card is not enrolled. For more information, see \"Interpreting the Reply,\" page 22.  If you are not using the CyberSource payment services, you must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - `06`: The card can be enrolled. Liability shift. - `07`: The card cannot be enrolled. No liability shift.  For validate, Numeric electronic commerce indicator (ECI) returned only for Visa, American Express, JCB, Diners Club, and Discover transactions. The field is absent when authentication fails. You must send this value to your payment processor in the subsequent request for card authorization. This field contains one of these values: - `05`: Successful authentication - `06`: Authentication attempted - `07`: Failed authentication (No response from the merchant because of a problem.) ")
  public String getEci() {
    return eci;
  }

  public void setEci(String eci) {
    this.eci = eci;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation eciRaw(String eciRaw) {
    this.eciRaw = eciRaw;
    return this;
  }

   /**
   * ECI value that can be returned for Visa, Mastercard, American Express, JCB, Diners Club, and Discover. The field is absent when authentication fails. If your payment processor is Streamline, you must pass the value of this field instead of the value of &#x60;eci&#x60; or &#x60;ucafCollectionIndicator&#x60;.  This field can contain one of these values: - &#x60;01&#x60;: Authentication attempted (Mastercard) - &#x60;02&#x60;: Successful authentication (Mastercard) - &#x60;05&#x60;: Successful authentication (Visa, American Express, JCB, Diners Club, and Discover) - &#x60;06&#x60;: Authentication attempted (Visa, American Express, JCB, Diners Club, and Discover) 
   * @return eciRaw
  **/
  @ApiModelProperty(value = "ECI value that can be returned for Visa, Mastercard, American Express, JCB, Diners Club, and Discover. The field is absent when authentication fails. If your payment processor is Streamline, you must pass the value of this field instead of the value of `eci` or `ucafCollectionIndicator`.  This field can contain one of these values: - `01`: Authentication attempted (Mastercard) - `02`: Successful authentication (Mastercard) - `05`: Successful authentication (Visa, American Express, JCB, Diners Club, and Discover) - `06`: Authentication attempted (Visa, American Express, JCB, Diners Club, and Discover) ")
  public String getEciRaw() {
    return eciRaw;
  }

  public void setEciRaw(String eciRaw) {
    this.eciRaw = eciRaw;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation effectiveAuthenticationType(String effectiveAuthenticationType) {
    this.effectiveAuthenticationType = effectiveAuthenticationType;
    return this;
  }

   /**
   * This field describes the type of 3DS transaction flow that took place.  It can be one of three possible flows; CH - Challenge FR - Frictionless FD - Frictionless with delegation, (challenge not generated by the issuer but by the scheme on behalf of the issuer). 
   * @return effectiveAuthenticationType
  **/
  @ApiModelProperty(value = "This field describes the type of 3DS transaction flow that took place.  It can be one of three possible flows; CH - Challenge FR - Frictionless FD - Frictionless with delegation, (challenge not generated by the issuer but by the scheme on behalf of the issuer). ")
  public String getEffectiveAuthenticationType() {
    return effectiveAuthenticationType;
  }

  public void setEffectiveAuthenticationType(String effectiveAuthenticationType) {
    this.effectiveAuthenticationType = effectiveAuthenticationType;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation ivr(PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationIvr ivr) {
    this.ivr = ivr;
    return this;
  }

   /**
   * Get ivr
   * @return ivr
  **/
  @ApiModelProperty(value = "")
  public PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationIvr getIvr() {
    return ivr;
  }

  public void setIvr(PtsV2PaymentsPost201ResponseConsumerAuthenticationInformationIvr ivr) {
    this.ivr = ivr;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation networkScore(String networkScore) {
    this.networkScore = networkScore;
    return this;
  }

   /**
   * The global score calculated by the CB scoring platform and returned to merchants. 
   * @return networkScore
  **/
  @ApiModelProperty(value = "The global score calculated by the CB scoring platform and returned to merchants. ")
  public String getNetworkScore() {
    return networkScore;
  }

  public void setNetworkScore(String networkScore) {
    this.networkScore = networkScore;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation pareq(String pareq) {
    this.pareq = pareq;
    return this;
  }

   /**
   * Payer authentication request (PAReq) message that you need to forward to the ACS. The value can be very large. The value is in base64. 
   * @return pareq
  **/
  @ApiModelProperty(value = "Payer authentication request (PAReq) message that you need to forward to the ACS. The value can be very large. The value is in base64. ")
  public String getPareq() {
    return pareq;
  }

  public void setPareq(String pareq) {
    this.pareq = pareq;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation paresStatus(String paresStatus) {
    this.paresStatus = paresStatus;
    return this;
  }

   /**
   * Raw result of the authentication check. If you are configured for Asia, Middle East, and Africa Gateway Processing, you need to send the value of this field in your authorization request. This field can contain one of these values: - &#x60;A&#x60;: Proof of authentication attempt was generated. - &#x60;N&#x60;: Customer failed or canceled authentication. Transaction denied. - &#x60;U&#x60;: Authentication not completed regardless of the reason. - &#x60;Y&#x60;: Customer was successfully authenticated. 
   * @return paresStatus
  **/
  @ApiModelProperty(value = "Raw result of the authentication check. If you are configured for Asia, Middle East, and Africa Gateway Processing, you need to send the value of this field in your authorization request. This field can contain one of these values: - `A`: Proof of authentication attempt was generated. - `N`: Customer failed or canceled authentication. Transaction denied. - `U`: Authentication not completed regardless of the reason. - `Y`: Customer was successfully authenticated. ")
  public String getParesStatus() {
    return paresStatus;
  }

  public void setParesStatus(String paresStatus) {
    this.paresStatus = paresStatus;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation proofXml(String proofXml) {
    this.proofXml = proofXml;
    return this;
  }

   /**
   * Date and time of the enrollment check combined with the VEReq and VERes elements. If you ever need to show proof of enrollment checking, you may need to parse the string for the information required by the payment card company. The value can be very large. For details about possible values, see the &#x60;pa_enroll_proofxml&#x60; field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/) - For cards issued in the U.S. or Canada, Visa may require this data for specific merchant category codes. - For cards not issued in the U.S. or Canada, your bank may require this data as proof of enrollment checking for any payer authentication transaction that you re-present because of a chargeback. 
   * @return proofXml
  **/
  @ApiModelProperty(value = "Date and time of the enrollment check combined with the VEReq and VERes elements. If you ever need to show proof of enrollment checking, you may need to parse the string for the information required by the payment card company. The value can be very large. For details about possible values, see the `pa_enroll_proofxml` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/) - For cards issued in the U.S. or Canada, Visa may require this data for specific merchant category codes. - For cards not issued in the U.S. or Canada, your bank may require this data as proof of enrollment checking for any payer authentication transaction that you re-present because of a chargeback. ")
  public String getProofXml() {
    return proofXml;
  }

  public void setProofXml(String proofXml) {
    this.proofXml = proofXml;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation proxyPan(String proxyPan) {
    this.proxyPan = proxyPan;
    return this;
  }

   /**
   * Encrypted version of the card number used in the payer authentication request message. 
   * @return proxyPan
  **/
  @ApiModelProperty(value = "Encrypted version of the card number used in the payer authentication request message. ")
  public String getProxyPan() {
    return proxyPan;
  }

  public void setProxyPan(String proxyPan) {
    this.proxyPan = proxyPan;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation sdkTransactionId(String sdkTransactionId) {
    this.sdkTransactionId = sdkTransactionId;
    return this;
  }

   /**
   * SDK unique transaction identifier that is generated on each new transaction. 
   * @return sdkTransactionId
  **/
  @ApiModelProperty(value = "SDK unique transaction identifier that is generated on each new transaction. ")
  public String getSdkTransactionId() {
    return sdkTransactionId;
  }

  public void setSdkTransactionId(String sdkTransactionId) {
    this.sdkTransactionId = sdkTransactionId;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation signedParesStatusReason(String signedParesStatusReason) {
    this.signedParesStatusReason = signedParesStatusReason;
    return this;
  }

   /**
   * Provides additional information as to why the PAResStatus has a specific value. 
   * @return signedParesStatusReason
  **/
  @ApiModelProperty(value = "Provides additional information as to why the PAResStatus has a specific value. ")
  public String getSignedParesStatusReason() {
    return signedParesStatusReason;
  }

  public void setSignedParesStatusReason(String signedParesStatusReason) {
    this.signedParesStatusReason = signedParesStatusReason;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation specificationVersion(String specificationVersion) {
    this.specificationVersion = specificationVersion;
    return this;
  }

   /**
   * This field contains the 3D Secure version that was used to process the transaction. For example, 1.0.2 or 2.0.0. 
   * @return specificationVersion
  **/
  @ApiModelProperty(value = "This field contains the 3D Secure version that was used to process the transaction. For example, 1.0.2 or 2.0.0. ")
  public String getSpecificationVersion() {
    return specificationVersion;
  }

  public void setSpecificationVersion(String specificationVersion) {
    this.specificationVersion = specificationVersion;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation stepUpUrl(String stepUpUrl) {
    this.stepUpUrl = stepUpUrl;
    return this;
  }

   /**
   * The fully qualified URL that the merchant uses to post a form to the cardholder in order to complete the Consumer Authentication transaction for the Cardinal Cruise API integration. 
   * @return stepUpUrl
  **/
  @ApiModelProperty(value = "The fully qualified URL that the merchant uses to post a form to the cardholder in order to complete the Consumer Authentication transaction for the Cardinal Cruise API integration. ")
  public String getStepUpUrl() {
    return stepUpUrl;
  }

  public void setStepUpUrl(String stepUpUrl) {
    this.stepUpUrl = stepUpUrl;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation threeDSServerTransactionId(String threeDSServerTransactionId) {
    this.threeDSServerTransactionId = threeDSServerTransactionId;
    return this;
  }

   /**
   * Unique transaction identifier assigned by the 3DS Server to identify a single transaction. 
   * @return threeDSServerTransactionId
  **/
  @ApiModelProperty(value = "Unique transaction identifier assigned by the 3DS Server to identify a single transaction. ")
  public String getThreeDSServerTransactionId() {
    return threeDSServerTransactionId;
  }

  public void setThreeDSServerTransactionId(String threeDSServerTransactionId) {
    this.threeDSServerTransactionId = threeDSServerTransactionId;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation ucafAuthenticationData(String ucafAuthenticationData) {
    this.ucafAuthenticationData = ucafAuthenticationData;
    return this;
  }

   /**
   * AAV is a unique identifier generated by the card-issuing bank for Mastercard Identity Check transactions after the customer is authenticated. The value is in base64. Include the data in the card authorization request. 
   * @return ucafAuthenticationData
  **/
  @ApiModelProperty(value = "AAV is a unique identifier generated by the card-issuing bank for Mastercard Identity Check transactions after the customer is authenticated. The value is in base64. Include the data in the card authorization request. ")
  public String getUcafAuthenticationData() {
    return ucafAuthenticationData;
  }

  public void setUcafAuthenticationData(String ucafAuthenticationData) {
    this.ucafAuthenticationData = ucafAuthenticationData;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation ucafCollectionIndicator(String ucafCollectionIndicator) {
    this.ucafCollectionIndicator = ucafCollectionIndicator;
    return this;
  }

   /**
   * For enroll, Returned only for Mastercard transactions. Indicates that authentication is not required because the customer is not enrolled. Add the value of this field to the authorization field ucaf_collection_indicator. This field can contain these values: 0, 1.  For validate, Numeric electronic commerce indicator (ECI) returned only for Mastercard Identity Check transactions. The field is absent when authentication fails. You must send this value to your payment processor in the request for card authorization. This field contain one of these values: - &#x60;0&#x60;: Authentication data not collected, and customer authentication was not completed. - &#x60;1&#x60;: Authentication data not collected because customer authentication was not completed. - &#x60;2&#x60;: Authentication data collected because customer completed authentication. 
   * @return ucafCollectionIndicator
  **/
  @ApiModelProperty(value = "For enroll, Returned only for Mastercard transactions. Indicates that authentication is not required because the customer is not enrolled. Add the value of this field to the authorization field ucaf_collection_indicator. This field can contain these values: 0, 1.  For validate, Numeric electronic commerce indicator (ECI) returned only for Mastercard Identity Check transactions. The field is absent when authentication fails. You must send this value to your payment processor in the request for card authorization. This field contain one of these values: - `0`: Authentication data not collected, and customer authentication was not completed. - `1`: Authentication data not collected because customer authentication was not completed. - `2`: Authentication data collected because customer completed authentication. ")
  public String getUcafCollectionIndicator() {
    return ucafCollectionIndicator;
  }

  public void setUcafCollectionIndicator(String ucafCollectionIndicator) {
    this.ucafCollectionIndicator = ucafCollectionIndicator;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation veresEnrolled(String veresEnrolled) {
    this.veresEnrolled = veresEnrolled;
    return this;
  }

   /**
   * Result of the enrollment check. This field can contain one of these values: - &#x60;Y&#x60;: Card enrolled or can be enrolled; you must authenticate. Liability shift. - &#x60;N&#x60;: Card not enrolled; proceed with authorization. Liability shift. - &#x60;U&#x60;: Unable to authenticate regardless of the reason. No liability shift.  **Note** This field only applies to the Asia, Middle East, and Africa Gateway. If you are configured for this processor, you must send the value of this field in your authorization request.  The following value can be returned if you are using rules-based Payer Authentication: - &#x60;B&#x60;: Indicates that authentication was bypassed.  For details, see &#x60;pa_enroll_veres_enrolled&#x60; field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/) 
   * @return veresEnrolled
  **/
  @ApiModelProperty(value = "Result of the enrollment check. This field can contain one of these values: - `Y`: Card enrolled or can be enrolled; you must authenticate. Liability shift. - `N`: Card not enrolled; proceed with authorization. Liability shift. - `U`: Unable to authenticate regardless of the reason. No liability shift.  **Note** This field only applies to the Asia, Middle East, and Africa Gateway. If you are configured for this processor, you must send the value of this field in your authorization request.  The following value can be returned if you are using rules-based Payer Authentication: - `B`: Indicates that authentication was bypassed.  For details, see `pa_enroll_veres_enrolled` field description in [CyberSource Payer Authentication Using the SCMP API.] (https://apps.cybersource.com/library/documentation/dev_guides/Payer_Authentication_SCMP_API/html/) ")
  public String getVeresEnrolled() {
    return veresEnrolled;
  }

  public void setVeresEnrolled(String veresEnrolled) {
    this.veresEnrolled = veresEnrolled;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation whiteListStatusSource(String whiteListStatusSource) {
    this.whiteListStatusSource = whiteListStatusSource;
    return this;
  }

   /**
   * This data element will be populated by the system setting Whitelist Status. Possible Values: 01 - 3DS/ Server/ 02 – DS/03 - ACS 
   * @return whiteListStatusSource
  **/
  @ApiModelProperty(value = "This data element will be populated by the system setting Whitelist Status. Possible Values: 01 - 3DS/ Server/ 02 – DS/03 - ACS ")
  public String getWhiteListStatusSource() {
    return whiteListStatusSource;
  }

  public void setWhiteListStatusSource(String whiteListStatusSource) {
    this.whiteListStatusSource = whiteListStatusSource;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation xid(String xid) {
    this.xid = xid;
    return this;
  }

   /**
   * Transaction identifier generated by CyberSource for successful enrollment or validation checks. Use this value, which is in base64, to match an outgoing PAReq with an incoming PARes. CyberSource forwards the XID with the card authorization service to these payment processors in these cases: - Barclays - Streamline (when the **ecommerceIndicator**&#x60;&#x3D;spa&#x60;) 
   * @return xid
  **/
  @ApiModelProperty(value = "Transaction identifier generated by CyberSource for successful enrollment or validation checks. Use this value, which is in base64, to match an outgoing PAReq with an incoming PARes. CyberSource forwards the XID with the card authorization service to these payment processors in these cases: - Barclays - Streamline (when the **ecommerceIndicator**`=spa`) ")
  public String getXid() {
    return xid;
  }

  public void setXid(String xid) {
    this.xid = xid;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation directoryServerTransactionId(String directoryServerTransactionId) {
    this.directoryServerTransactionId = directoryServerTransactionId;
    return this;
  }

   /**
   * The Directory Server Transaction ID is generated by the Mastercard Directory Server during the authentication transaction and passed back to the merchant with the authentication results. For Cybersource Through Visanet Gateway: The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR7, Position: 114-149, Field: MC AVV Verification—Directory Server Transaction ID 
   * @return directoryServerTransactionId
  **/
  @ApiModelProperty(value = "The Directory Server Transaction ID is generated by the Mastercard Directory Server during the authentication transaction and passed back to the merchant with the authentication results. For Cybersource Through Visanet Gateway: The value for this field corresponds to the following data in the TC 33 capture file3: Record: CP01 TCR7, Position: 114-149, Field: MC AVV Verification—Directory Server Transaction ID ")
  public String getDirectoryServerTransactionId() {
    return directoryServerTransactionId;
  }

  public void setDirectoryServerTransactionId(String directoryServerTransactionId) {
    this.directoryServerTransactionId = directoryServerTransactionId;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation acsOperatorID(String acsOperatorID) {
    this.acsOperatorID = acsOperatorID;
    return this;
  }

   /**
   * Directory Server assigned ACS identifier.
   * @return acsOperatorID
  **/
  @ApiModelProperty(value = "Directory Server assigned ACS identifier.")
  public String getAcsOperatorID() {
    return acsOperatorID;
  }

  public void setAcsOperatorID(String acsOperatorID) {
    this.acsOperatorID = acsOperatorID;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation acsReferenceNumber(String acsReferenceNumber) {
    this.acsReferenceNumber = acsReferenceNumber;
    return this;
  }

   /**
   * Unique identifier assigned by the EMVCo Secretariat upon Testing and Approval.
   * @return acsReferenceNumber
  **/
  @ApiModelProperty(value = "Unique identifier assigned by the EMVCo Secretariat upon Testing and Approval.")
  public String getAcsReferenceNumber() {
    return acsReferenceNumber;
  }

  public void setAcsReferenceNumber(String acsReferenceNumber) {
    this.acsReferenceNumber = acsReferenceNumber;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation idciDecision(String idciDecision) {
    this.idciDecision = idciDecision;
    return this;
  }

   /**
   * Decision on the Risk Assessment from Mastercard.
   * @return idciDecision
  **/
  @ApiModelProperty(value = "Decision on the Risk Assessment from Mastercard.")
  public String getIdciDecision() {
    return idciDecision;
  }

  public void setIdciDecision(String idciDecision) {
    this.idciDecision = idciDecision;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation idciReasonCode1(String idciReasonCode1) {
    this.idciReasonCode1 = idciReasonCode1;
    return this;
  }

   /**
   * ReasonCode from Mastercard
   * @return idciReasonCode1
  **/
  @ApiModelProperty(value = "ReasonCode from Mastercard")
  public String getIdciReasonCode1() {
    return idciReasonCode1;
  }

  public void setIdciReasonCode1(String idciReasonCode1) {
    this.idciReasonCode1 = idciReasonCode1;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation idciReasonCode2(String idciReasonCode2) {
    this.idciReasonCode2 = idciReasonCode2;
    return this;
  }

   /**
   * ReasonCode from Mastercard
   * @return idciReasonCode2
  **/
  @ApiModelProperty(value = "ReasonCode from Mastercard")
  public String getIdciReasonCode2() {
    return idciReasonCode2;
  }

  public void setIdciReasonCode2(String idciReasonCode2) {
    this.idciReasonCode2 = idciReasonCode2;
  }

  public RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation idciScore(Integer idciScore) {
    this.idciScore = idciScore;
    return this;
  }

   /**
   * Risk Assessment from Mastercard
   * @return idciScore
  **/
  @ApiModelProperty(value = "Risk Assessment from Mastercard")
  public Integer getIdciScore() {
    return idciScore;
  }

  public void setIdciScore(Integer idciScore) {
    this.idciScore = idciScore;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation riskV1DecisionsPost201ResponseConsumerAuthenticationInformation = (RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation) o;
    return Objects.equals(this.accessToken, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.accessToken) &&
        Objects.equals(this.acsRenderingType, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.acsRenderingType) &&
        Objects.equals(this.acsTransactionId, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.acsTransactionId) &&
        Objects.equals(this.acsUrl, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.acsUrl) &&
        Objects.equals(this.authenticationPath, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.authenticationPath) &&
        Objects.equals(this.authorizationPayload, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.authorizationPayload) &&
        Objects.equals(this.authenticationType, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.authenticationType) &&
        Objects.equals(this.authenticationTransactionId, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.authenticationTransactionId) &&
        Objects.equals(this.authenticationTransactionContextId, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.authenticationTransactionContextId) &&
        Objects.equals(this.validityPeriod, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.validityPeriod) &&
        Objects.equals(this.cardholderMessage, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.cardholderMessage) &&
        Objects.equals(this.cavv, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.cavv) &&
        Objects.equals(this.cavvAlgorithm, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.cavvAlgorithm) &&
        Objects.equals(this.challengeCancelCode, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.challengeCancelCode) &&
        Objects.equals(this.challengeRequired, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.challengeRequired) &&
        Objects.equals(this.decoupledAuthenticationIndicator, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.decoupledAuthenticationIndicator) &&
        Objects.equals(this.directoryServerErrorCode, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.directoryServerErrorCode) &&
        Objects.equals(this.directoryServerErrorDescription, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.directoryServerErrorDescription) &&
        Objects.equals(this.ecommerceIndicator, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.ecommerceIndicator) &&
        Objects.equals(this.eci, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.eci) &&
        Objects.equals(this.eciRaw, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.eciRaw) &&
        Objects.equals(this.effectiveAuthenticationType, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.effectiveAuthenticationType) &&
        Objects.equals(this.ivr, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.ivr) &&
        Objects.equals(this.networkScore, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.networkScore) &&
        Objects.equals(this.pareq, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.pareq) &&
        Objects.equals(this.paresStatus, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.paresStatus) &&
        Objects.equals(this.proofXml, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.proofXml) &&
        Objects.equals(this.proxyPan, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.proxyPan) &&
        Objects.equals(this.sdkTransactionId, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.sdkTransactionId) &&
        Objects.equals(this.signedParesStatusReason, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.signedParesStatusReason) &&
        Objects.equals(this.specificationVersion, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.specificationVersion) &&
        Objects.equals(this.stepUpUrl, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.stepUpUrl) &&
        Objects.equals(this.threeDSServerTransactionId, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.threeDSServerTransactionId) &&
        Objects.equals(this.ucafAuthenticationData, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.ucafAuthenticationData) &&
        Objects.equals(this.ucafCollectionIndicator, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.ucafCollectionIndicator) &&
        Objects.equals(this.veresEnrolled, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.veresEnrolled) &&
        Objects.equals(this.whiteListStatusSource, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.whiteListStatusSource) &&
        Objects.equals(this.xid, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.xid) &&
        Objects.equals(this.directoryServerTransactionId, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.directoryServerTransactionId) &&
        Objects.equals(this.acsOperatorID, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.acsOperatorID) &&
        Objects.equals(this.acsReferenceNumber, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.acsReferenceNumber) &&
        Objects.equals(this.idciDecision, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.idciDecision) &&
        Objects.equals(this.idciReasonCode1, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.idciReasonCode1) &&
        Objects.equals(this.idciReasonCode2, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.idciReasonCode2) &&
        Objects.equals(this.idciScore, riskV1DecisionsPost201ResponseConsumerAuthenticationInformation.idciScore);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accessToken, acsRenderingType, acsTransactionId, acsUrl, authenticationPath, authorizationPayload, authenticationType, authenticationTransactionId, authenticationTransactionContextId, validityPeriod, cardholderMessage, cavv, cavvAlgorithm, challengeCancelCode, challengeRequired, decoupledAuthenticationIndicator, directoryServerErrorCode, directoryServerErrorDescription, ecommerceIndicator, eci, eciRaw, effectiveAuthenticationType, ivr, networkScore, pareq, paresStatus, proofXml, proxyPan, sdkTransactionId, signedParesStatusReason, specificationVersion, stepUpUrl, threeDSServerTransactionId, ucafAuthenticationData, ucafCollectionIndicator, veresEnrolled, whiteListStatusSource, xid, directoryServerTransactionId, acsOperatorID, acsReferenceNumber, idciDecision, idciReasonCode1, idciReasonCode2, idciScore);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RiskV1DecisionsPost201ResponseConsumerAuthenticationInformation {\n");
    
    sb.append("    accessToken: ").append(toIndentedString(accessToken)).append("\n");
    sb.append("    acsRenderingType: ").append(toIndentedString(acsRenderingType)).append("\n");
    sb.append("    acsTransactionId: ").append(toIndentedString(acsTransactionId)).append("\n");
    sb.append("    acsUrl: ").append(toIndentedString(acsUrl)).append("\n");
    sb.append("    authenticationPath: ").append(toIndentedString(authenticationPath)).append("\n");
    sb.append("    authorizationPayload: ").append(toIndentedString(authorizationPayload)).append("\n");
    sb.append("    authenticationType: ").append(toIndentedString(authenticationType)).append("\n");
    sb.append("    authenticationTransactionId: ").append(toIndentedString(authenticationTransactionId)).append("\n");
    sb.append("    authenticationTransactionContextId: ").append(toIndentedString(authenticationTransactionContextId)).append("\n");
    sb.append("    validityPeriod: ").append(toIndentedString(validityPeriod)).append("\n");
    sb.append("    cardholderMessage: ").append(toIndentedString(cardholderMessage)).append("\n");
    sb.append("    cavv: ").append(toIndentedString(cavv)).append("\n");
    sb.append("    cavvAlgorithm: ").append(toIndentedString(cavvAlgorithm)).append("\n");
    sb.append("    challengeCancelCode: ").append(toIndentedString(challengeCancelCode)).append("\n");
    sb.append("    challengeRequired: ").append(toIndentedString(challengeRequired)).append("\n");
    sb.append("    decoupledAuthenticationIndicator: ").append(toIndentedString(decoupledAuthenticationIndicator)).append("\n");
    sb.append("    directoryServerErrorCode: ").append(toIndentedString(directoryServerErrorCode)).append("\n");
    sb.append("    directoryServerErrorDescription: ").append(toIndentedString(directoryServerErrorDescription)).append("\n");
    sb.append("    ecommerceIndicator: ").append(toIndentedString(ecommerceIndicator)).append("\n");
    sb.append("    eci: ").append(toIndentedString(eci)).append("\n");
    sb.append("    eciRaw: ").append(toIndentedString(eciRaw)).append("\n");
    sb.append("    effectiveAuthenticationType: ").append(toIndentedString(effectiveAuthenticationType)).append("\n");
    sb.append("    ivr: ").append(toIndentedString(ivr)).append("\n");
    sb.append("    networkScore: ").append(toIndentedString(networkScore)).append("\n");
    sb.append("    pareq: ").append(toIndentedString(pareq)).append("\n");
    sb.append("    paresStatus: ").append(toIndentedString(paresStatus)).append("\n");
    sb.append("    proofXml: ").append(toIndentedString(proofXml)).append("\n");
    sb.append("    proxyPan: ").append(toIndentedString(proxyPan)).append("\n");
    sb.append("    sdkTransactionId: ").append(toIndentedString(sdkTransactionId)).append("\n");
    sb.append("    signedParesStatusReason: ").append(toIndentedString(signedParesStatusReason)).append("\n");
    sb.append("    specificationVersion: ").append(toIndentedString(specificationVersion)).append("\n");
    sb.append("    stepUpUrl: ").append(toIndentedString(stepUpUrl)).append("\n");
    sb.append("    threeDSServerTransactionId: ").append(toIndentedString(threeDSServerTransactionId)).append("\n");
    sb.append("    ucafAuthenticationData: ").append(toIndentedString(ucafAuthenticationData)).append("\n");
    sb.append("    ucafCollectionIndicator: ").append(toIndentedString(ucafCollectionIndicator)).append("\n");
    sb.append("    veresEnrolled: ").append(toIndentedString(veresEnrolled)).append("\n");
    sb.append("    whiteListStatusSource: ").append(toIndentedString(whiteListStatusSource)).append("\n");
    sb.append("    xid: ").append(toIndentedString(xid)).append("\n");
    sb.append("    directoryServerTransactionId: ").append(toIndentedString(directoryServerTransactionId)).append("\n");
    sb.append("    acsOperatorID: ").append(toIndentedString(acsOperatorID)).append("\n");
    sb.append("    acsReferenceNumber: ").append(toIndentedString(acsReferenceNumber)).append("\n");
    sb.append("    idciDecision: ").append(toIndentedString(idciDecision)).append("\n");
    sb.append("    idciReasonCode1: ").append(toIndentedString(idciReasonCode1)).append("\n");
    sb.append("    idciReasonCode2: ").append(toIndentedString(idciReasonCode2)).append("\n");
    sb.append("    idciScore: ").append(toIndentedString(idciScore)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

