/*
 * CyberSource Merged Spec
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;
import java.io.InputStream;


import org.joda.time.DateTime;
import Model.InlineResponse2001;
import Model.InlineResponse4006;
import Model.InlineResponse5002;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class KeyManagementApi {
    private static Logger logger = LogManager.getLogger(KeyManagementApi.class);
    
    private ApiClient apiClient;

    public KeyManagementApi() {
        this(Configuration.getDefaultApiClient());
    }

    public KeyManagementApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for searchKeys
     * @param offset This allows you to specify the page offset from the resulting list resultset you want the records to be returned (optional)
     * @param limit This allows you to specify the total number of records to be returned off the resulting list resultset (optional)
     * @param sort This allows you to specify a comma separated list of fields in the order which the resulting list resultset must be sorted. (optional)
     * @param organizationIds List of Orgaization Ids to search. The maximum size of the organization Ids list is 1. The maximum length of Organization Id is 30. (optional)
     * @param keyIds List of Key Ids to search. The maximum size of the Key Ids list is 1 (optional)
     * @param keyTypes Key Type, Possible values -  certificate, password, pgp and scmp_api. When Key Type is provided atleast one more filter needs to be provided (optional)
     * @param expirationStartDate Expiry Filter Start Date. When Expiration Date filter is provided, atleast one more filter needs to be provided (optional)
     * @param expirationEndDate Expiry Filter End Date. When Expiration Date filter is provided, atleast one more filter needs to be provided (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public okhttp3.Call searchKeysCall(Integer offset, Integer limit, String sort, List<String> organizationIds, List<String> keyIds, List<String> keyTypes, DateTime expirationStartDate, DateTime expirationEndDate, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        
        // create path and map variables
        String localVarPath = "/kms/v2/keys";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (offset != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "offset", offset));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));
        if (sort != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "sort", sort));
        if (organizationIds != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "organizationIds", organizationIds));
        if (keyIds != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "keyIds", keyIds));
        if (keyTypes != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("csv", "keyTypes", keyTypes));
        if (expirationStartDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "expirationStartDate", expirationStartDate));
        if (expirationEndDate != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "expirationEndDate", expirationEndDate));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/hal+json;charset=utf-8"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json;charset=utf-8"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new okhttp3.Interceptor() {
                @Override
                public okhttp3.Response intercept(okhttp3.Interceptor.Chain chain) throws IOException {
                    okhttp3.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] {  };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private okhttp3.Call searchKeysValidateBeforeCall(Integer offset, Integer limit, String sort, List<String> organizationIds, List<String> keyIds, List<String> keyTypes, DateTime expirationStartDate, DateTime expirationEndDate, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        
        okhttp3.Call call = searchKeysCall(offset, limit, sort, organizationIds, keyIds, keyTypes, expirationStartDate, expirationEndDate, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Search Keys
     * Search one or more Keys
     * @param offset This allows you to specify the page offset from the resulting list resultset you want the records to be returned (optional)
     * @param limit This allows you to specify the total number of records to be returned off the resulting list resultset (optional)
     * @param sort This allows you to specify a comma separated list of fields in the order which the resulting list resultset must be sorted. (optional)
     * @param organizationIds List of Orgaization Ids to search. The maximum size of the organization Ids list is 1. The maximum length of Organization Id is 30. (optional)
     * @param keyIds List of Key Ids to search. The maximum size of the Key Ids list is 1 (optional)
     * @param keyTypes Key Type, Possible values -  certificate, password, pgp and scmp_api. When Key Type is provided atleast one more filter needs to be provided (optional)
     * @param expirationStartDate Expiry Filter Start Date. When Expiration Date filter is provided, atleast one more filter needs to be provided (optional)
     * @param expirationEndDate Expiry Filter End Date. When Expiration Date filter is provided, atleast one more filter needs to be provided (optional)
     * @return InlineResponse2001
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public InlineResponse2001 searchKeys(Integer offset, Integer limit, String sort, List<String> organizationIds, List<String> keyIds, List<String> keyTypes, DateTime expirationStartDate, DateTime expirationEndDate) throws ApiException {
        logger.info("CALL TO METHOD 'searchKeys' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<InlineResponse2001> resp = searchKeysWithHttpInfo(offset, limit, sort, organizationIds, keyIds, keyTypes, expirationStartDate, expirationEndDate);
        logger.info("CALL TO METHOD 'searchKeys' ENDED");
        return resp.getData();
    }

    /**
     * Search Keys
     * Search one or more Keys
     * @param offset This allows you to specify the page offset from the resulting list resultset you want the records to be returned (optional)
     * @param limit This allows you to specify the total number of records to be returned off the resulting list resultset (optional)
     * @param sort This allows you to specify a comma separated list of fields in the order which the resulting list resultset must be sorted. (optional)
     * @param organizationIds List of Orgaization Ids to search. The maximum size of the organization Ids list is 1. The maximum length of Organization Id is 30. (optional)
     * @param keyIds List of Key Ids to search. The maximum size of the Key Ids list is 1 (optional)
     * @param keyTypes Key Type, Possible values -  certificate, password, pgp and scmp_api. When Key Type is provided atleast one more filter needs to be provided (optional)
     * @param expirationStartDate Expiry Filter Start Date. When Expiration Date filter is provided, atleast one more filter needs to be provided (optional)
     * @param expirationEndDate Expiry Filter End Date. When Expiration Date filter is provided, atleast one more filter needs to be provided (optional)
     * @return ApiResponse&lt;InlineResponse2001&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<InlineResponse2001> searchKeysWithHttpInfo(Integer offset, Integer limit, String sort, List<String> organizationIds, List<String> keyIds, List<String> keyTypes, DateTime expirationStartDate, DateTime expirationEndDate) throws ApiException {
        okhttp3.Call call = searchKeysValidateBeforeCall(offset, limit, sort, organizationIds, keyIds, keyTypes, expirationStartDate, expirationEndDate, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2001>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Search Keys (asynchronously)
     * Search one or more Keys
     * @param offset This allows you to specify the page offset from the resulting list resultset you want the records to be returned (optional)
     * @param limit This allows you to specify the total number of records to be returned off the resulting list resultset (optional)
     * @param sort This allows you to specify a comma separated list of fields in the order which the resulting list resultset must be sorted. (optional)
     * @param organizationIds List of Orgaization Ids to search. The maximum size of the organization Ids list is 1. The maximum length of Organization Id is 30. (optional)
     * @param keyIds List of Key Ids to search. The maximum size of the Key Ids list is 1 (optional)
     * @param keyTypes Key Type, Possible values -  certificate, password, pgp and scmp_api. When Key Type is provided atleast one more filter needs to be provided (optional)
     * @param expirationStartDate Expiry Filter Start Date. When Expiration Date filter is provided, atleast one more filter needs to be provided (optional)
     * @param expirationEndDate Expiry Filter End Date. When Expiration Date filter is provided, atleast one more filter needs to be provided (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public okhttp3.Call searchKeysAsync(Integer offset, Integer limit, String sort, List<String> organizationIds, List<String> keyIds, List<String> keyTypes, DateTime expirationStartDate, DateTime expirationEndDate, final ApiCallback<InlineResponse2001> callback) throws ApiException {

        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        okhttp3.Call call = searchKeysValidateBeforeCall(offset, limit, sort, organizationIds, keyIds, keyTypes, expirationStartDate, expirationEndDate, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2001>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
