/*
 * CyberSource Merged Spec
 * All CyberSource API specs merged together. These are available at https://developer.cybersource.com/api/reference/api-reference.html
 *
 * OpenAPI spec version: 0.0.1
 * 
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package Model;

import java.util.Objects;
import java.util.Arrays;
import Model.Microformv2sessionsCheckoutApiInitialization;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * This is a server-to-server API request to generate the capture context that can be used to initiate instance of microform on a acceptance page.   The capture context is a digitally signed JWT that provides authentication, one-time keys, and the target origin to the Microform Integration application. 
 */
@ApiModel(description = "This is a server-to-server API request to generate the capture context that can be used to initiate instance of microform on a acceptance page.   The capture context is a digitally signed JWT that provides authentication, one-time keys, and the target origin to the Microform Integration application. ")

public class GenerateCaptureContextRequest {
  @SerializedName("targetOrigins")
  private List<String> targetOrigins = null;

  @SerializedName("allowedCardNetworks")
  private List<String> allowedCardNetworks = null;

  @SerializedName("clientVersion")
  private String clientVersion = null;

  @SerializedName("checkoutApiInitialization")
  private Microformv2sessionsCheckoutApiInitialization checkoutApiInitialization = null;

  public GenerateCaptureContextRequest targetOrigins(List<String> targetOrigins) {
    this.targetOrigins = targetOrigins;
    return this;
  }

  public GenerateCaptureContextRequest addTargetOriginsItem(String targetOriginsItem) {
    if (this.targetOrigins == null) {
      this.targetOrigins = new ArrayList<String>();
    }
    this.targetOrigins.add(targetOriginsItem);
    return this;
  }

   /**
   * The merchant origin domain (e.g. https://example.com) used to initiate microform Integration. Required to comply with CORS and CSP standards.
   * @return targetOrigins
  **/
  @ApiModelProperty(value = "The merchant origin domain (e.g. https://example.com) used to initiate microform Integration. Required to comply with CORS and CSP standards.")
  public List<String> getTargetOrigins() {
    return targetOrigins;
  }

  public void setTargetOrigins(List<String> targetOrigins) {
    this.targetOrigins = targetOrigins;
  }

  public GenerateCaptureContextRequest allowedCardNetworks(List<String> allowedCardNetworks) {
    this.allowedCardNetworks = allowedCardNetworks;
    return this;
  }

  public GenerateCaptureContextRequest addAllowedCardNetworksItem(String allowedCardNetworksItem) {
    if (this.allowedCardNetworks == null) {
      this.allowedCardNetworks = new ArrayList<String>();
    }
    this.allowedCardNetworks.add(allowedCardNetworksItem);
    return this;
  }

   /**
   * Get allowedCardNetworks
   * @return allowedCardNetworks
  **/
  @ApiModelProperty(example = "[\"VISA\",\"MAESTRO\",\"MASTERCARD\",\"AMEX\",\"DISCOVER\",\"DINERSCLUB\",\"JCB\",\"CUP\",\"CARTESBANCAIRES\"]", value = "")
  public List<String> getAllowedCardNetworks() {
    return allowedCardNetworks;
  }

  public void setAllowedCardNetworks(List<String> allowedCardNetworks) {
    this.allowedCardNetworks = allowedCardNetworks;
  }

  public GenerateCaptureContextRequest clientVersion(String clientVersion) {
    this.clientVersion = clientVersion;
    return this;
  }

   /**
   * Get clientVersion
   * @return clientVersion
  **/
  @ApiModelProperty(example = "v2.0", value = "")
  public String getClientVersion() {
    return clientVersion;
  }

  public void setClientVersion(String clientVersion) {
    this.clientVersion = clientVersion;
  }

  public GenerateCaptureContextRequest checkoutApiInitialization(Microformv2sessionsCheckoutApiInitialization checkoutApiInitialization) {
    this.checkoutApiInitialization = checkoutApiInitialization;
    return this;
  }

   /**
   * Get checkoutApiInitialization
   * @return checkoutApiInitialization
  **/
  @ApiModelProperty(value = "")
  public Microformv2sessionsCheckoutApiInitialization getCheckoutApiInitialization() {
    return checkoutApiInitialization;
  }

  public void setCheckoutApiInitialization(Microformv2sessionsCheckoutApiInitialization checkoutApiInitialization) {
    this.checkoutApiInitialization = checkoutApiInitialization;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GenerateCaptureContextRequest generateCaptureContextRequest = (GenerateCaptureContextRequest) o;
    return Objects.equals(this.targetOrigins, generateCaptureContextRequest.targetOrigins) &&
        Objects.equals(this.allowedCardNetworks, generateCaptureContextRequest.allowedCardNetworks) &&
        Objects.equals(this.clientVersion, generateCaptureContextRequest.clientVersion) &&
        Objects.equals(this.checkoutApiInitialization, generateCaptureContextRequest.checkoutApiInitialization);
  }

  @Override
  public int hashCode() {
    return Objects.hash(targetOrigins, allowedCardNetworks, clientVersion, checkoutApiInitialization);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GenerateCaptureContextRequest {\n");
    
    sb.append("    targetOrigins: ").append(toIndentedString(targetOrigins)).append("\n");
    sb.append("    allowedCardNetworks: ").append(toIndentedString(allowedCardNetworks)).append("\n");
    sb.append("    clientVersion: ").append(toIndentedString(clientVersion)).append("\n");
    sb.append("    checkoutApiInitialization: ").append(toIndentedString(checkoutApiInitialization)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

