/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.ReplayWebhooksRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class ReplayWebhooksApi {
    private static Logger logger = LogManager.getLogger(ReplayWebhooksApi.class);
    private ApiClient apiClient;

    public ReplayWebhooksApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ReplayWebhooksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call replayPreviousWebhooksCall(String webhookId, ReplayWebhooksRequest replayWebhooksRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(replayWebhooksRequest, ReplayWebhooksRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment());
        String localVarPath = "/nrtf/v1/webhooks/{webhookId}/replays".replaceAll("\\{webhookId\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call replayPreviousWebhooksValidateBeforeCall(String webhookId, ReplayWebhooksRequest replayWebhooksRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (webhookId == null) {
            logger.error("Missing the required parameter 'webhookId' when calling replayPreviousWebhooks(Async)");
            throw new ApiException("Missing the required parameter 'webhookId' when calling replayPreviousWebhooks(Async)");
        }
        Call call = this.replayPreviousWebhooksCall(webhookId, replayWebhooksRequest, progressListener, progressRequestListener);
        return call;
    }

    public void replayPreviousWebhooks(String webhookId, ReplayWebhooksRequest replayWebhooksRequest) throws ApiException {
        logger.info("CALL TO METHOD 'replayPreviousWebhooks' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        this.replayPreviousWebhooksWithHttpInfo(webhookId, replayWebhooksRequest);
    }

    public ApiResponse<Void> replayPreviousWebhooksWithHttpInfo(String webhookId, ReplayWebhooksRequest replayWebhooksRequest) throws ApiException {
        Call call = this.replayPreviousWebhooksValidateBeforeCall(webhookId, replayWebhooksRequest, null, null);
        return this.apiClient.execute(call);
    }

    public Call replayPreviousWebhooksAsync(String webhookId, ReplayWebhooksRequest replayWebhooksRequest, final ApiCallback<Void> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.replayPreviousWebhooksValidateBeforeCall(webhookId, replayWebhooksRequest, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

