/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class TransientTokenDataApi {
    private static Logger logger = LogManager.getLogger(TransientTokenDataApi.class);
    private ApiClient apiClient;

    public TransientTokenDataApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TransientTokenDataApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getPaymentCredentialsForTransientTokenCall(String paymentCredentialsReference, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        String localVarPath = "/flex/v2/payment-credentials/{paymentCredentialsReference}".replaceAll("\\{paymentCredentialsReference\\}", this.apiClient.escapeString(paymentCredentialsReference.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPaymentCredentialsForTransientTokenValidateBeforeCall(String paymentCredentialsReference, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (paymentCredentialsReference == null) {
            logger.error("Missing the required parameter 'paymentCredentialsReference' when calling getPaymentCredentialsForTransientToken(Async)");
            throw new ApiException("Missing the required parameter 'paymentCredentialsReference' when calling getPaymentCredentialsForTransientToken(Async)");
        }
        Call call = this.getPaymentCredentialsForTransientTokenCall(paymentCredentialsReference, progressListener, progressRequestListener);
        return call;
    }

    public String getPaymentCredentialsForTransientToken(String paymentCredentialsReference) throws ApiException {
        logger.info("CALL TO METHOD 'getPaymentCredentialsForTransientToken' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<String> resp = this.getPaymentCredentialsForTransientTokenWithHttpInfo(paymentCredentialsReference);
        logger.info("CALL TO METHOD 'getPaymentCredentialsForTransientToken' ENDED");
        return resp.getData();
    }

    public ApiResponse<String> getPaymentCredentialsForTransientTokenWithHttpInfo(String paymentCredentialsReference) throws ApiException {
        Call call = this.getPaymentCredentialsForTransientTokenValidateBeforeCall(paymentCredentialsReference, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPaymentCredentialsForTransientTokenAsync(String paymentCredentialsReference, final ApiCallback<String> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPaymentCredentialsForTransientTokenValidateBeforeCall(paymentCredentialsReference, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getTransactionForTransientTokenCall(String transientToken, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        String localVarPath = "/up/v1/payment-details/{transientToken}".replaceAll("\\{transientToken\\}", this.apiClient.escapeString(transientToken.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTransactionForTransientTokenValidateBeforeCall(String transientToken, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (transientToken == null) {
            logger.error("Missing the required parameter 'transientToken' when calling getTransactionForTransientToken(Async)");
            throw new ApiException("Missing the required parameter 'transientToken' when calling getTransactionForTransientToken(Async)");
        }
        Call call = this.getTransactionForTransientTokenCall(transientToken, progressListener, progressRequestListener);
        return call;
    }

    public void getTransactionForTransientToken(String transientToken) throws ApiException {
        logger.info("CALL TO METHOD 'getTransactionForTransientToken' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        this.getTransactionForTransientTokenWithHttpInfo(transientToken);
    }

    public ApiResponse<Void> getTransactionForTransientTokenWithHttpInfo(String transientToken) throws ApiException {
        Call call = this.getTransactionForTransientTokenValidateBeforeCall(transientToken, null, null);
        return this.apiClient.execute(call);
    }

    public Call getTransactionForTransientTokenAsync(String transientToken, final ApiCallback<Void> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTransactionForTransientTokenValidateBeforeCall(transientToken, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

