/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.PatchCustomerPaymentInstrumentRequest;
import Model.PaymentInstrumentList;
import Model.PostCustomerPaymentInstrumentRequest;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.util.mle.MLEException;
import com.cybersource.authsdk.util.mle.MLEUtility;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class CustomerPaymentInstrumentApi {
    private static Logger logger = LogManager.getLogger(CustomerPaymentInstrumentApi.class);
    private ApiClient apiClient;

    public CustomerPaymentInstrumentApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomerPaymentInstrumentApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteCustomerPaymentInstrumentCall(String customerId, String paymentInstrumentId, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        boolean isMLESupportedByCybsForApi;
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("DELETE".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)(isMLESupportedByCybsForApi = false), (String)"deleteCustomerPaymentInstrument,deleteCustomerPaymentInstrumentAsync,deleteCustomerPaymentInstrumentWithHttpInfo,deleteCustomerPaymentInstrumentCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/tms/v2/customers/{customerId}/payment-instruments/{paymentInstrumentId}".replaceAll("\\{customerId\\}", this.apiClient.escapeString(customerId.toString())).replaceAll("\\{paymentInstrumentId\\}", this.apiClient.escapeString(paymentInstrumentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteCustomerPaymentInstrumentValidateBeforeCall(String customerId, String paymentInstrumentId, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerId == null) {
            logger.error("Missing the required parameter 'customerId' when calling deleteCustomerPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'customerId' when calling deleteCustomerPaymentInstrument(Async)");
        }
        if (paymentInstrumentId == null) {
            logger.error("Missing the required parameter 'paymentInstrumentId' when calling deleteCustomerPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'paymentInstrumentId' when calling deleteCustomerPaymentInstrument(Async)");
        }
        Call call = this.deleteCustomerPaymentInstrumentCall(customerId, paymentInstrumentId, profileId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteCustomerPaymentInstrument(String customerId, String paymentInstrumentId, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'deleteCustomerPaymentInstrument' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        this.deleteCustomerPaymentInstrumentWithHttpInfo(customerId, paymentInstrumentId, profileId);
    }

    public ApiResponse<Void> deleteCustomerPaymentInstrumentWithHttpInfo(String customerId, String paymentInstrumentId, String profileId) throws ApiException {
        Call call = this.deleteCustomerPaymentInstrumentValidateBeforeCall(customerId, paymentInstrumentId, profileId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteCustomerPaymentInstrumentAsync(String customerId, String paymentInstrumentId, String profileId, final ApiCallback<Void> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCustomerPaymentInstrumentValidateBeforeCall(customerId, paymentInstrumentId, profileId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getCustomerPaymentInstrumentCall(String customerId, String paymentInstrumentId, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        boolean isMLESupportedByCybsForApi;
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)(isMLESupportedByCybsForApi = false), (String)"getCustomerPaymentInstrument,getCustomerPaymentInstrumentAsync,getCustomerPaymentInstrumentWithHttpInfo,getCustomerPaymentInstrumentCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/tms/v2/customers/{customerId}/payment-instruments/{paymentInstrumentId}".replaceAll("\\{customerId\\}", this.apiClient.escapeString(customerId.toString())).replaceAll("\\{paymentInstrumentId\\}", this.apiClient.escapeString(paymentInstrumentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomerPaymentInstrumentValidateBeforeCall(String customerId, String paymentInstrumentId, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerId == null) {
            logger.error("Missing the required parameter 'customerId' when calling getCustomerPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'customerId' when calling getCustomerPaymentInstrument(Async)");
        }
        if (paymentInstrumentId == null) {
            logger.error("Missing the required parameter 'paymentInstrumentId' when calling getCustomerPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'paymentInstrumentId' when calling getCustomerPaymentInstrument(Async)");
        }
        Call call = this.getCustomerPaymentInstrumentCall(customerId, paymentInstrumentId, profileId, progressListener, progressRequestListener);
        return call;
    }

    public PostCustomerPaymentInstrumentRequest getCustomerPaymentInstrument(String customerId, String paymentInstrumentId, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'getCustomerPaymentInstrument' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<PostCustomerPaymentInstrumentRequest> resp = this.getCustomerPaymentInstrumentWithHttpInfo(customerId, paymentInstrumentId, profileId);
        logger.info("CALL TO METHOD 'getCustomerPaymentInstrument' ENDED");
        return resp.getData();
    }

    public ApiResponse<PostCustomerPaymentInstrumentRequest> getCustomerPaymentInstrumentWithHttpInfo(String customerId, String paymentInstrumentId, String profileId) throws ApiException {
        Call call = this.getCustomerPaymentInstrumentValidateBeforeCall(customerId, paymentInstrumentId, profileId, null, null);
        Type localVarReturnType = new TypeToken<PostCustomerPaymentInstrumentRequest>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomerPaymentInstrumentAsync(String customerId, String paymentInstrumentId, String profileId, final ApiCallback<PostCustomerPaymentInstrumentRequest> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomerPaymentInstrumentValidateBeforeCall(customerId, paymentInstrumentId, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PostCustomerPaymentInstrumentRequest>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCustomerPaymentInstrumentsListCall(String customerId, String profileId, Long offset, Long limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        boolean isMLESupportedByCybsForApi;
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)(isMLESupportedByCybsForApi = false), (String)"getCustomerPaymentInstrumentsList,getCustomerPaymentInstrumentsListAsync,getCustomerPaymentInstrumentsListWithHttpInfo,getCustomerPaymentInstrumentsListCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/tms/v2/customers/{customerId}/payment-instruments".replaceAll("\\{customerId\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomerPaymentInstrumentsListValidateBeforeCall(String customerId, String profileId, Long offset, Long limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerId == null) {
            logger.error("Missing the required parameter 'customerId' when calling getCustomerPaymentInstrumentsList(Async)");
            throw new ApiException("Missing the required parameter 'customerId' when calling getCustomerPaymentInstrumentsList(Async)");
        }
        Call call = this.getCustomerPaymentInstrumentsListCall(customerId, profileId, offset, limit, progressListener, progressRequestListener);
        return call;
    }

    public PaymentInstrumentList getCustomerPaymentInstrumentsList(String customerId, String profileId, Long offset, Long limit) throws ApiException {
        logger.info("CALL TO METHOD 'getCustomerPaymentInstrumentsList' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<PaymentInstrumentList> resp = this.getCustomerPaymentInstrumentsListWithHttpInfo(customerId, profileId, offset, limit);
        logger.info("CALL TO METHOD 'getCustomerPaymentInstrumentsList' ENDED");
        return resp.getData();
    }

    public ApiResponse<PaymentInstrumentList> getCustomerPaymentInstrumentsListWithHttpInfo(String customerId, String profileId, Long offset, Long limit) throws ApiException {
        Call call = this.getCustomerPaymentInstrumentsListValidateBeforeCall(customerId, profileId, offset, limit, null, null);
        Type localVarReturnType = new TypeToken<PaymentInstrumentList>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomerPaymentInstrumentsListAsync(String customerId, String profileId, Long offset, Long limit, final ApiCallback<PaymentInstrumentList> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomerPaymentInstrumentsListValidateBeforeCall(customerId, profileId, offset, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PaymentInstrumentList>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchCustomersPaymentInstrumentCall(String customerId, String paymentInstrumentId, PatchCustomerPaymentInstrumentRequest patchCustomerPaymentInstrumentRequest, String profileId, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(patchCustomerPaymentInstrumentRequest, PatchCustomerPaymentInstrumentRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        boolean isMLESupportedByCybsForApi = false;
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)isMLESupportedByCybsForApi, (String)"patchCustomersPaymentInstrument,patchCustomersPaymentInstrumentAsync,patchCustomersPaymentInstrumentWithHttpInfo,patchCustomersPaymentInstrumentCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/tms/v2/customers/{customerId}/payment-instruments/{paymentInstrumentId}".replaceAll("\\{customerId\\}", this.apiClient.escapeString(customerId.toString())).replaceAll("\\{paymentInstrumentId\\}", this.apiClient.escapeString(paymentInstrumentId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        if (ifMatch != null) {
            localVarHeaderParams.put("if-match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchCustomersPaymentInstrumentValidateBeforeCall(String customerId, String paymentInstrumentId, PatchCustomerPaymentInstrumentRequest patchCustomerPaymentInstrumentRequest, String profileId, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerId == null) {
            logger.error("Missing the required parameter 'customerId' when calling patchCustomersPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'customerId' when calling patchCustomersPaymentInstrument(Async)");
        }
        if (paymentInstrumentId == null) {
            logger.error("Missing the required parameter 'paymentInstrumentId' when calling patchCustomersPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'paymentInstrumentId' when calling patchCustomersPaymentInstrument(Async)");
        }
        if (patchCustomerPaymentInstrumentRequest == null) {
            logger.error("Missing the required parameter 'patchCustomerPaymentInstrumentRequest' when calling patchCustomersPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'patchCustomerPaymentInstrumentRequest' when calling patchCustomersPaymentInstrument(Async)");
        }
        Call call = this.patchCustomersPaymentInstrumentCall(customerId, paymentInstrumentId, patchCustomerPaymentInstrumentRequest, profileId, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public PatchCustomerPaymentInstrumentRequest patchCustomersPaymentInstrument(String customerId, String paymentInstrumentId, PatchCustomerPaymentInstrumentRequest patchCustomerPaymentInstrumentRequest, String profileId, String ifMatch) throws ApiException {
        logger.info("CALL TO METHOD 'patchCustomersPaymentInstrument' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<PatchCustomerPaymentInstrumentRequest> resp = this.patchCustomersPaymentInstrumentWithHttpInfo(customerId, paymentInstrumentId, patchCustomerPaymentInstrumentRequest, profileId, ifMatch);
        logger.info("CALL TO METHOD 'patchCustomersPaymentInstrument' ENDED");
        return resp.getData();
    }

    public ApiResponse<PatchCustomerPaymentInstrumentRequest> patchCustomersPaymentInstrumentWithHttpInfo(String customerId, String paymentInstrumentId, PatchCustomerPaymentInstrumentRequest patchCustomerPaymentInstrumentRequest, String profileId, String ifMatch) throws ApiException {
        Call call = this.patchCustomersPaymentInstrumentValidateBeforeCall(customerId, paymentInstrumentId, patchCustomerPaymentInstrumentRequest, profileId, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<PatchCustomerPaymentInstrumentRequest>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchCustomersPaymentInstrumentAsync(String customerId, String paymentInstrumentId, PatchCustomerPaymentInstrumentRequest patchCustomerPaymentInstrumentRequest, String profileId, String ifMatch, final ApiCallback<PatchCustomerPaymentInstrumentRequest> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchCustomersPaymentInstrumentValidateBeforeCall(customerId, paymentInstrumentId, patchCustomerPaymentInstrumentRequest, profileId, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PatchCustomerPaymentInstrumentRequest>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postCustomerPaymentInstrumentCall(String customerId, PostCustomerPaymentInstrumentRequest postCustomerPaymentInstrumentRequest, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(postCustomerPaymentInstrumentRequest, PostCustomerPaymentInstrumentRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        boolean isMLESupportedByCybsForApi = false;
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)isMLESupportedByCybsForApi, (String)"postCustomerPaymentInstrument,postCustomerPaymentInstrumentAsync,postCustomerPaymentInstrumentWithHttpInfo,postCustomerPaymentInstrumentCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/tms/v2/customers/{customerId}/payment-instruments".replaceAll("\\{customerId\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postCustomerPaymentInstrumentValidateBeforeCall(String customerId, PostCustomerPaymentInstrumentRequest postCustomerPaymentInstrumentRequest, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerId == null) {
            logger.error("Missing the required parameter 'customerId' when calling postCustomerPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'customerId' when calling postCustomerPaymentInstrument(Async)");
        }
        if (postCustomerPaymentInstrumentRequest == null) {
            logger.error("Missing the required parameter 'postCustomerPaymentInstrumentRequest' when calling postCustomerPaymentInstrument(Async)");
            throw new ApiException("Missing the required parameter 'postCustomerPaymentInstrumentRequest' when calling postCustomerPaymentInstrument(Async)");
        }
        Call call = this.postCustomerPaymentInstrumentCall(customerId, postCustomerPaymentInstrumentRequest, profileId, progressListener, progressRequestListener);
        return call;
    }

    public PostCustomerPaymentInstrumentRequest postCustomerPaymentInstrument(String customerId, PostCustomerPaymentInstrumentRequest postCustomerPaymentInstrumentRequest, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'postCustomerPaymentInstrument' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<PostCustomerPaymentInstrumentRequest> resp = this.postCustomerPaymentInstrumentWithHttpInfo(customerId, postCustomerPaymentInstrumentRequest, profileId);
        logger.info("CALL TO METHOD 'postCustomerPaymentInstrument' ENDED");
        return resp.getData();
    }

    public ApiResponse<PostCustomerPaymentInstrumentRequest> postCustomerPaymentInstrumentWithHttpInfo(String customerId, PostCustomerPaymentInstrumentRequest postCustomerPaymentInstrumentRequest, String profileId) throws ApiException {
        Call call = this.postCustomerPaymentInstrumentValidateBeforeCall(customerId, postCustomerPaymentInstrumentRequest, profileId, null, null);
        Type localVarReturnType = new TypeToken<PostCustomerPaymentInstrumentRequest>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postCustomerPaymentInstrumentAsync(String customerId, PostCustomerPaymentInstrumentRequest postCustomerPaymentInstrumentRequest, String profileId, final ApiCallback<PostCustomerPaymentInstrumentRequest> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postCustomerPaymentInstrumentValidateBeforeCall(customerId, postCustomerPaymentInstrumentRequest, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PostCustomerPaymentInstrumentRequest>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

