/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.InlineResponse2003;
import Model.InlineResponse2004;
import Model.InlineResponse2015;
import Model.SaveAsymEgressKey;
import Model.UpdateWebhookRequest;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.util.mle.MLEException;
import com.cybersource.authsdk.util.mle.MLEUtility;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class ManageWebhooksApi {
    private static Logger logger = LogManager.getLogger(ManageWebhooksApi.class);
    private ApiClient apiClient;

    public ManageWebhooksApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ManageWebhooksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteWebhookSubscriptionCall(String webhookId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        boolean isMLESupportedByCybsForApi;
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("DELETE".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)(isMLESupportedByCybsForApi = false), (String)"deleteWebhookSubscription,deleteWebhookSubscriptionAsync,deleteWebhookSubscriptionWithHttpInfo,deleteWebhookSubscriptionCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/notification-subscriptions/v1/webhooks/{webhookId}".replaceAll("\\{webhookId\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteWebhookSubscriptionValidateBeforeCall(String webhookId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (webhookId == null) {
            logger.error("Missing the required parameter 'webhookId' when calling deleteWebhookSubscription(Async)");
            throw new ApiException("Missing the required parameter 'webhookId' when calling deleteWebhookSubscription(Async)");
        }
        Call call = this.deleteWebhookSubscriptionCall(webhookId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteWebhookSubscription(String webhookId) throws ApiException {
        logger.info("CALL TO METHOD 'deleteWebhookSubscription' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        this.deleteWebhookSubscriptionWithHttpInfo(webhookId);
    }

    public ApiResponse<Void> deleteWebhookSubscriptionWithHttpInfo(String webhookId) throws ApiException {
        Call call = this.deleteWebhookSubscriptionValidateBeforeCall(webhookId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteWebhookSubscriptionAsync(String webhookId, final ApiCallback<Void> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteWebhookSubscriptionValidateBeforeCall(webhookId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getWebhookSubscriptionByIdCall(String webhookId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        boolean isMLESupportedByCybsForApi;
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)(isMLESupportedByCybsForApi = false), (String)"getWebhookSubscriptionById,getWebhookSubscriptionByIdAsync,getWebhookSubscriptionByIdWithHttpInfo,getWebhookSubscriptionByIdCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/notification-subscriptions/v1/webhooks/{webhookId}".replaceAll("\\{webhookId\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getWebhookSubscriptionByIdValidateBeforeCall(String webhookId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (webhookId == null) {
            logger.error("Missing the required parameter 'webhookId' when calling getWebhookSubscriptionById(Async)");
            throw new ApiException("Missing the required parameter 'webhookId' when calling getWebhookSubscriptionById(Async)");
        }
        Call call = this.getWebhookSubscriptionByIdCall(webhookId, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse2004 getWebhookSubscriptionById(String webhookId) throws ApiException {
        logger.info("CALL TO METHOD 'getWebhookSubscriptionById' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<InlineResponse2004> resp = this.getWebhookSubscriptionByIdWithHttpInfo(webhookId);
        logger.info("CALL TO METHOD 'getWebhookSubscriptionById' ENDED");
        return resp.getData();
    }

    public ApiResponse<InlineResponse2004> getWebhookSubscriptionByIdWithHttpInfo(String webhookId) throws ApiException {
        Call call = this.getWebhookSubscriptionByIdValidateBeforeCall(webhookId, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2004>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getWebhookSubscriptionByIdAsync(String webhookId, final ApiCallback<InlineResponse2004> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getWebhookSubscriptionByIdValidateBeforeCall(webhookId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2004>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getWebhookSubscriptionsByOrgCall(String organizationId, String productId, String eventType, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        boolean isMLESupportedByCybsForApi;
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)(isMLESupportedByCybsForApi = false), (String)"getWebhookSubscriptionsByOrg,getWebhookSubscriptionsByOrgAsync,getWebhookSubscriptionsByOrgWithHttpInfo,getWebhookSubscriptionsByOrgCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/notification-subscriptions/v1/webhooks";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (organizationId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "organizationId", organizationId));
        }
        if (productId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "productId", productId));
        }
        if (eventType != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "eventType", eventType));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getWebhookSubscriptionsByOrgValidateBeforeCall(String organizationId, String productId, String eventType, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (organizationId == null) {
            logger.error("Missing the required parameter 'organizationId' when calling getWebhookSubscriptionsByOrg(Async)");
            throw new ApiException("Missing the required parameter 'organizationId' when calling getWebhookSubscriptionsByOrg(Async)");
        }
        if (productId == null) {
            logger.error("Missing the required parameter 'productId' when calling getWebhookSubscriptionsByOrg(Async)");
            throw new ApiException("Missing the required parameter 'productId' when calling getWebhookSubscriptionsByOrg(Async)");
        }
        if (eventType == null) {
            logger.error("Missing the required parameter 'eventType' when calling getWebhookSubscriptionsByOrg(Async)");
            throw new ApiException("Missing the required parameter 'eventType' when calling getWebhookSubscriptionsByOrg(Async)");
        }
        Call call = this.getWebhookSubscriptionsByOrgCall(organizationId, productId, eventType, progressListener, progressRequestListener);
        return call;
    }

    public List<InlineResponse2003> getWebhookSubscriptionsByOrg(String organizationId, String productId, String eventType) throws ApiException {
        logger.info("CALL TO METHOD 'getWebhookSubscriptionsByOrg' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<List<InlineResponse2003>> resp = this.getWebhookSubscriptionsByOrgWithHttpInfo(organizationId, productId, eventType);
        logger.info("CALL TO METHOD 'getWebhookSubscriptionsByOrg' ENDED");
        return resp.getData();
    }

    public ApiResponse<List<InlineResponse2003>> getWebhookSubscriptionsByOrgWithHttpInfo(String organizationId, String productId, String eventType) throws ApiException {
        Call call = this.getWebhookSubscriptionsByOrgValidateBeforeCall(organizationId, productId, eventType, null, null);
        Type localVarReturnType = new TypeToken<List<InlineResponse2003>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getWebhookSubscriptionsByOrgAsync(String organizationId, String productId, String eventType, final ApiCallback<List<InlineResponse2003>> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getWebhookSubscriptionsByOrgValidateBeforeCall(organizationId, productId, eventType, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<InlineResponse2003>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call saveAsymEgressKeyCall(String vCSenderOrganizationId, String vCPermissions, SaveAsymEgressKey saveAsymEgressKey, String vCCorrelationId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(saveAsymEgressKey, SaveAsymEgressKey.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        boolean isMLESupportedByCybsForApi = false;
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)isMLESupportedByCybsForApi, (String)"saveAsymEgressKey,saveAsymEgressKeyAsync,saveAsymEgressKeyWithHttpInfo,saveAsymEgressKeyCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/kms/egress/v2/keys-asym";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (vCCorrelationId != null) {
            localVarHeaderParams.put("v-c-correlation-id", this.apiClient.parameterToString(vCCorrelationId));
        }
        if (vCSenderOrganizationId != null) {
            localVarHeaderParams.put("v-c-sender-organization-id", this.apiClient.parameterToString(vCSenderOrganizationId));
        }
        if (vCPermissions != null) {
            localVarHeaderParams.put("v-c-permissions", this.apiClient.parameterToString(vCPermissions));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call saveAsymEgressKeyValidateBeforeCall(String vCSenderOrganizationId, String vCPermissions, SaveAsymEgressKey saveAsymEgressKey, String vCCorrelationId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (vCSenderOrganizationId == null) {
            logger.error("Missing the required parameter 'vCSenderOrganizationId' when calling saveAsymEgressKey(Async)");
            throw new ApiException("Missing the required parameter 'vCSenderOrganizationId' when calling saveAsymEgressKey(Async)");
        }
        if (vCPermissions == null) {
            logger.error("Missing the required parameter 'vCPermissions' when calling saveAsymEgressKey(Async)");
            throw new ApiException("Missing the required parameter 'vCPermissions' when calling saveAsymEgressKey(Async)");
        }
        if (saveAsymEgressKey == null) {
            logger.error("Missing the required parameter 'saveAsymEgressKey' when calling saveAsymEgressKey(Async)");
            throw new ApiException("Missing the required parameter 'saveAsymEgressKey' when calling saveAsymEgressKey(Async)");
        }
        Call call = this.saveAsymEgressKeyCall(vCSenderOrganizationId, vCPermissions, saveAsymEgressKey, vCCorrelationId, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse2015 saveAsymEgressKey(String vCSenderOrganizationId, String vCPermissions, SaveAsymEgressKey saveAsymEgressKey, String vCCorrelationId) throws ApiException {
        logger.info("CALL TO METHOD 'saveAsymEgressKey' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<InlineResponse2015> resp = this.saveAsymEgressKeyWithHttpInfo(vCSenderOrganizationId, vCPermissions, saveAsymEgressKey, vCCorrelationId);
        logger.info("CALL TO METHOD 'saveAsymEgressKey' ENDED");
        return resp.getData();
    }

    public ApiResponse<InlineResponse2015> saveAsymEgressKeyWithHttpInfo(String vCSenderOrganizationId, String vCPermissions, SaveAsymEgressKey saveAsymEgressKey, String vCCorrelationId) throws ApiException {
        Call call = this.saveAsymEgressKeyValidateBeforeCall(vCSenderOrganizationId, vCPermissions, saveAsymEgressKey, vCCorrelationId, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2015>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call saveAsymEgressKeyAsync(String vCSenderOrganizationId, String vCPermissions, SaveAsymEgressKey saveAsymEgressKey, String vCCorrelationId, final ApiCallback<InlineResponse2015> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.saveAsymEgressKeyValidateBeforeCall(vCSenderOrganizationId, vCPermissions, saveAsymEgressKey, vCCorrelationId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2015>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateWebhookSubscriptionCall(String webhookId, UpdateWebhookRequest updateWebhookRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(updateWebhookRequest, UpdateWebhookRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        boolean isMLESupportedByCybsForApi = false;
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)isMLESupportedByCybsForApi, (String)"updateWebhookSubscription,updateWebhookSubscriptionAsync,updateWebhookSubscriptionWithHttpInfo,updateWebhookSubscriptionCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/notification-subscriptions/v1/webhooks/{webhookId}".replaceAll("\\{webhookId\\}", this.apiClient.escapeString(webhookId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateWebhookSubscriptionValidateBeforeCall(String webhookId, UpdateWebhookRequest updateWebhookRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (webhookId == null) {
            logger.error("Missing the required parameter 'webhookId' when calling updateWebhookSubscription(Async)");
            throw new ApiException("Missing the required parameter 'webhookId' when calling updateWebhookSubscription(Async)");
        }
        Call call = this.updateWebhookSubscriptionCall(webhookId, updateWebhookRequest, progressListener, progressRequestListener);
        return call;
    }

    public void updateWebhookSubscription(String webhookId, UpdateWebhookRequest updateWebhookRequest) throws ApiException {
        logger.info("CALL TO METHOD 'updateWebhookSubscription' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        this.updateWebhookSubscriptionWithHttpInfo(webhookId, updateWebhookRequest);
    }

    public ApiResponse<Void> updateWebhookSubscriptionWithHttpInfo(String webhookId, UpdateWebhookRequest updateWebhookRequest) throws ApiException {
        Call call = this.updateWebhookSubscriptionValidateBeforeCall(webhookId, updateWebhookRequest, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateWebhookSubscriptionAsync(String webhookId, UpdateWebhookRequest updateWebhookRequest, final ApiCallback<Void> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateWebhookSubscriptionValidateBeforeCall(webhookId, updateWebhookRequest, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

