/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.CreateSearchRequest;
import Model.TssV2TransactionsPost201Response;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.util.mle.MLEException;
import com.cybersource.authsdk.util.mle.MLEUtility;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class SearchTransactionsApi {
    private static Logger logger = LogManager.getLogger(SearchTransactionsApi.class);
    private ApiClient apiClient;

    public SearchTransactionsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SearchTransactionsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createSearchCall(CreateSearchRequest createSearchRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(createSearchRequest, CreateSearchRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        boolean isMLESupportedByCybsForApi = false;
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)isMLESupportedByCybsForApi, (String)"createSearch,createSearchAsync,createSearchWithHttpInfo,createSearchCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/tss/v2/searches";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createSearchValidateBeforeCall(CreateSearchRequest createSearchRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (createSearchRequest == null) {
            logger.error("Missing the required parameter 'createSearchRequest' when calling createSearch(Async)");
            throw new ApiException("Missing the required parameter 'createSearchRequest' when calling createSearch(Async)");
        }
        Call call = this.createSearchCall(createSearchRequest, progressListener, progressRequestListener);
        return call;
    }

    public TssV2TransactionsPost201Response createSearch(CreateSearchRequest createSearchRequest) throws ApiException {
        logger.info("CALL TO METHOD 'createSearch' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<TssV2TransactionsPost201Response> resp = this.createSearchWithHttpInfo(createSearchRequest);
        logger.info("CALL TO METHOD 'createSearch' ENDED");
        return resp.getData();
    }

    public ApiResponse<TssV2TransactionsPost201Response> createSearchWithHttpInfo(CreateSearchRequest createSearchRequest) throws ApiException {
        Call call = this.createSearchValidateBeforeCall(createSearchRequest, null, null);
        Type localVarReturnType = new TypeToken<TssV2TransactionsPost201Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createSearchAsync(CreateSearchRequest createSearchRequest, final ApiCallback<TssV2TransactionsPost201Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createSearchValidateBeforeCall(createSearchRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TssV2TransactionsPost201Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getSearchCall(String searchId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        boolean isMLESupportedByCybsForApi;
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)(isMLESupportedByCybsForApi = false), (String)"getSearch,getSearchAsync,getSearchWithHttpInfo,getSearchCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/tss/v2/searches/{searchId}".replaceAll("\\{searchId\\}", this.apiClient.escapeString(searchId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"*/*"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getSearchValidateBeforeCall(String searchId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (searchId == null) {
            logger.error("Missing the required parameter 'searchId' when calling getSearch(Async)");
            throw new ApiException("Missing the required parameter 'searchId' when calling getSearch(Async)");
        }
        Call call = this.getSearchCall(searchId, progressListener, progressRequestListener);
        return call;
    }

    public TssV2TransactionsPost201Response getSearch(String searchId) throws ApiException {
        logger.info("CALL TO METHOD 'getSearch' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<TssV2TransactionsPost201Response> resp = this.getSearchWithHttpInfo(searchId);
        logger.info("CALL TO METHOD 'getSearch' ENDED");
        return resp.getData();
    }

    public ApiResponse<TssV2TransactionsPost201Response> getSearchWithHttpInfo(String searchId) throws ApiException {
        Call call = this.getSearchValidateBeforeCall(searchId, null, null);
        Type localVarReturnType = new TypeToken<TssV2TransactionsPost201Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getSearchAsync(String searchId, final ApiCallback<TssV2TransactionsPost201Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getSearchValidateBeforeCall(searchId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TssV2TransactionsPost201Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

