/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.GenerateUnifiedCheckoutCaptureContextRequest;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.util.mle.MLEException;
import com.cybersource.authsdk.util.mle.MLEUtility;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class UnifiedCheckoutCaptureContextApi {
    private static Logger logger = LogManager.getLogger(UnifiedCheckoutCaptureContextApi.class);
    private ApiClient apiClient;

    public UnifiedCheckoutCaptureContextApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UnifiedCheckoutCaptureContextApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call generateUnifiedCheckoutCaptureContextCall(GenerateUnifiedCheckoutCaptureContextRequest generateUnifiedCheckoutCaptureContextRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(generateUnifiedCheckoutCaptureContextRequest, GenerateUnifiedCheckoutCaptureContextRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        boolean isMLESupportedByCybsForApi = false;
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)isMLESupportedByCybsForApi, (String)"generateUnifiedCheckoutCaptureContext,generateUnifiedCheckoutCaptureContextAsync,generateUnifiedCheckoutCaptureContextWithHttpInfo,generateUnifiedCheckoutCaptureContextCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/up/v1/capture-contexts";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/jwt"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call generateUnifiedCheckoutCaptureContextValidateBeforeCall(GenerateUnifiedCheckoutCaptureContextRequest generateUnifiedCheckoutCaptureContextRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (generateUnifiedCheckoutCaptureContextRequest == null) {
            logger.error("Missing the required parameter 'generateUnifiedCheckoutCaptureContextRequest' when calling generateUnifiedCheckoutCaptureContext(Async)");
            throw new ApiException("Missing the required parameter 'generateUnifiedCheckoutCaptureContextRequest' when calling generateUnifiedCheckoutCaptureContext(Async)");
        }
        Call call = this.generateUnifiedCheckoutCaptureContextCall(generateUnifiedCheckoutCaptureContextRequest, progressListener, progressRequestListener);
        return call;
    }

    public String generateUnifiedCheckoutCaptureContext(GenerateUnifiedCheckoutCaptureContextRequest generateUnifiedCheckoutCaptureContextRequest) throws ApiException {
        logger.info("CALL TO METHOD 'generateUnifiedCheckoutCaptureContext' STARTED");
        this.apiClient.setComputationStartTime(System.nanoTime());
        ApiResponse<String> resp = this.generateUnifiedCheckoutCaptureContextWithHttpInfo(generateUnifiedCheckoutCaptureContextRequest);
        logger.info("CALL TO METHOD 'generateUnifiedCheckoutCaptureContext' ENDED");
        return resp.getData();
    }

    public ApiResponse<String> generateUnifiedCheckoutCaptureContextWithHttpInfo(GenerateUnifiedCheckoutCaptureContextRequest generateUnifiedCheckoutCaptureContextRequest) throws ApiException {
        Call call = this.generateUnifiedCheckoutCaptureContextValidateBeforeCall(generateUnifiedCheckoutCaptureContextRequest, null, null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call generateUnifiedCheckoutCaptureContextAsync(GenerateUnifiedCheckoutCaptureContextRequest generateUnifiedCheckoutCaptureContextRequest, final ApiCallback<String> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.generateUnifiedCheckoutCaptureContextValidateBeforeCall(generateUnifiedCheckoutCaptureContextRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

