/*
 * Decompiled with CFR 0.152.
 */
package Model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A merchant descriptor is the line of copy that identifies transactions on a cardholder's account activity and statement. If this information is not populated, the data will be retrieved from OMS.")
public class CardProcessingConfigCommonMerchantDescriptorInformation {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="city")
    private String city = null;
    @SerializedName(value="country")
    private String country = null;
    @SerializedName(value="phone")
    private String phone = null;
    @SerializedName(value="state")
    private String state = null;
    @SerializedName(value="street")
    private String street = null;
    @SerializedName(value="zip")
    private String zip = null;
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="countryOfOrigin")
    private String countryOfOrigin = null;

    public CardProcessingConfigCommonMerchantDescriptorInformation name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Applicable for TSYS (tsys), RUPAY, American Express Direct (amexdirect) and Elavon Americas (elavonamericas) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>Yes</td><td>1</td><td>38</td><td>^[0-9a-zA-Z\\s]+$</td></tr> </table> ")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CardProcessingConfigCommonMerchantDescriptorInformation city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(value="Applicable for American Express Direct (amexdirect), TSYS (tsys), RUPAY and Elavon Americas (elavonamericas) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>Yes</td><td>1</td><td>21</td><td>^[0-9a-zA-Z\\s]+$</td></tr> </table> ")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public CardProcessingConfigCommonMerchantDescriptorInformation country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(value="Applicable for Six (six), Elavon Americas (elavonamericas), TSYS (tsys) and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>Yes</td><td>3</td><td>3</td><td>^[A-Z]+$</td></tr> </table> ")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public CardProcessingConfigCommonMerchantDescriptorInformation phone(String phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(value="Applicable for RUPAY, Elavon Americas (elavonamericas), American Express Direct (amexdirect) and TSYS (tsys) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>Yes</td><td>1</td><td>20</td><td>^[0-9a-zA-Z\\s]+$</td></tr> </table> ")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public CardProcessingConfigCommonMerchantDescriptorInformation state(String state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="Applicable for RUPAY, TSYS (tsys), Elavon Americas (elavonamericas) and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>No</td><td>1</td><td>3</td><td>^[A-Z]+$</td></tr> </table> ")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public CardProcessingConfigCommonMerchantDescriptorInformation street(String street) {
        this.street = street;
        return this;
    }

    @ApiModelProperty(value="Applicable for American Express Direct (amexdirect), TSYS (tsys) and Elavon Americas (elavonamericas) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>Yes</td><td>1</td><td>38</td><td>^[0-9a-zA-Z\\s]+$</td></tr> </table> ")
    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public CardProcessingConfigCommonMerchantDescriptorInformation zip(String zip) {
        this.zip = zip;
        return this;
    }

    @ApiModelProperty(value="Applicable for Elavon Americas (elavonamericas), RUPAY, American Express Direct (amexdirect) and TSYS (tsys) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, cp, hybrid</td><td>Yes</td><td>1</td><td>15</td><td>^[0-9a-zA-Z\\s]+$</td></tr> </table> ")
    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public CardProcessingConfigCommonMerchantDescriptorInformation url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="Applicable for RUPAY and American Express Direct (amexdirect) processors.  Validation details (for selected processors)...  <table> <thead><tr><th>Processor</th><th>Acceptance Type</th><th>Required</th><th>Min. Length</th><th>Max. Length</th><th>Regex</th></tr></thead> <tr><td>American Express Direct</td><td>cnp, hybrid</td><td>Yes</td><td>1</td><td>40</td><td>URL</td></tr> <tr><td>American Express Direct</td><td>cp</td><td>No</td><td>1</td><td>40</td><td>URL</td></tr> </table> ")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public CardProcessingConfigCommonMerchantDescriptorInformation countryOfOrigin(String countryOfOrigin) {
        this.countryOfOrigin = countryOfOrigin;
        return this;
    }

    @ApiModelProperty(value="Country Cf Origin of merchant is applicable for VPC Processors and is dependent on governmentControlled attribute.")
    public String getCountryOfOrigin() {
        return this.countryOfOrigin;
    }

    public void setCountryOfOrigin(String countryOfOrigin) {
        this.countryOfOrigin = countryOfOrigin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardProcessingConfigCommonMerchantDescriptorInformation cardProcessingConfigCommonMerchantDescriptorInformation = (CardProcessingConfigCommonMerchantDescriptorInformation)o;
        return Objects.equals(this.name, cardProcessingConfigCommonMerchantDescriptorInformation.name) && Objects.equals(this.city, cardProcessingConfigCommonMerchantDescriptorInformation.city) && Objects.equals(this.country, cardProcessingConfigCommonMerchantDescriptorInformation.country) && Objects.equals(this.phone, cardProcessingConfigCommonMerchantDescriptorInformation.phone) && Objects.equals(this.state, cardProcessingConfigCommonMerchantDescriptorInformation.state) && Objects.equals(this.street, cardProcessingConfigCommonMerchantDescriptorInformation.street) && Objects.equals(this.zip, cardProcessingConfigCommonMerchantDescriptorInformation.zip) && Objects.equals(this.url, cardProcessingConfigCommonMerchantDescriptorInformation.url) && Objects.equals(this.countryOfOrigin, cardProcessingConfigCommonMerchantDescriptorInformation.countryOfOrigin);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.city, this.country, this.phone, this.state, this.street, this.zip, this.url, this.countryOfOrigin);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardProcessingConfigCommonMerchantDescriptorInformation {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("    zip: ").append(this.toIndentedString(this.zip)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    countryOfOrigin: ").append(this.toIndentedString(this.countryOfOrigin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

