/*
 * Decompiled with CFR 0.152.
 */
package Model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="List of the line items from the order, which are included in an invoice.")
public class Invoicingv2invoicesOrderInformationLineItems {
    @SerializedName(value="productSku")
    private String productSku = null;
    @SerializedName(value="productName")
    private String productName = null;
    @SerializedName(value="quantity")
    private Integer quantity = null;
    @SerializedName(value="unitPrice")
    private String unitPrice = null;
    @SerializedName(value="discountAmount")
    private String discountAmount = null;
    @SerializedName(value="discountRate")
    private String discountRate = null;
    @SerializedName(value="taxAmount")
    private String taxAmount = null;
    @SerializedName(value="taxRate")
    private String taxRate = null;
    @SerializedName(value="totalAmount")
    private String totalAmount = null;

    public Invoicingv2invoicesOrderInformationLineItems productSku(String productSku) {
        this.productSku = productSku;
        return this;
    }

    @ApiModelProperty(value="Product identifier code. Also known as the Stock Keeping Unit (SKU) code for the product.  For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not set to **default** or one of the other values that are related to shipping and/or handling.  #### Tax Calculation Optional field for U.S. and Canadian taxes. Not applicable to international and value added taxes. For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the values related to shipping and/or handling. ")
    public String getProductSku() {
        return this.productSku;
    }

    public void setProductSku(String productSku) {
        this.productSku = productSku;
    }

    public Invoicingv2invoicesOrderInformationLineItems productName(String productName) {
        this.productName = productName;
        return this;
    }

    @ApiModelProperty(value="For an authorization or capture transaction (`processingOptions.capture` is `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the other values that are related to shipping and/or handling.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes. ")
    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public Invoicingv2invoicesOrderInformationLineItems quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(value="Number of units for this order. Must be a non-negative integer.  The default is `1`. For an authorization or capture transaction (`processingOptions.capture` is set to `true` or `false`), this field is required when `orderInformation.lineItems[].productCode` is not `default` or one of the other values related to shipping and/or handling.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes. ")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Invoicingv2invoicesOrderInformationLineItems unitPrice(String unitPrice) {
        this.unitPrice = unitPrice;
        return this;
    }

    @ApiModelProperty(value="Per-item price of the product. This value for this field cannot be negative.  You must include either this field or the request-level field `orderInformation.amountDetails.totalAmount` in your request.  You can include a decimal point (.), but you cannot include any other special characters. The value is truncated to the correct number of decimal places.  #### DCC with a Third-Party Provider Set this field to the converted amount that was returned by the DCC provider. You must include either the 1st line item in the order and this field, or the request-level field `orderInformation.amountDetails.totalAmount` in your request.  #### Tax Calculation Required field for U.S., Canadian, international and value added taxes.  #### Zero Amount Authorizations If your processor supports zero amount authorizations, you can set this field to 0 for the authorization to check if the card is lost or stolen.  #### Maximum Field Lengths For GPN and JCN Gateway: Decimal (10) All other processors: Decimal (15) ")
    public String getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(String unitPrice) {
        this.unitPrice = unitPrice;
    }

    public Invoicingv2invoicesOrderInformationLineItems discountAmount(String discountAmount) {
        this.discountAmount = discountAmount;
        return this;
    }

    @ApiModelProperty(value="Discount applied to the item.")
    public String getDiscountAmount() {
        return this.discountAmount;
    }

    public void setDiscountAmount(String discountAmount) {
        this.discountAmount = discountAmount;
    }

    public Invoicingv2invoicesOrderInformationLineItems discountRate(String discountRate) {
        this.discountRate = discountRate;
        return this;
    }

    @ApiModelProperty(value="Rate the item is discounted. Maximum of 2 decimal places.  Example 5.25 (=5.25%) ")
    public String getDiscountRate() {
        return this.discountRate;
    }

    public void setDiscountRate(String discountRate) {
        this.discountRate = discountRate;
    }

    public Invoicingv2invoicesOrderInformationLineItems taxAmount(String taxAmount) {
        this.taxAmount = taxAmount;
        return this;
    }

    @ApiModelProperty(value="Total tax to apply to the product. This value cannot be negative. The tax amount and the offer amount must be in the same currency. The tax amount field is additive.  The following example uses a two-exponent currency such as USD:   1. You include each line item in your request.  ..- 1st line item has amount=10.00, quantity=1, and taxAmount=0.80  ..- 2nd line item has amount=20.00, quantity=1, and taxAmount=1.60  2. The total amount authorized will be 32.40, not 30.00 with 2.40 of tax included.  Optional field.  #### Airlines processing Tax portion of the order amount. This value cannot exceed 99999999999999 (fourteen 9s). Format: English characters only. Optional request field for a line item.  #### Tax Calculation Optional field for U.S., Canadian, international tax, and value added taxes.  Note if you send this field in your tax request, the value in the field will override the tax engine ")
    public String getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(String taxAmount) {
        this.taxAmount = taxAmount;
    }

    public Invoicingv2invoicesOrderInformationLineItems taxRate(String taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    @ApiModelProperty(value="Tax rate applied to the item.  **Visa**: Valid range is 0.01 to 0.99 (1% to 99%, with only whole percentage values accepted; values with additional decimal places will be truncated).  **Mastercard**: Valid range is 0.00001 to 0.99999 (0.001% to 99.999%). ")
    public String getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(String taxRate) {
        this.taxRate = taxRate;
    }

    public Invoicingv2invoicesOrderInformationLineItems totalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
        return this;
    }

    @ApiModelProperty(value="Total amount for the item. Normally calculated as the unit price times quantity.  When `orderInformation.lineItems[].productCode` is \"gift_card\", this is the purchase amount total for prepaid gift cards in major units.  Example: 123.45 USD = 123 ")
    public String getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invoicingv2invoicesOrderInformationLineItems invoicingv2invoicesOrderInformationLineItems = (Invoicingv2invoicesOrderInformationLineItems)o;
        return Objects.equals(this.productSku, invoicingv2invoicesOrderInformationLineItems.productSku) && Objects.equals(this.productName, invoicingv2invoicesOrderInformationLineItems.productName) && Objects.equals(this.quantity, invoicingv2invoicesOrderInformationLineItems.quantity) && Objects.equals(this.unitPrice, invoicingv2invoicesOrderInformationLineItems.unitPrice) && Objects.equals(this.discountAmount, invoicingv2invoicesOrderInformationLineItems.discountAmount) && Objects.equals(this.discountRate, invoicingv2invoicesOrderInformationLineItems.discountRate) && Objects.equals(this.taxAmount, invoicingv2invoicesOrderInformationLineItems.taxAmount) && Objects.equals(this.taxRate, invoicingv2invoicesOrderInformationLineItems.taxRate) && Objects.equals(this.totalAmount, invoicingv2invoicesOrderInformationLineItems.totalAmount);
    }

    public int hashCode() {
        return Objects.hash(this.productSku, this.productName, this.quantity, this.unitPrice, this.discountAmount, this.discountRate, this.taxAmount, this.taxRate, this.totalAmount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Invoicingv2invoicesOrderInformationLineItems {\n");
        sb.append("    productSku: ").append(this.toIndentedString(this.productSku)).append("\n");
        sb.append("    productName: ").append(this.toIndentedString(this.productName)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    unitPrice: ").append(this.toIndentedString(this.unitPrice)).append("\n");
        sb.append("    discountAmount: ").append(this.toIndentedString(this.discountAmount)).append("\n");
        sb.append("    discountRate: ").append(this.toIndentedString(this.discountRate)).append("\n");
        sb.append("    taxAmount: ").append(this.toIndentedString(this.taxAmount)).append("\n");
        sb.append("    taxRate: ").append(this.toIndentedString(this.taxRate)).append("\n");
        sb.append("    totalAmount: ").append(this.toIndentedString(this.totalAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

