/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.PushFunds201Response;
import Model.PushFundsRequest;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.util.mle.MLEException;
import com.cybersource.authsdk.util.mle.MLEUtility;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class PushFundsApi {
    private static Logger logger = LogManager.getLogger(PushFundsApi.class);
    private ApiClient apiClient;

    public PushFundsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PushFundsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createPushFundsTransferCall(PushFundsRequest pushFundsRequest, String contentType, String xRequestid, String vCMerchantId, String vCPermissions, String vCCorrelationId, String vCOrganizationId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(pushFundsRequest, PushFundsRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        boolean isMLESupportedByCybsForApi = true;
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)isMLESupportedByCybsForApi, (String)"createPushFundsTransfer,createPushFundsTransferAsync,createPushFundsTransferWithHttpInfo,createPushFundsTransferCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/pts/v1/push-funds-transfer";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", this.apiClient.parameterToString(contentType));
        }
        if (xRequestid != null) {
            localVarHeaderParams.put("x-requestid", this.apiClient.parameterToString(xRequestid));
        }
        if (vCMerchantId != null) {
            localVarHeaderParams.put("v-c-merchant-id", this.apiClient.parameterToString(vCMerchantId));
        }
        if (vCPermissions != null) {
            localVarHeaderParams.put("v-c-permissions", this.apiClient.parameterToString(vCPermissions));
        }
        if (vCCorrelationId != null) {
            localVarHeaderParams.put("v-c-correlation-id", this.apiClient.parameterToString(vCCorrelationId));
        }
        if (vCOrganizationId != null) {
            localVarHeaderParams.put("v-c-organization-id", this.apiClient.parameterToString(vCOrganizationId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createPushFundsTransferValidateBeforeCall(PushFundsRequest pushFundsRequest, String contentType, String xRequestid, String vCMerchantId, String vCPermissions, String vCCorrelationId, String vCOrganizationId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (pushFundsRequest == null) {
            logger.error("Missing the required parameter 'pushFundsRequest' when calling createPushFundsTransfer(Async)");
            throw new ApiException("Missing the required parameter 'pushFundsRequest' when calling createPushFundsTransfer(Async)");
        }
        if (contentType == null) {
            logger.error("Missing the required parameter 'contentType' when calling createPushFundsTransfer(Async)");
            throw new ApiException("Missing the required parameter 'contentType' when calling createPushFundsTransfer(Async)");
        }
        if (xRequestid == null) {
            logger.error("Missing the required parameter 'xRequestid' when calling createPushFundsTransfer(Async)");
            throw new ApiException("Missing the required parameter 'xRequestid' when calling createPushFundsTransfer(Async)");
        }
        if (vCMerchantId == null) {
            logger.error("Missing the required parameter 'vCMerchantId' when calling createPushFundsTransfer(Async)");
            throw new ApiException("Missing the required parameter 'vCMerchantId' when calling createPushFundsTransfer(Async)");
        }
        if (vCPermissions == null) {
            logger.error("Missing the required parameter 'vCPermissions' when calling createPushFundsTransfer(Async)");
            throw new ApiException("Missing the required parameter 'vCPermissions' when calling createPushFundsTransfer(Async)");
        }
        if (vCCorrelationId == null) {
            logger.error("Missing the required parameter 'vCCorrelationId' when calling createPushFundsTransfer(Async)");
            throw new ApiException("Missing the required parameter 'vCCorrelationId' when calling createPushFundsTransfer(Async)");
        }
        if (vCOrganizationId == null) {
            logger.error("Missing the required parameter 'vCOrganizationId' when calling createPushFundsTransfer(Async)");
            throw new ApiException("Missing the required parameter 'vCOrganizationId' when calling createPushFundsTransfer(Async)");
        }
        Call call = this.createPushFundsTransferCall(pushFundsRequest, contentType, xRequestid, vCMerchantId, vCPermissions, vCCorrelationId, vCOrganizationId, progressListener, progressRequestListener);
        return call;
    }

    public PushFunds201Response createPushFundsTransfer(PushFundsRequest pushFundsRequest, String contentType, String xRequestid, String vCMerchantId, String vCPermissions, String vCCorrelationId, String vCOrganizationId) throws ApiException {
        logger.info("CALL TO METHOD 'createPushFundsTransfer' STARTED");
        ApiResponse<PushFunds201Response> resp = this.createPushFundsTransferWithHttpInfo(pushFundsRequest, contentType, xRequestid, vCMerchantId, vCPermissions, vCCorrelationId, vCOrganizationId);
        logger.info("CALL TO METHOD 'createPushFundsTransfer' ENDED");
        return resp.getData();
    }

    public ApiResponse<PushFunds201Response> createPushFundsTransferWithHttpInfo(PushFundsRequest pushFundsRequest, String contentType, String xRequestid, String vCMerchantId, String vCPermissions, String vCCorrelationId, String vCOrganizationId) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.createPushFundsTransferValidateBeforeCall(pushFundsRequest, contentType, xRequestid, vCMerchantId, vCPermissions, vCCorrelationId, vCOrganizationId, null, null);
        Type localVarReturnType = new TypeToken<PushFunds201Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createPushFundsTransferAsync(PushFundsRequest pushFundsRequest, String contentType, String xRequestid, String vCMerchantId, String vCPermissions, String vCCorrelationId, String vCOrganizationId, final ApiCallback<PushFunds201Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createPushFundsTransferValidateBeforeCall(pushFundsRequest, contentType, xRequestid, vCMerchantId, vCPermissions, vCCorrelationId, vCOrganizationId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PushFunds201Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

