/*
 * Decompiled with CFR 0.152.
 */
package Model;

import Model.Microformv2sessionsTransientTokenResponseOptions;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="This is a server-to-server API request to generate the capture context that can be used to initiate an instance of Microform on an acceptance page.   The capture context is a digitally signed JWT that provides authentication, one-time keys, and the target origin to the Microform Integration application. ")
public class GenerateCaptureContextRequest {
    @SerializedName(value="clientVersion")
    private String clientVersion = null;
    @SerializedName(value="targetOrigins")
    private List<String> targetOrigins = null;
    @SerializedName(value="allowedCardNetworks")
    private List<String> allowedCardNetworks = null;
    @SerializedName(value="allowedPaymentTypes")
    private List<String> allowedPaymentTypes = null;
    @SerializedName(value="transientTokenResponseOptions")
    private Microformv2sessionsTransientTokenResponseOptions transientTokenResponseOptions = null;

    public GenerateCaptureContextRequest clientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
        return this;
    }

    @ApiModelProperty(value="Specify the version of Microform that you want to use. ")
    public String getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(String clientVersion) {
        this.clientVersion = clientVersion;
    }

    public GenerateCaptureContextRequest targetOrigins(List<String> targetOrigins) {
        this.targetOrigins = targetOrigins;
        return this;
    }

    public GenerateCaptureContextRequest addTargetOriginsItem(String targetOriginsItem) {
        if (this.targetOrigins == null) {
            this.targetOrigins = new ArrayList<String>();
        }
        this.targetOrigins.add(targetOriginsItem);
        return this;
    }

    @ApiModelProperty(value="The [target origin](https://developer.mozilla.org/en-US/docs/Glossary/Origin) of the website on which you will be launching Microform is defined by the scheme (protocol), hostname (domain) and port number (if used).    You must use https://hostname (unless you use http://localhost) Wildcards are NOT supported.  Ensure that subdomains are included. Any valid top-level domain is supported (e.g. .com, .co.uk, .gov.br etc)  Examples:   - https://example.com   - https://subdomain.example.com   - https://example.com:8080<br><br>  If you are embedding within multiple nested iframes you need to specify the origins of all the browser contexts used, for example:    targetOrigins: [     \"https://example.com\",     \"https://basket.example.com\",     \"https://ecom.example.com\"   ] ")
    public List<String> getTargetOrigins() {
        return this.targetOrigins;
    }

    public void setTargetOrigins(List<String> targetOrigins) {
        this.targetOrigins = targetOrigins;
    }

    public GenerateCaptureContextRequest allowedCardNetworks(List<String> allowedCardNetworks) {
        this.allowedCardNetworks = allowedCardNetworks;
        return this;
    }

    public GenerateCaptureContextRequest addAllowedCardNetworksItem(String allowedCardNetworksItem) {
        if (this.allowedCardNetworks == null) {
            this.allowedCardNetworks = new ArrayList<String>();
        }
        this.allowedCardNetworks.add(allowedCardNetworksItem);
        return this;
    }

    @ApiModelProperty(value="The list of card networks you want to use for this Microform transaction.  Microform currently supports the following card networks: - VISA - MASTERCARD - AMEX - CARNET - CARTESBANCAIRES - CUP - DINERSCLUB - DISCOVER - EFTPOS - ELO - JCB - JCREW - MADA - MAESTRO - MEEZA  **Important:**    - When integrating Microform (Card) at least one card network should be specified in the allowedCardNetworks field in the capture context request.   - When integrating Microform (ACH/Echeck) the allowedCardNetworks field is not required in the capture context request.   - When integrating both Microform (Card) and Microform (ACH/Echeck) at least one card network should be specified in the allowedCardNetworks field in the capture context request. ")
    public List<String> getAllowedCardNetworks() {
        return this.allowedCardNetworks;
    }

    public void setAllowedCardNetworks(List<String> allowedCardNetworks) {
        this.allowedCardNetworks = allowedCardNetworks;
    }

    public GenerateCaptureContextRequest allowedPaymentTypes(List<String> allowedPaymentTypes) {
        this.allowedPaymentTypes = allowedPaymentTypes;
        return this;
    }

    public GenerateCaptureContextRequest addAllowedPaymentTypesItem(String allowedPaymentTypesItem) {
        if (this.allowedPaymentTypes == null) {
            this.allowedPaymentTypes = new ArrayList<String>();
        }
        this.allowedPaymentTypes.add(allowedPaymentTypesItem);
        return this;
    }

    @ApiModelProperty(value="The payment types that are allowed for the merchant.    Possible values when launching Microform: - CARD - CHECK <br><br> ")
    public List<String> getAllowedPaymentTypes() {
        return this.allowedPaymentTypes;
    }

    public void setAllowedPaymentTypes(List<String> allowedPaymentTypes) {
        this.allowedPaymentTypes = allowedPaymentTypes;
    }

    public GenerateCaptureContextRequest transientTokenResponseOptions(Microformv2sessionsTransientTokenResponseOptions transientTokenResponseOptions) {
        this.transientTokenResponseOptions = transientTokenResponseOptions;
        return this;
    }

    @ApiModelProperty(value="")
    public Microformv2sessionsTransientTokenResponseOptions getTransientTokenResponseOptions() {
        return this.transientTokenResponseOptions;
    }

    public void setTransientTokenResponseOptions(Microformv2sessionsTransientTokenResponseOptions transientTokenResponseOptions) {
        this.transientTokenResponseOptions = transientTokenResponseOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenerateCaptureContextRequest generateCaptureContextRequest = (GenerateCaptureContextRequest)o;
        return Objects.equals(this.clientVersion, generateCaptureContextRequest.clientVersion) && Objects.equals(this.targetOrigins, generateCaptureContextRequest.targetOrigins) && Objects.equals(this.allowedCardNetworks, generateCaptureContextRequest.allowedCardNetworks) && Objects.equals(this.allowedPaymentTypes, generateCaptureContextRequest.allowedPaymentTypes) && Objects.equals(this.transientTokenResponseOptions, generateCaptureContextRequest.transientTokenResponseOptions);
    }

    public int hashCode() {
        return Objects.hash(this.clientVersion, this.targetOrigins, this.allowedCardNetworks, this.allowedPaymentTypes, this.transientTokenResponseOptions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GenerateCaptureContextRequest {\n");
        if (this.clientVersion != null) {
            sb.append("    clientVersion: ").append(this.toIndentedString(this.clientVersion)).append("\n");
        }
        if (this.targetOrigins != null) {
            sb.append("    targetOrigins: ").append(this.toIndentedString(this.targetOrigins)).append("\n");
        }
        if (this.allowedCardNetworks != null) {
            sb.append("    allowedCardNetworks: ").append(this.toIndentedString(this.allowedCardNetworks)).append("\n");
        }
        if (this.allowedPaymentTypes != null) {
            sb.append("    allowedPaymentTypes: ").append(this.toIndentedString(this.allowedPaymentTypes)).append("\n");
        }
        if (this.transientTokenResponseOptions != null) {
            sb.append("    transientTokenResponseOptions: ").append(this.toIndentedString(this.transientTokenResponseOptions)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            // empty if block
        }
        return o.toString().replace("\n", "\n    ");
    }
}

