/*
 * Decompiled with CFR 0.152.
 */
package Model;

import Model.Tmsv2TokenizedCardCard;
import Model.Tmsv2TokenizedCardLinks;
import Model.Tmsv2TokenizedCardMetadata;
import Model.Tmsv2TokenizedCardPasscode;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class Tmsv2TokenizedCard {
    @SerializedName(value="_links")
    private Tmsv2TokenizedCardLinks links = null;
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="object")
    private String object = null;
    @SerializedName(value="accountReferenceId")
    private String accountReferenceId = null;
    @SerializedName(value="consumerId")
    private String consumerId = null;
    @SerializedName(value="createInstrumentIdentifier")
    private Boolean createInstrumentIdentifier = null;
    @SerializedName(value="source")
    private String source = null;
    @SerializedName(value="state")
    private String state = null;
    @SerializedName(value="reason")
    private String reason = null;
    @SerializedName(value="number")
    private String number = null;
    @SerializedName(value="cryptogram")
    private String cryptogram = null;
    @SerializedName(value="securityCode")
    private String securityCode = null;
    @SerializedName(value="eci")
    private String eci = null;
    @SerializedName(value="requestorId")
    private String requestorId = null;
    @SerializedName(value="enrollmentId")
    private String enrollmentId = null;
    @SerializedName(value="tokenReferenceId")
    private String tokenReferenceId = null;
    @SerializedName(value="paymentAccountReference")
    private String paymentAccountReference = null;
    @SerializedName(value="card")
    private Tmsv2TokenizedCardCard card = null;
    @SerializedName(value="passcode")
    private Tmsv2TokenizedCardPasscode passcode = null;
    @SerializedName(value="metadata")
    private Tmsv2TokenizedCardMetadata metadata = null;

    public Tmsv2TokenizedCard links(Tmsv2TokenizedCardLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public Tmsv2TokenizedCardLinks getLinks() {
        return this.links;
    }

    public void setLinks(Tmsv2TokenizedCardLinks links) {
        this.links = links;
    }

    @ApiModelProperty(value="The Id of the Tokenized Card. ")
    public String getId() {
        return this.id;
    }

    @ApiModelProperty(example="tokenizedCard", value="The type. Possible Values: - tokenizedCard ")
    public String getObject() {
        return this.object;
    }

    public Tmsv2TokenizedCard accountReferenceId(String accountReferenceId) {
        this.accountReferenceId = accountReferenceId;
        return this;
    }

    @ApiModelProperty(value="An identifier provided by the issuer for the account. ")
    public String getAccountReferenceId() {
        return this.accountReferenceId;
    }

    public void setAccountReferenceId(String accountReferenceId) {
        this.accountReferenceId = accountReferenceId;
    }

    public Tmsv2TokenizedCard consumerId(String consumerId) {
        this.consumerId = consumerId;
        return this;
    }

    @ApiModelProperty(value="Identifier of the consumer within the wallet. Maximum 24 characters for VTS.")
    public String getConsumerId() {
        return this.consumerId;
    }

    public void setConsumerId(String consumerId) {
        this.consumerId = consumerId;
    }

    public Tmsv2TokenizedCard createInstrumentIdentifier(Boolean createInstrumentIdentifier) {
        this.createInstrumentIdentifier = createInstrumentIdentifier;
        return this;
    }

    @ApiModelProperty(value="Specifies whether the InstrumentId should be created (true) or not (false). Possible Values: - `true`: The InstrumentId should be created. - `false`: The InstrumentId should be created. ")
    public Boolean CreateInstrumentIdentifier() {
        return this.createInstrumentIdentifier;
    }

    public void setCreateInstrumentIdentifier(Boolean createInstrumentIdentifier) {
        this.createInstrumentIdentifier = createInstrumentIdentifier;
    }

    public Tmsv2TokenizedCard source(String source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(value="Source of the payment instrument. Possible Values: - ONFILE - TOKEN - ISSUER ")
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @ApiModelProperty(example="ACTIVE", value="State of the network token or network token provision. Possible Values:   ACTIVE : Network token is active.   SUSPENDED : Network token is suspended. This state can change back to ACTIVE.   DELETED : This is a final state for a network token instance.   UNPROVISIONED : A previous network token. ")
    public String getState() {
        return this.state;
    }

    @ApiModelProperty(example="ACTIVE", value="Issuers state for the network token Possible Values: - INVALID_REQUEST : The network token provision request contained invalid data. - CARD_VERIFICATION_FAILED : The network token provision request contained data that could not be verified. - CARD_NOT_ELIGIBLE : Card can currently not be used with issuer for tokenization. - CARD_NOT_ALLOWED : Card can currently not be used with card association for tokenization. - DECLINED : Card can currently not be used with issuer for tokenization. - SERVICE_UNAVAILABLE : The network token service was unavailable or timed out. - SYSTEM_ERROR : An unexpected error occurred with network token service, check configuration. ")
    public String getReason() {
        return this.reason;
    }

    @ApiModelProperty(value="The token requestor's network token for the provided PAN and consumer Id, if available. ")
    public String getNumber() {
        return this.number;
    }

    @ApiModelProperty(example="CgAFRFYFPTFOfg5rj2ais9wQAAAAAM=", value="Value generated by the card association to be used alongside the network token for processing a payment. ")
    public String getCryptogram() {
        return this.cryptogram;
    }

    @ApiModelProperty(example="4523", value="4-digit number generated by the card association to be used alogside the network token for processing a payment. Only supported for Amex and SCOF. ")
    public String getSecurityCode() {
        return this.securityCode;
    }

    @ApiModelProperty(value="Raw Electronic Commerce Indicator provided by the card association with the result of the cardholder authentication. ")
    public String getEci() {
        return this.eci;
    }

    @ApiModelProperty(value="11-digit identifier that uniquely identifies the Token Requestor. ")
    public String getRequestorId() {
        return this.requestorId;
    }

    @ApiModelProperty(value="Unique id to identify this PAN/ enrollment. ")
    public String getEnrollmentId() {
        return this.enrollmentId;
    }

    @ApiModelProperty(value="Unique ID for netwrok token. ")
    public String getTokenReferenceId() {
        return this.tokenReferenceId;
    }

    @ApiModelProperty(value="Payment account reference. ")
    public String getPaymentAccountReference() {
        return this.paymentAccountReference;
    }

    public Tmsv2TokenizedCard card(Tmsv2TokenizedCardCard card) {
        this.card = card;
        return this;
    }

    @ApiModelProperty(value="")
    public Tmsv2TokenizedCardCard getCard() {
        return this.card;
    }

    public void setCard(Tmsv2TokenizedCardCard card) {
        this.card = card;
    }

    public Tmsv2TokenizedCard passcode(Tmsv2TokenizedCardPasscode passcode) {
        this.passcode = passcode;
        return this;
    }

    @ApiModelProperty(value="")
    public Tmsv2TokenizedCardPasscode getPasscode() {
        return this.passcode;
    }

    public void setPasscode(Tmsv2TokenizedCardPasscode passcode) {
        this.passcode = passcode;
    }

    public Tmsv2TokenizedCard metadata(Tmsv2TokenizedCardMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="")
    public Tmsv2TokenizedCardMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Tmsv2TokenizedCardMetadata metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tmsv2TokenizedCard tmsv2TokenizedCard = (Tmsv2TokenizedCard)o;
        return Objects.equals(this.links, tmsv2TokenizedCard.links) && Objects.equals(this.id, tmsv2TokenizedCard.id) && Objects.equals(this.object, tmsv2TokenizedCard.object) && Objects.equals(this.accountReferenceId, tmsv2TokenizedCard.accountReferenceId) && Objects.equals(this.consumerId, tmsv2TokenizedCard.consumerId) && Objects.equals(this.createInstrumentIdentifier, tmsv2TokenizedCard.createInstrumentIdentifier) && Objects.equals(this.source, tmsv2TokenizedCard.source) && Objects.equals(this.state, tmsv2TokenizedCard.state) && Objects.equals(this.reason, tmsv2TokenizedCard.reason) && Objects.equals(this.number, tmsv2TokenizedCard.number) && Objects.equals(this.cryptogram, tmsv2TokenizedCard.cryptogram) && Objects.equals(this.securityCode, tmsv2TokenizedCard.securityCode) && Objects.equals(this.eci, tmsv2TokenizedCard.eci) && Objects.equals(this.requestorId, tmsv2TokenizedCard.requestorId) && Objects.equals(this.enrollmentId, tmsv2TokenizedCard.enrollmentId) && Objects.equals(this.tokenReferenceId, tmsv2TokenizedCard.tokenReferenceId) && Objects.equals(this.paymentAccountReference, tmsv2TokenizedCard.paymentAccountReference) && Objects.equals(this.card, tmsv2TokenizedCard.card) && Objects.equals(this.passcode, tmsv2TokenizedCard.passcode) && Objects.equals(this.metadata, tmsv2TokenizedCard.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.id, this.object, this.accountReferenceId, this.consumerId, this.createInstrumentIdentifier, this.source, this.state, this.reason, this.number, this.cryptogram, this.securityCode, this.eci, this.requestorId, this.enrollmentId, this.tokenReferenceId, this.paymentAccountReference, this.card, this.passcode, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Tmsv2TokenizedCard {\n");
        if (this.links != null) {
            sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        }
        if (this.id != null) {
            sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        }
        if (this.object != null) {
            sb.append("    object: ").append(this.toIndentedString(this.object)).append("\n");
        }
        if (this.accountReferenceId != null) {
            sb.append("    accountReferenceId: ").append(this.toIndentedString(this.accountReferenceId)).append("\n");
        }
        if (this.consumerId != null) {
            sb.append("    consumerId: ").append(this.toIndentedString(this.consumerId)).append("\n");
        }
        if (this.createInstrumentIdentifier != null) {
            sb.append("    createInstrumentIdentifier: ").append(this.toIndentedString(this.createInstrumentIdentifier)).append("\n");
        }
        if (this.source != null) {
            sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        }
        if (this.state != null) {
            sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        }
        if (this.reason != null) {
            sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        }
        if (this.number != null) {
            sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        }
        if (this.cryptogram != null) {
            sb.append("    cryptogram: ").append(this.toIndentedString(this.cryptogram)).append("\n");
        }
        if (this.securityCode != null) {
            sb.append("    securityCode: ").append(this.toIndentedString(this.securityCode)).append("\n");
        }
        if (this.eci != null) {
            sb.append("    eci: ").append(this.toIndentedString(this.eci)).append("\n");
        }
        if (this.requestorId != null) {
            sb.append("    requestorId: ").append(this.toIndentedString(this.requestorId)).append("\n");
        }
        if (this.enrollmentId != null) {
            sb.append("    enrollmentId: ").append(this.toIndentedString(this.enrollmentId)).append("\n");
        }
        if (this.tokenReferenceId != null) {
            sb.append("    tokenReferenceId: ").append(this.toIndentedString(this.tokenReferenceId)).append("\n");
        }
        if (this.paymentAccountReference != null) {
            sb.append("    paymentAccountReference: ").append(this.toIndentedString(this.paymentAccountReference)).append("\n");
        }
        if (this.card != null) {
            sb.append("    card: ").append(this.toIndentedString(this.card)).append("\n");
        }
        if (this.passcode != null) {
            sb.append("    passcode: ").append(this.toIndentedString(this.passcode)).append("\n");
        }
        if (this.metadata != null) {
            sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            // empty if block
        }
        return o.toString().replace("\n", "\n    ");
    }
}

