/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.ReportingV3PurchaseRefundDetailsGet200Response;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.util.mle.MLEException;
import com.cybersource.authsdk.util.mle.MLEUtility;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import utilities.tracking.SdkTracker;

public class PurchaseAndRefundDetailsApi {
    private static Logger logger = LogManager.getLogger(PurchaseAndRefundDetailsApi.class);
    private ApiClient apiClient;

    public PurchaseAndRefundDetailsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PurchaseAndRefundDetailsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getPurchaseAndRefundDetailsCall(DateTime startTime, DateTime endTime, String organizationId, String paymentSubtype, String viewBy, String groupName, Integer offset, Integer limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        boolean isMLESupportedByCybsForApi;
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)(isMLESupportedByCybsForApi = false), (String)"getPurchaseAndRefundDetails,getPurchaseAndRefundDetailsAsync,getPurchaseAndRefundDetailsWithHttpInfo,getPurchaseAndRefundDetailsCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/reporting/v3/purchase-refund-details";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (startTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "startTime", startTime));
        }
        if (endTime != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "endTime", endTime));
        }
        if (organizationId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "organizationId", organizationId));
        }
        if (paymentSubtype != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "paymentSubtype", paymentSubtype));
        }
        if (viewBy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "viewBy", viewBy));
        }
        if (groupName != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "groupName", groupName));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json", "application/xml", "text/csv"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPurchaseAndRefundDetailsValidateBeforeCall(DateTime startTime, DateTime endTime, String organizationId, String paymentSubtype, String viewBy, String groupName, Integer offset, Integer limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (startTime == null) {
            logger.error("Missing the required parameter 'startTime' when calling getPurchaseAndRefundDetails(Async)");
            throw new ApiException("Missing the required parameter 'startTime' when calling getPurchaseAndRefundDetails(Async)");
        }
        if (endTime == null) {
            logger.error("Missing the required parameter 'endTime' when calling getPurchaseAndRefundDetails(Async)");
            throw new ApiException("Missing the required parameter 'endTime' when calling getPurchaseAndRefundDetails(Async)");
        }
        Call call = this.getPurchaseAndRefundDetailsCall(startTime, endTime, organizationId, paymentSubtype, viewBy, groupName, offset, limit, progressListener, progressRequestListener);
        return call;
    }

    public ReportingV3PurchaseRefundDetailsGet200Response getPurchaseAndRefundDetails(DateTime startTime, DateTime endTime, String organizationId, String paymentSubtype, String viewBy, String groupName, Integer offset, Integer limit) throws ApiException {
        logger.info("CALL TO METHOD 'getPurchaseAndRefundDetails' STARTED");
        ApiResponse<ReportingV3PurchaseRefundDetailsGet200Response> resp = this.getPurchaseAndRefundDetailsWithHttpInfo(startTime, endTime, organizationId, paymentSubtype, viewBy, groupName, offset, limit);
        logger.info("CALL TO METHOD 'getPurchaseAndRefundDetails' ENDED");
        return resp.getData();
    }

    public ApiResponse<ReportingV3PurchaseRefundDetailsGet200Response> getPurchaseAndRefundDetailsWithHttpInfo(DateTime startTime, DateTime endTime, String organizationId, String paymentSubtype, String viewBy, String groupName, Integer offset, Integer limit) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.getPurchaseAndRefundDetailsValidateBeforeCall(startTime, endTime, organizationId, paymentSubtype, viewBy, groupName, offset, limit, null, null);
        Type localVarReturnType = new TypeToken<ReportingV3PurchaseRefundDetailsGet200Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPurchaseAndRefundDetailsAsync(DateTime startTime, DateTime endTime, String organizationId, String paymentSubtype, String viewBy, String groupName, Integer offset, Integer limit, final ApiCallback<ReportingV3PurchaseRefundDetailsGet200Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPurchaseAndRefundDetailsValidateBeforeCall(startTime, endTime, organizationId, paymentSubtype, viewBy, groupName, offset, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ReportingV3PurchaseRefundDetailsGet200Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

