/*
 * Decompiled with CFR 0.152.
 */
package Model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class PostPaymentCredentialsRequest {
    @SerializedName(value="paymentCredentialType")
    private String paymentCredentialType = null;
    @SerializedName(value="transactionType")
    private String transactionType = null;

    public PostPaymentCredentialsRequest paymentCredentialType(String paymentCredentialType) {
        this.paymentCredentialType = paymentCredentialType;
        return this;
    }

    @ApiModelProperty(value="The type of payment credentials to be returned. By default, payment credentials include network token and cryptogram or dynamic CVV. If \"NETWORK_TOKEN\" is supplied then only network token card number will be returned and no cryptogram or dynamic CVV will be requested. If \"SECURITY_CODE\" is supplied then dynamic CVV will be requested and returned with the network token card number. Dynamic CVV is only supported for Amex and SCOF. If \"CRYPTOGRAM\" is supplied then cryptogram will be requested and returned with the network token card number. Cryptogram is NOT supported for Amex.  Possible Values:   - NETWORK_TOKEN   - SECURITY_CODE   - CRYPTOGRAM ")
    public String getPaymentCredentialType() {
        return this.paymentCredentialType;
    }

    public void setPaymentCredentialType(String paymentCredentialType) {
        this.paymentCredentialType = paymentCredentialType;
    }

    public PostPaymentCredentialsRequest transactionType(String transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @ApiModelProperty(value="Specifies the type of transaction for which the network token credentials are required. Possible Values:   - ECOM: Ecommerce transaction. If transactionType is not provided, ECOM is set as the default.   - AFT: Account Funding Transaction. This is only supported for VISA and paymentCredentialType of CRYPTOGRAM. ")
    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostPaymentCredentialsRequest postPaymentCredentialsRequest = (PostPaymentCredentialsRequest)o;
        return Objects.equals(this.paymentCredentialType, postPaymentCredentialsRequest.paymentCredentialType) && Objects.equals(this.transactionType, postPaymentCredentialsRequest.transactionType);
    }

    public int hashCode() {
        return Objects.hash(this.paymentCredentialType, this.transactionType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostPaymentCredentialsRequest {\n");
        if (this.paymentCredentialType != null) {
            sb.append("    paymentCredentialType: ").append(this.toIndentedString(this.paymentCredentialType)).append("\n");
        }
        if (this.transactionType != null) {
            sb.append("    transactionType: ").append(this.toIndentedString(this.transactionType)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            // empty if block
        }
        return o.toString().replace("\n", "\n    ");
    }
}

