/*
 * Decompiled with CFR 0.152.
 */
package Model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Vasv2taxTaxInformation {
    @SerializedName(value="reportingDate")
    private String reportingDate = null;
    @SerializedName(value="dateOverrideReason")
    private String dateOverrideReason = null;
    @SerializedName(value="nexus")
    private List<String> nexus = null;
    @SerializedName(value="noNexus")
    private List<String> noNexus = null;
    @SerializedName(value="showTaxPerLineItem")
    private String showTaxPerLineItem = null;
    @SerializedName(value="commitIndicator")
    private Boolean commitIndicator = null;
    @SerializedName(value="refundIndicator")
    private Boolean refundIndicator = null;

    public Vasv2taxTaxInformation reportingDate(String reportingDate) {
        this.reportingDate = reportingDate;
        return this;
    }

    @ApiModelProperty(value="Reporting date of transaction. Format: YYYYMMDD. Defaults to current date if not specified. Optional for U.S., Canadian, international tax, and value added taxes. ")
    public String getReportingDate() {
        return this.reportingDate;
    }

    public void setReportingDate(String reportingDate) {
        this.reportingDate = reportingDate;
    }

    public Vasv2taxTaxInformation dateOverrideReason(String dateOverrideReason) {
        this.dateOverrideReason = dateOverrideReason;
        return this;
    }

    @ApiModelProperty(value="If a past or future date is specified in `orderInformation.invoiceDetails.invoiceDate`, then provide the reason for that for audit purposes. Typical reasons include: 'Return', 'Layaway', 'Imported'.  Optional for U.S., Canadian, international tax, and value added taxes. ")
    public String getDateOverrideReason() {
        return this.dateOverrideReason;
    }

    public void setDateOverrideReason(String dateOverrideReason) {
        this.dateOverrideReason = dateOverrideReason;
    }

    public Vasv2taxTaxInformation nexus(List<String> nexus) {
        this.nexus = nexus;
        return this;
    }

    public Vasv2taxTaxInformation addNexusItem(String nexusItem) {
        if (this.nexus == null) {
            this.nexus = new ArrayList<String>();
        }
        this.nexus.add(nexusItem);
        return this;
    }

    @ApiModelProperty(value="Comma-separated list of states or provinces in which merchandise is taxable. Note merchandise may be still be non-taxable or tax exempt depending on the product taxability. Indicate the type of product you are selling in the product code field for product-level taxability rules to be applied. Do not use both the `taxInformation.nexus` and `taxInformation.noNexus` fields in your request. If you do not include this field in a tax calculation service request, the tax system makes its calculations as if you have nexus in every US state or Canadian province. Use the [State, Province, and Territory Codes for the United States and Canada](https://developer.cybersource.com/library/documentation/sbc/quickref/states_and_provinces.pdf).  If you indicate you do not have nexus in the destination state, jurisdiction level fields are left blank in the Tax Detail Report.  Optional field for U.S. and Canadian taxes only. Either this field or `taxInformation.noNexus` is required if you do not have nexus in every state or province.  Not applicable for international and value added taxes. ")
    public List<String> getNexus() {
        return this.nexus;
    }

    public void setNexus(List<String> nexus) {
        this.nexus = nexus;
    }

    public Vasv2taxTaxInformation noNexus(List<String> noNexus) {
        this.noNexus = noNexus;
        return this;
    }

    public Vasv2taxTaxInformation addNoNexusItem(String noNexusItem) {
        if (this.noNexus == null) {
            this.noNexus = new ArrayList<String>();
        }
        this.noNexus.add(noNexusItem);
        return this;
    }

    @ApiModelProperty(value="Comma-separated list of states or provinces where you do not have nexus. Check with a tax advisor to determine where your business has nexus. Do not use both the `taxInformation.nexus` and `taxInformation.noNexus` fields in your request. If you do not include this field in a tax calculation service request, the tax system makes its calculations as if you have nexus in every US state or Canadian province. Use the [State, Province, and Territory Codes for the United States and Canada](https://developer.cybersource.com/library/documentation/sbc/quickref/states_and_provinces.pdf).  If you indicate you do not have nexus in the destination state, jurisdiction level fields are left blank in the Tax Detail Report.  Optional field for U.S. and Canadian taxes only. Either this field or `taxInformation.nexus` is required if you do not have nexus in every state or province.  Not applicable for international and value added taxes. ")
    public List<String> getNoNexus() {
        return this.noNexus;
    }

    public void setNoNexus(List<String> noNexus) {
        this.noNexus = noNexus;
    }

    public Vasv2taxTaxInformation showTaxPerLineItem(String showTaxPerLineItem) {
        this.showTaxPerLineItem = showTaxPerLineItem;
        return this;
    }

    @ApiModelProperty(value="Whether or not to display tax amounts for each line item. This field can contain one of the following values: - `Yes` - Display tax amounts for each line item - `No` (default) - Do not display tax amounts for each line item  Optional for U.S., Canadian, international tax, and value added taxes. ")
    public String getShowTaxPerLineItem() {
        return this.showTaxPerLineItem;
    }

    public void setShowTaxPerLineItem(String showTaxPerLineItem) {
        this.showTaxPerLineItem = showTaxPerLineItem;
    }

    public Vasv2taxTaxInformation commitIndicator(Boolean commitIndicator) {
        this.commitIndicator = commitIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicates whether this is a committed tax transaction. For a committed tax transaction, the status in the Tax Detail Report is \"Committed.\" For an uncommitted tax transaction, the status in the Tax Detail Report is \"Uncommitted.\" Possible values: - `true`: This is a committed tax transaction. - `false` (default): This is not a committed tax transaction.  A committed tax request is a tax service request that sets the status field in the Tax Detail Report to committed. The committed status indicates that the amount calculated by the tax service is included in the amount of a capture or credit.  Use a void service request to cancel a committed tax request or a committed refund tax request. The void transaction is included as a separate entry in the Tax Detail Report. The value of the status field is cancelled. The value of the link ID is the request ID of the committed tax request or refund tax request that was voided. You can use the value of the link ID to reconcile your orders.  Optional for U.S., Canadian, international tax, and value added taxes. For more information on Tax Detail Report features refer the [Tax Service Guide](https://developer.cybersource.com/docs/cybs/en-us/tax-calculation/developer/all/rest/tax-calculation/tax-overview.html). ")
    public Boolean CommitIndicator() {
        return this.commitIndicator;
    }

    public void setCommitIndicator(Boolean commitIndicator) {
        this.commitIndicator = commitIndicator;
    }

    public Vasv2taxTaxInformation refundIndicator(Boolean refundIndicator) {
        this.refundIndicator = refundIndicator;
        return this;
    }

    @ApiModelProperty(value="Indicates whether this is a refund tax transaction. For a refund tax transaction, amounts in the Tax Detail Report will be negative. Possible values: - `true`: This is a refund tax transaction. - `false` (default): This is not a refund tax transaction.  A refund tax request is a tax service request that sets the transaction type field in the Tax Detail Report to refunded and makes the reported amount negative. Tax amounts are returned as positive amounts in reply messages, but they are saved in reports as negative amounts which enables the reporting software to accurately calculate the aggregate amounts.  Optional for U.S., Canadian, international tax, and value added taxes. For more information on Tax Detail Report features refer the [Tax Service Guide](https://developer.cybersource.com/docs/cybs/en-us/tax-calculation/developer/all/rest/tax-calculation/tax-overview.html). ")
    public Boolean RefundIndicator() {
        return this.refundIndicator;
    }

    public void setRefundIndicator(Boolean refundIndicator) {
        this.refundIndicator = refundIndicator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vasv2taxTaxInformation vasv2taxTaxInformation = (Vasv2taxTaxInformation)o;
        return Objects.equals(this.reportingDate, vasv2taxTaxInformation.reportingDate) && Objects.equals(this.dateOverrideReason, vasv2taxTaxInformation.dateOverrideReason) && Objects.equals(this.nexus, vasv2taxTaxInformation.nexus) && Objects.equals(this.noNexus, vasv2taxTaxInformation.noNexus) && Objects.equals(this.showTaxPerLineItem, vasv2taxTaxInformation.showTaxPerLineItem) && Objects.equals(this.commitIndicator, vasv2taxTaxInformation.commitIndicator) && Objects.equals(this.refundIndicator, vasv2taxTaxInformation.refundIndicator);
    }

    public int hashCode() {
        return Objects.hash(this.reportingDate, this.dateOverrideReason, this.nexus, this.noNexus, this.showTaxPerLineItem, this.commitIndicator, this.refundIndicator);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Vasv2taxTaxInformation {\n");
        if (this.reportingDate != null) {
            sb.append("    reportingDate: ").append(this.toIndentedString(this.reportingDate)).append("\n");
        }
        if (this.dateOverrideReason != null) {
            sb.append("    dateOverrideReason: ").append(this.toIndentedString(this.dateOverrideReason)).append("\n");
        }
        if (this.nexus != null) {
            sb.append("    nexus: ").append(this.toIndentedString(this.nexus)).append("\n");
        }
        if (this.noNexus != null) {
            sb.append("    noNexus: ").append(this.toIndentedString(this.noNexus)).append("\n");
        }
        if (this.showTaxPerLineItem != null) {
            sb.append("    showTaxPerLineItem: ").append(this.toIndentedString(this.showTaxPerLineItem)).append("\n");
        }
        if (this.commitIndicator != null) {
            sb.append("    commitIndicator: ").append(this.toIndentedString(this.commitIndicator)).append("\n");
        }
        if (this.refundIndicator != null) {
            sb.append("    refundIndicator: ").append(this.toIndentedString(this.refundIndicator)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            // empty if block
        }
        return o.toString().replace("\n", "\n    ");
    }
}

