/*
 * Decompiled with CFR 0.152.
 */
package utilities.JWEResponse;

import com.cybersource.authsdk.core.MerchantConfig;
import com.nimbusds.jose.JOSEException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.text.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.JWEResponse.JWEException.JWEException;

public class JWEUtility {
    private static final Logger logger = LogManager.getLogger(JWEUtility.class);

    @Deprecated
    public static String decryptJWEResponse(String encodedResponse, MerchantConfig merchantConfig) throws JWEException {
        try {
            return com.cybersource.authsdk.util.JWEUtility.decryptJWEUsingPEM((MerchantConfig)merchantConfig, (String)encodedResponse);
        }
        catch (NoSuchAlgorithmException exception) {
            logger.error("NoSuchAlgorithmException: Could not able to find the required algorithm", (Throwable)exception);
            throw new JWEException("Could not able to find the required algorithm", exception);
        }
        catch (IOException exception) {
            logger.error("IOException: Could not able to load the PEM Object from PEM file");
            throw new JWEException("Could not able to load the PEM Object from PEM file", exception);
        }
        catch (ParseException exception) {
            logger.error("ParseException: Unparsable decrypted response", (Throwable)exception);
            throw new JWEException("Unparsable decrypted response", exception);
        }
        catch (Exception exception) {
            logger.error("JWE internal SDK exception", (Throwable)exception);
            throw new JWEException("Exception occurred while decrypting the response", exception);
        }
    }

    public static String decryptJWEResponse(PrivateKey privateKey, String encodedResponse) throws JWEException {
        try {
            return com.cybersource.authsdk.util.JWEUtility.decryptJWEUsingPrivateKey((PrivateKey)privateKey, (String)encodedResponse);
        }
        catch (ParseException exception) {
            logger.error("ParseException: Unparsable decrypted response", (Throwable)exception);
            throw new JWEException("Unparsable decrypted response", exception);
        }
        catch (JOSEException exception) {
            logger.error("JOSEException: Could not able to decrypt the JWE response", (Throwable)exception);
            throw new JWEException("Could not able to decrypt the JWE response", exception);
        }
        catch (Exception exception) {
            logger.error("JWE internal SDK exception", (Throwable)exception);
            throw new JWEException("Exception occurred while decrypting the response", exception);
        }
    }
}

