/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.PatchCustomerShippingAddressRequest;
import Model.PostCustomerShippingAddressRequest;
import Model.ShippingAddressListForCustomer;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.util.mle.MLEException;
import com.cybersource.authsdk.util.mle.MLEUtility;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class CustomerShippingAddressApi {
    private static Logger logger = LogManager.getLogger(CustomerShippingAddressApi.class);
    private ApiClient apiClient;

    public CustomerShippingAddressApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomerShippingAddressApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteCustomerShippingAddressCall(String customerId, String shippingAddressId, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        boolean isMLESupportedByCybsForApi;
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("DELETE".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)(isMLESupportedByCybsForApi = false), (String)"deleteCustomerShippingAddress,deleteCustomerShippingAddressAsync,deleteCustomerShippingAddressWithHttpInfo,deleteCustomerShippingAddressCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/tms/v2/customers/{customerId}/shipping-addresses/{shippingAddressId}".replaceAll("\\{customerId\\}", this.apiClient.escapeString(customerId.toString())).replaceAll("\\{shippingAddressId\\}", this.apiClient.escapeString(shippingAddressId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteCustomerShippingAddressValidateBeforeCall(String customerId, String shippingAddressId, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerId == null) {
            logger.error("Missing the required parameter 'customerId' when calling deleteCustomerShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'customerId' when calling deleteCustomerShippingAddress(Async)");
        }
        if (shippingAddressId == null) {
            logger.error("Missing the required parameter 'shippingAddressId' when calling deleteCustomerShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'shippingAddressId' when calling deleteCustomerShippingAddress(Async)");
        }
        Call call = this.deleteCustomerShippingAddressCall(customerId, shippingAddressId, profileId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteCustomerShippingAddress(String customerId, String shippingAddressId, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'deleteCustomerShippingAddress' STARTED");
        this.deleteCustomerShippingAddressWithHttpInfo(customerId, shippingAddressId, profileId);
    }

    public ApiResponse<Void> deleteCustomerShippingAddressWithHttpInfo(String customerId, String shippingAddressId, String profileId) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.deleteCustomerShippingAddressValidateBeforeCall(customerId, shippingAddressId, profileId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteCustomerShippingAddressAsync(String customerId, String shippingAddressId, String profileId, final ApiCallback<Void> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCustomerShippingAddressValidateBeforeCall(customerId, shippingAddressId, profileId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getCustomerShippingAddressCall(String customerId, String shippingAddressId, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        boolean isMLESupportedByCybsForApi;
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)(isMLESupportedByCybsForApi = false), (String)"getCustomerShippingAddress,getCustomerShippingAddressAsync,getCustomerShippingAddressWithHttpInfo,getCustomerShippingAddressCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/tms/v2/customers/{customerId}/shipping-addresses/{shippingAddressId}".replaceAll("\\{customerId\\}", this.apiClient.escapeString(customerId.toString())).replaceAll("\\{shippingAddressId\\}", this.apiClient.escapeString(shippingAddressId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomerShippingAddressValidateBeforeCall(String customerId, String shippingAddressId, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerId == null) {
            logger.error("Missing the required parameter 'customerId' when calling getCustomerShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'customerId' when calling getCustomerShippingAddress(Async)");
        }
        if (shippingAddressId == null) {
            logger.error("Missing the required parameter 'shippingAddressId' when calling getCustomerShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'shippingAddressId' when calling getCustomerShippingAddress(Async)");
        }
        Call call = this.getCustomerShippingAddressCall(customerId, shippingAddressId, profileId, progressListener, progressRequestListener);
        return call;
    }

    public PostCustomerShippingAddressRequest getCustomerShippingAddress(String customerId, String shippingAddressId, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'getCustomerShippingAddress' STARTED");
        ApiResponse<PostCustomerShippingAddressRequest> resp = this.getCustomerShippingAddressWithHttpInfo(customerId, shippingAddressId, profileId);
        logger.info("CALL TO METHOD 'getCustomerShippingAddress' ENDED");
        return resp.getData();
    }

    public ApiResponse<PostCustomerShippingAddressRequest> getCustomerShippingAddressWithHttpInfo(String customerId, String shippingAddressId, String profileId) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.getCustomerShippingAddressValidateBeforeCall(customerId, shippingAddressId, profileId, null, null);
        Type localVarReturnType = new TypeToken<PostCustomerShippingAddressRequest>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomerShippingAddressAsync(String customerId, String shippingAddressId, String profileId, final ApiCallback<PostCustomerShippingAddressRequest> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomerShippingAddressValidateBeforeCall(customerId, shippingAddressId, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PostCustomerShippingAddressRequest>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCustomerShippingAddressesListCall(String customerId, String profileId, Long offset, Long limit, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        boolean isMLESupportedByCybsForApi;
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)(isMLESupportedByCybsForApi = false), (String)"getCustomerShippingAddressesList,getCustomerShippingAddressesListAsync,getCustomerShippingAddressesListWithHttpInfo,getCustomerShippingAddressesListCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/tms/v2/customers/{customerId}/shipping-addresses".replaceAll("\\{customerId\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomerShippingAddressesListValidateBeforeCall(String customerId, String profileId, Long offset, Long limit, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerId == null) {
            logger.error("Missing the required parameter 'customerId' when calling getCustomerShippingAddressesList(Async)");
            throw new ApiException("Missing the required parameter 'customerId' when calling getCustomerShippingAddressesList(Async)");
        }
        Call call = this.getCustomerShippingAddressesListCall(customerId, profileId, offset, limit, progressListener, progressRequestListener);
        return call;
    }

    public ShippingAddressListForCustomer getCustomerShippingAddressesList(String customerId, String profileId, Long offset, Long limit) throws ApiException {
        logger.info("CALL TO METHOD 'getCustomerShippingAddressesList' STARTED");
        ApiResponse<ShippingAddressListForCustomer> resp = this.getCustomerShippingAddressesListWithHttpInfo(customerId, profileId, offset, limit);
        logger.info("CALL TO METHOD 'getCustomerShippingAddressesList' ENDED");
        return resp.getData();
    }

    public ApiResponse<ShippingAddressListForCustomer> getCustomerShippingAddressesListWithHttpInfo(String customerId, String profileId, Long offset, Long limit) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.getCustomerShippingAddressesListValidateBeforeCall(customerId, profileId, offset, limit, null, null);
        Type localVarReturnType = new TypeToken<ShippingAddressListForCustomer>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomerShippingAddressesListAsync(String customerId, String profileId, Long offset, Long limit, final ApiCallback<ShippingAddressListForCustomer> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomerShippingAddressesListValidateBeforeCall(customerId, profileId, offset, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ShippingAddressListForCustomer>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchCustomersShippingAddressCall(String customerId, String shippingAddressId, PatchCustomerShippingAddressRequest patchCustomerShippingAddressRequest, String profileId, String ifMatch, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(patchCustomerShippingAddressRequest, PatchCustomerShippingAddressRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        boolean isMLESupportedByCybsForApi = false;
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)isMLESupportedByCybsForApi, (String)"patchCustomersShippingAddress,patchCustomersShippingAddressAsync,patchCustomersShippingAddressWithHttpInfo,patchCustomersShippingAddressCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/tms/v2/customers/{customerId}/shipping-addresses/{shippingAddressId}".replaceAll("\\{customerId\\}", this.apiClient.escapeString(customerId.toString())).replaceAll("\\{shippingAddressId\\}", this.apiClient.escapeString(shippingAddressId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        if (ifMatch != null) {
            localVarHeaderParams.put("if-match", this.apiClient.parameterToString(ifMatch));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchCustomersShippingAddressValidateBeforeCall(String customerId, String shippingAddressId, PatchCustomerShippingAddressRequest patchCustomerShippingAddressRequest, String profileId, String ifMatch, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerId == null) {
            logger.error("Missing the required parameter 'customerId' when calling patchCustomersShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'customerId' when calling patchCustomersShippingAddress(Async)");
        }
        if (shippingAddressId == null) {
            logger.error("Missing the required parameter 'shippingAddressId' when calling patchCustomersShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'shippingAddressId' when calling patchCustomersShippingAddress(Async)");
        }
        if (patchCustomerShippingAddressRequest == null) {
            logger.error("Missing the required parameter 'patchCustomerShippingAddressRequest' when calling patchCustomersShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'patchCustomerShippingAddressRequest' when calling patchCustomersShippingAddress(Async)");
        }
        Call call = this.patchCustomersShippingAddressCall(customerId, shippingAddressId, patchCustomerShippingAddressRequest, profileId, ifMatch, progressListener, progressRequestListener);
        return call;
    }

    public PatchCustomerShippingAddressRequest patchCustomersShippingAddress(String customerId, String shippingAddressId, PatchCustomerShippingAddressRequest patchCustomerShippingAddressRequest, String profileId, String ifMatch) throws ApiException {
        logger.info("CALL TO METHOD 'patchCustomersShippingAddress' STARTED");
        ApiResponse<PatchCustomerShippingAddressRequest> resp = this.patchCustomersShippingAddressWithHttpInfo(customerId, shippingAddressId, patchCustomerShippingAddressRequest, profileId, ifMatch);
        logger.info("CALL TO METHOD 'patchCustomersShippingAddress' ENDED");
        return resp.getData();
    }

    public ApiResponse<PatchCustomerShippingAddressRequest> patchCustomersShippingAddressWithHttpInfo(String customerId, String shippingAddressId, PatchCustomerShippingAddressRequest patchCustomerShippingAddressRequest, String profileId, String ifMatch) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.patchCustomersShippingAddressValidateBeforeCall(customerId, shippingAddressId, patchCustomerShippingAddressRequest, profileId, ifMatch, null, null);
        Type localVarReturnType = new TypeToken<PatchCustomerShippingAddressRequest>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchCustomersShippingAddressAsync(String customerId, String shippingAddressId, PatchCustomerShippingAddressRequest patchCustomerShippingAddressRequest, String profileId, String ifMatch, final ApiCallback<PatchCustomerShippingAddressRequest> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchCustomersShippingAddressValidateBeforeCall(customerId, shippingAddressId, patchCustomerShippingAddressRequest, profileId, ifMatch, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PatchCustomerShippingAddressRequest>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postCustomerShippingAddressCall(String customerId, PostCustomerShippingAddressRequest postCustomerShippingAddressRequest, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(postCustomerShippingAddressRequest, PostCustomerShippingAddressRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        boolean isMLESupportedByCybsForApi = false;
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)isMLESupportedByCybsForApi, (String)"postCustomerShippingAddress,postCustomerShippingAddressAsync,postCustomerShippingAddressWithHttpInfo,postCustomerShippingAddressCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/tms/v2/customers/{customerId}/shipping-addresses".replaceAll("\\{customerId\\}", this.apiClient.escapeString(customerId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postCustomerShippingAddressValidateBeforeCall(String customerId, PostCustomerShippingAddressRequest postCustomerShippingAddressRequest, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customerId == null) {
            logger.error("Missing the required parameter 'customerId' when calling postCustomerShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'customerId' when calling postCustomerShippingAddress(Async)");
        }
        if (postCustomerShippingAddressRequest == null) {
            logger.error("Missing the required parameter 'postCustomerShippingAddressRequest' when calling postCustomerShippingAddress(Async)");
            throw new ApiException("Missing the required parameter 'postCustomerShippingAddressRequest' when calling postCustomerShippingAddress(Async)");
        }
        Call call = this.postCustomerShippingAddressCall(customerId, postCustomerShippingAddressRequest, profileId, progressListener, progressRequestListener);
        return call;
    }

    public PostCustomerShippingAddressRequest postCustomerShippingAddress(String customerId, PostCustomerShippingAddressRequest postCustomerShippingAddressRequest, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'postCustomerShippingAddress' STARTED");
        ApiResponse<PostCustomerShippingAddressRequest> resp = this.postCustomerShippingAddressWithHttpInfo(customerId, postCustomerShippingAddressRequest, profileId);
        logger.info("CALL TO METHOD 'postCustomerShippingAddress' ENDED");
        return resp.getData();
    }

    public ApiResponse<PostCustomerShippingAddressRequest> postCustomerShippingAddressWithHttpInfo(String customerId, PostCustomerShippingAddressRequest postCustomerShippingAddressRequest, String profileId) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.postCustomerShippingAddressValidateBeforeCall(customerId, postCustomerShippingAddressRequest, profileId, null, null);
        Type localVarReturnType = new TypeToken<PostCustomerShippingAddressRequest>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postCustomerShippingAddressAsync(String customerId, PostCustomerShippingAddressRequest postCustomerShippingAddressRequest, String profileId, final ApiCallback<PostCustomerShippingAddressRequest> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postCustomerShippingAddressValidateBeforeCall(customerId, postCustomerShippingAddressRequest, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PostCustomerShippingAddressRequest>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

