/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.DeAssociationRequestBody;
import Model.DeviceDeAssociateV3Request;
import Model.InlineResponse2006;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.util.mle.MLEException;
import com.cybersource.authsdk.util.mle.MLEUtility;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class DeviceDeAssociationApi {
    private static Logger logger = LogManager.getLogger(DeviceDeAssociationApi.class);
    private ApiClient apiClient;

    public DeviceDeAssociationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DeviceDeAssociationApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteTerminalAssociationCall(DeAssociationRequestBody deAssociationRequestBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(deAssociationRequestBody, DeAssociationRequestBody.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        boolean isMLESupportedByCybsForApi = false;
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)isMLESupportedByCybsForApi, (String)"deleteTerminalAssociation,deleteTerminalAssociationAsync,deleteTerminalAssociationWithHttpInfo,deleteTerminalAssociationCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/dms/v2/devices/deassociate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTerminalAssociationValidateBeforeCall(DeAssociationRequestBody deAssociationRequestBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (deAssociationRequestBody == null) {
            logger.error("Missing the required parameter 'deAssociationRequestBody' when calling deleteTerminalAssociation(Async)");
            throw new ApiException("Missing the required parameter 'deAssociationRequestBody' when calling deleteTerminalAssociation(Async)");
        }
        Call call = this.deleteTerminalAssociationCall(deAssociationRequestBody, progressListener, progressRequestListener);
        return call;
    }

    public void deleteTerminalAssociation(DeAssociationRequestBody deAssociationRequestBody) throws ApiException {
        logger.info("CALL TO METHOD 'deleteTerminalAssociation' STARTED");
        this.deleteTerminalAssociationWithHttpInfo(deAssociationRequestBody);
    }

    public ApiResponse<Void> deleteTerminalAssociationWithHttpInfo(DeAssociationRequestBody deAssociationRequestBody) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.deleteTerminalAssociationValidateBeforeCall(deAssociationRequestBody, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteTerminalAssociationAsync(DeAssociationRequestBody deAssociationRequestBody, final ApiCallback<Void> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTerminalAssociationValidateBeforeCall(deAssociationRequestBody, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call postDeAssociateV3TerminalCall(List<DeviceDeAssociateV3Request> deviceDeAssociateV3Request, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(deviceDeAssociateV3Request, DeviceDeAssociateV3Request.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        boolean isMLESupportedByCybsForApi = false;
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)isMLESupportedByCybsForApi, (String)"postDeAssociateV3Terminal,postDeAssociateV3TerminalAsync,postDeAssociateV3TerminalWithHttpInfo,postDeAssociateV3TerminalCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/dms/v3/devices/deassociate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postDeAssociateV3TerminalValidateBeforeCall(List<DeviceDeAssociateV3Request> deviceDeAssociateV3Request, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (deviceDeAssociateV3Request == null) {
            logger.error("Missing the required parameter 'deviceDeAssociateV3Request' when calling postDeAssociateV3Terminal(Async)");
            throw new ApiException("Missing the required parameter 'deviceDeAssociateV3Request' when calling postDeAssociateV3Terminal(Async)");
        }
        Call call = this.postDeAssociateV3TerminalCall(deviceDeAssociateV3Request, progressListener, progressRequestListener);
        return call;
    }

    public List<InlineResponse2006> postDeAssociateV3Terminal(List<DeviceDeAssociateV3Request> deviceDeAssociateV3Request) throws ApiException {
        logger.info("CALL TO METHOD 'postDeAssociateV3Terminal' STARTED");
        ApiResponse<List<InlineResponse2006>> resp = this.postDeAssociateV3TerminalWithHttpInfo(deviceDeAssociateV3Request);
        logger.info("CALL TO METHOD 'postDeAssociateV3Terminal' ENDED");
        return resp.getData();
    }

    public ApiResponse<List<InlineResponse2006>> postDeAssociateV3TerminalWithHttpInfo(List<DeviceDeAssociateV3Request> deviceDeAssociateV3Request) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.postDeAssociateV3TerminalValidateBeforeCall(deviceDeAssociateV3Request, null, null);
        Type localVarReturnType = new TypeToken<List<InlineResponse2006>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postDeAssociateV3TerminalAsync(List<DeviceDeAssociateV3Request> deviceDeAssociateV3Request, final ApiCallback<List<InlineResponse2006>> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postDeAssociateV3TerminalValidateBeforeCall(deviceDeAssociateV3Request, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<InlineResponse2006>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

