/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.InlineResponse2005;
import Model.InlineResponse2007;
import Model.PostDeviceSearchRequest;
import Model.PostDeviceSearchRequestV3;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.util.mle.MLEException;
import com.cybersource.authsdk.util.mle.MLEUtility;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class DeviceSearchApi {
    private static Logger logger = LogManager.getLogger(DeviceSearchApi.class);
    private ApiClient apiClient;

    public DeviceSearchApi() {
        this(Configuration.getDefaultApiClient());
    }

    public DeviceSearchApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call postSearchQueryCall(PostDeviceSearchRequest postDeviceSearchRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(postDeviceSearchRequest, PostDeviceSearchRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        boolean isMLESupportedByCybsForApi = false;
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)isMLESupportedByCybsForApi, (String)"postSearchQuery,postSearchQueryAsync,postSearchQueryWithHttpInfo,postSearchQueryCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/dms/v2/devices/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postSearchQueryValidateBeforeCall(PostDeviceSearchRequest postDeviceSearchRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (postDeviceSearchRequest == null) {
            logger.error("Missing the required parameter 'postDeviceSearchRequest' when calling postSearchQuery(Async)");
            throw new ApiException("Missing the required parameter 'postDeviceSearchRequest' when calling postSearchQuery(Async)");
        }
        Call call = this.postSearchQueryCall(postDeviceSearchRequest, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse2005 postSearchQuery(PostDeviceSearchRequest postDeviceSearchRequest) throws ApiException {
        logger.info("CALL TO METHOD 'postSearchQuery' STARTED");
        ApiResponse<InlineResponse2005> resp = this.postSearchQueryWithHttpInfo(postDeviceSearchRequest);
        logger.info("CALL TO METHOD 'postSearchQuery' ENDED");
        return resp.getData();
    }

    public ApiResponse<InlineResponse2005> postSearchQueryWithHttpInfo(PostDeviceSearchRequest postDeviceSearchRequest) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.postSearchQueryValidateBeforeCall(postDeviceSearchRequest, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2005>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postSearchQueryAsync(PostDeviceSearchRequest postDeviceSearchRequest, final ApiCallback<InlineResponse2005> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postSearchQueryValidateBeforeCall(postDeviceSearchRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2005>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postSearchQueryV3Call(PostDeviceSearchRequestV3 postDeviceSearchRequestV3, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(postDeviceSearchRequestV3, PostDeviceSearchRequestV3.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        boolean isMLESupportedByCybsForApi = false;
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)isMLESupportedByCybsForApi, (String)"postSearchQueryV3,postSearchQueryV3Async,postSearchQueryV3WithHttpInfo,postSearchQueryV3Call")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/dms/v3/devices/search";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=UTF-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=UTF-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postSearchQueryV3ValidateBeforeCall(PostDeviceSearchRequestV3 postDeviceSearchRequestV3, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (postDeviceSearchRequestV3 == null) {
            logger.error("Missing the required parameter 'postDeviceSearchRequestV3' when calling postSearchQueryV3(Async)");
            throw new ApiException("Missing the required parameter 'postDeviceSearchRequestV3' when calling postSearchQueryV3(Async)");
        }
        Call call = this.postSearchQueryV3Call(postDeviceSearchRequestV3, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse2007 postSearchQueryV3(PostDeviceSearchRequestV3 postDeviceSearchRequestV3) throws ApiException {
        logger.info("CALL TO METHOD 'postSearchQueryV3' STARTED");
        ApiResponse<InlineResponse2007> resp = this.postSearchQueryV3WithHttpInfo(postDeviceSearchRequestV3);
        logger.info("CALL TO METHOD 'postSearchQueryV3' ENDED");
        return resp.getData();
    }

    public ApiResponse<InlineResponse2007> postSearchQueryV3WithHttpInfo(PostDeviceSearchRequestV3 postDeviceSearchRequestV3) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.postSearchQueryV3ValidateBeforeCall(postDeviceSearchRequestV3, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2007>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postSearchQueryV3Async(PostDeviceSearchRequestV3 postDeviceSearchRequestV3, final ApiCallback<InlineResponse2007> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postSearchQueryV3ValidateBeforeCall(postDeviceSearchRequestV3, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2007>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

