/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.CreateOrderRequest;
import Model.PtsV2CreateOrderPost201Response;
import Model.PtsV2UpdateOrderPatch201Response;
import Model.UpdateOrderRequest;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.util.mle.MLEException;
import com.cybersource.authsdk.util.mle.MLEUtility;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class OrdersApi {
    private static Logger logger = LogManager.getLogger(OrdersApi.class);
    private ApiClient apiClient;

    public OrdersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrdersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createOrderCall(CreateOrderRequest createOrderRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(createOrderRequest, CreateOrderRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        boolean isMLESupportedByCybsForApi = false;
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)isMLESupportedByCybsForApi, (String)"createOrder,createOrderAsync,createOrderWithHttpInfo,createOrderCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/pts/v2/intents";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createOrderValidateBeforeCall(CreateOrderRequest createOrderRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (createOrderRequest == null) {
            logger.error("Missing the required parameter 'createOrderRequest' when calling createOrder(Async)");
            throw new ApiException("Missing the required parameter 'createOrderRequest' when calling createOrder(Async)");
        }
        Call call = this.createOrderCall(createOrderRequest, progressListener, progressRequestListener);
        return call;
    }

    public PtsV2CreateOrderPost201Response createOrder(CreateOrderRequest createOrderRequest) throws ApiException {
        logger.info("CALL TO METHOD 'createOrder' STARTED");
        ApiResponse<PtsV2CreateOrderPost201Response> resp = this.createOrderWithHttpInfo(createOrderRequest);
        logger.info("CALL TO METHOD 'createOrder' ENDED");
        return resp.getData();
    }

    public ApiResponse<PtsV2CreateOrderPost201Response> createOrderWithHttpInfo(CreateOrderRequest createOrderRequest) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.createOrderValidateBeforeCall(createOrderRequest, null, null);
        Type localVarReturnType = new TypeToken<PtsV2CreateOrderPost201Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createOrderAsync(CreateOrderRequest createOrderRequest, final ApiCallback<PtsV2CreateOrderPost201Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createOrderValidateBeforeCall(createOrderRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PtsV2CreateOrderPost201Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateOrderCall(String id, UpdateOrderRequest updateOrderRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(updateOrderRequest, UpdateOrderRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        boolean isMLESupportedByCybsForApi = false;
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)isMLESupportedByCybsForApi, (String)"updateOrder,updateOrderAsync,updateOrderWithHttpInfo,updateOrderCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/pts/v2/intents/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateOrderValidateBeforeCall(String id, UpdateOrderRequest updateOrderRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            logger.error("Missing the required parameter 'id' when calling updateOrder(Async)");
            throw new ApiException("Missing the required parameter 'id' when calling updateOrder(Async)");
        }
        if (updateOrderRequest == null) {
            logger.error("Missing the required parameter 'updateOrderRequest' when calling updateOrder(Async)");
            throw new ApiException("Missing the required parameter 'updateOrderRequest' when calling updateOrder(Async)");
        }
        Call call = this.updateOrderCall(id, updateOrderRequest, progressListener, progressRequestListener);
        return call;
    }

    public PtsV2UpdateOrderPatch201Response updateOrder(String id, UpdateOrderRequest updateOrderRequest) throws ApiException {
        logger.info("CALL TO METHOD 'updateOrder' STARTED");
        ApiResponse<PtsV2UpdateOrderPatch201Response> resp = this.updateOrderWithHttpInfo(id, updateOrderRequest);
        logger.info("CALL TO METHOD 'updateOrder' ENDED");
        return resp.getData();
    }

    public ApiResponse<PtsV2UpdateOrderPatch201Response> updateOrderWithHttpInfo(String id, UpdateOrderRequest updateOrderRequest) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.updateOrderValidateBeforeCall(id, updateOrderRequest, null, null);
        Type localVarReturnType = new TypeToken<PtsV2UpdateOrderPatch201Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateOrderAsync(String id, UpdateOrderRequest updateOrderRequest, final ApiCallback<PtsV2UpdateOrderPatch201Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateOrderValidateBeforeCall(id, updateOrderRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PtsV2UpdateOrderPatch201Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

