/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.CreatePaymentLinkRequest;
import Model.PblPaymentLinksAllGet200Response;
import Model.PblPaymentLinksGet200Response;
import Model.PblPaymentLinksPost201Response;
import Model.UpdatePaymentLinkRequest;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.util.mle.MLEException;
import com.cybersource.authsdk.util.mle.MLEUtility;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class PaymentLinksApi {
    private static Logger logger = LogManager.getLogger(PaymentLinksApi.class);
    private ApiClient apiClient;

    public PaymentLinksApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PaymentLinksApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createPaymentLinkCall(CreatePaymentLinkRequest createPaymentLinkRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(createPaymentLinkRequest, CreatePaymentLinkRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        boolean isMLESupportedByCybsForApi = false;
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)isMLESupportedByCybsForApi, (String)"createPaymentLink,createPaymentLinkAsync,createPaymentLinkWithHttpInfo,createPaymentLinkCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/ipl/v2/payment-links";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/hal+json", "application/json;charset=utf-8", "application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createPaymentLinkValidateBeforeCall(CreatePaymentLinkRequest createPaymentLinkRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (createPaymentLinkRequest == null) {
            logger.error("Missing the required parameter 'createPaymentLinkRequest' when calling createPaymentLink(Async)");
            throw new ApiException("Missing the required parameter 'createPaymentLinkRequest' when calling createPaymentLink(Async)");
        }
        Call call = this.createPaymentLinkCall(createPaymentLinkRequest, progressListener, progressRequestListener);
        return call;
    }

    public PblPaymentLinksPost201Response createPaymentLink(CreatePaymentLinkRequest createPaymentLinkRequest) throws ApiException {
        logger.info("CALL TO METHOD 'createPaymentLink' STARTED");
        ApiResponse<PblPaymentLinksPost201Response> resp = this.createPaymentLinkWithHttpInfo(createPaymentLinkRequest);
        logger.info("CALL TO METHOD 'createPaymentLink' ENDED");
        return resp.getData();
    }

    public ApiResponse<PblPaymentLinksPost201Response> createPaymentLinkWithHttpInfo(CreatePaymentLinkRequest createPaymentLinkRequest) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.createPaymentLinkValidateBeforeCall(createPaymentLinkRequest, null, null);
        Type localVarReturnType = new TypeToken<PblPaymentLinksPost201Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createPaymentLinkAsync(CreatePaymentLinkRequest createPaymentLinkRequest, final ApiCallback<PblPaymentLinksPost201Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createPaymentLinkValidateBeforeCall(createPaymentLinkRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PblPaymentLinksPost201Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAllPaymentLinksCall(Integer offset, Integer limit, String status, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        boolean isMLESupportedByCybsForApi;
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)(isMLESupportedByCybsForApi = false), (String)"getAllPaymentLinks,getAllPaymentLinksAsync,getAllPaymentLinksWithHttpInfo,getAllPaymentLinksCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/ipl/v2/payment-links";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "offset", offset));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "limit", limit));
        }
        if (status != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPairs("", "status", status));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/hal+json", "application/json;charset=utf-8", "application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllPaymentLinksValidateBeforeCall(Integer offset, Integer limit, String status, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (offset == null) {
            logger.error("Missing the required parameter 'offset' when calling getAllPaymentLinks(Async)");
            throw new ApiException("Missing the required parameter 'offset' when calling getAllPaymentLinks(Async)");
        }
        if (limit == null) {
            logger.error("Missing the required parameter 'limit' when calling getAllPaymentLinks(Async)");
            throw new ApiException("Missing the required parameter 'limit' when calling getAllPaymentLinks(Async)");
        }
        Call call = this.getAllPaymentLinksCall(offset, limit, status, progressListener, progressRequestListener);
        return call;
    }

    public PblPaymentLinksAllGet200Response getAllPaymentLinks(Integer offset, Integer limit, String status) throws ApiException {
        logger.info("CALL TO METHOD 'getAllPaymentLinks' STARTED");
        ApiResponse<PblPaymentLinksAllGet200Response> resp = this.getAllPaymentLinksWithHttpInfo(offset, limit, status);
        logger.info("CALL TO METHOD 'getAllPaymentLinks' ENDED");
        return resp.getData();
    }

    public ApiResponse<PblPaymentLinksAllGet200Response> getAllPaymentLinksWithHttpInfo(Integer offset, Integer limit, String status) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.getAllPaymentLinksValidateBeforeCall(offset, limit, status, null, null);
        Type localVarReturnType = new TypeToken<PblPaymentLinksAllGet200Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllPaymentLinksAsync(Integer offset, Integer limit, String status, final ApiCallback<PblPaymentLinksAllGet200Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllPaymentLinksValidateBeforeCall(offset, limit, status, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PblPaymentLinksAllGet200Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getPaymentLinkCall(String id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        boolean isMLESupportedByCybsForApi;
        SdkTracker sdkTracker = new SdkTracker();
        String localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)(isMLESupportedByCybsForApi = false), (String)"getPaymentLink,getPaymentLinkAsync,getPaymentLinkWithHttpInfo,getPaymentLinkCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/ipl/v2/payment-links/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/hal+json", "application/json;charset=utf-8", "application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getPaymentLinkValidateBeforeCall(String id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            logger.error("Missing the required parameter 'id' when calling getPaymentLink(Async)");
            throw new ApiException("Missing the required parameter 'id' when calling getPaymentLink(Async)");
        }
        Call call = this.getPaymentLinkCall(id, progressListener, progressRequestListener);
        return call;
    }

    public PblPaymentLinksGet200Response getPaymentLink(String id) throws ApiException {
        logger.info("CALL TO METHOD 'getPaymentLink' STARTED");
        ApiResponse<PblPaymentLinksGet200Response> resp = this.getPaymentLinkWithHttpInfo(id);
        logger.info("CALL TO METHOD 'getPaymentLink' ENDED");
        return resp.getData();
    }

    public ApiResponse<PblPaymentLinksGet200Response> getPaymentLinkWithHttpInfo(String id) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.getPaymentLinkValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<PblPaymentLinksGet200Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getPaymentLinkAsync(String id, final ApiCallback<PblPaymentLinksGet200Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getPaymentLinkValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PblPaymentLinksGet200Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updatePaymentLinkCall(String id, UpdatePaymentLinkRequest updatePaymentLinkRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(updatePaymentLinkRequest, UpdatePaymentLinkRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        boolean isMLESupportedByCybsForApi = false;
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (boolean)isMLESupportedByCybsForApi, (String)"updatePaymentLink,updatePaymentLinkAsync,updatePaymentLinkWithHttpInfo,updatePaymentLinkCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/ipl/v2/payment-links/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/hal+json", "application/json;charset=utf-8", "application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updatePaymentLinkValidateBeforeCall(String id, UpdatePaymentLinkRequest updatePaymentLinkRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            logger.error("Missing the required parameter 'id' when calling updatePaymentLink(Async)");
            throw new ApiException("Missing the required parameter 'id' when calling updatePaymentLink(Async)");
        }
        if (updatePaymentLinkRequest == null) {
            logger.error("Missing the required parameter 'updatePaymentLinkRequest' when calling updatePaymentLink(Async)");
            throw new ApiException("Missing the required parameter 'updatePaymentLinkRequest' when calling updatePaymentLink(Async)");
        }
        Call call = this.updatePaymentLinkCall(id, updatePaymentLinkRequest, progressListener, progressRequestListener);
        return call;
    }

    public PblPaymentLinksPost201Response updatePaymentLink(String id, UpdatePaymentLinkRequest updatePaymentLinkRequest) throws ApiException {
        logger.info("CALL TO METHOD 'updatePaymentLink' STARTED");
        ApiResponse<PblPaymentLinksPost201Response> resp = this.updatePaymentLinkWithHttpInfo(id, updatePaymentLinkRequest);
        logger.info("CALL TO METHOD 'updatePaymentLink' ENDED");
        return resp.getData();
    }

    public ApiResponse<PblPaymentLinksPost201Response> updatePaymentLinkWithHttpInfo(String id, UpdatePaymentLinkRequest updatePaymentLinkRequest) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.updatePaymentLinkValidateBeforeCall(id, updatePaymentLinkRequest, null, null);
        Type localVarReturnType = new TypeToken<PblPaymentLinksPost201Response>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updatePaymentLinkAsync(String id, UpdatePaymentLinkRequest updatePaymentLinkRequest, final ApiCallback<PblPaymentLinksPost201Response> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updatePaymentLinkValidateBeforeCall(id, updatePaymentLinkRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<PblPaymentLinksPost201Response>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

