/*
 * Decompiled with CFR 0.152.
 */
package utilities.pgpBatchUpload;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;

public class BatchUploadUtility {
    private static final Logger logger = LogManager.getLogger(BatchUploadUtility.class);
    private static final long MAX_FILE_SIZE_BYTES = 0x4B00000L;

    public static Collection<X509Certificate> loadCertificatesFromPemFile(String certFilePath) throws CertificateException, IOException {
        try (FileInputStream inStream = new FileInputStream(certFilePath);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certs = cf.generateCertificates(inStream);
            ArrayList<X509Certificate> x509Certs = new ArrayList<X509Certificate>();
            for (Certificate certificate : certs) {
                x509Certs.add((X509Certificate)certificate);
            }
            ArrayList<X509Certificate> arrayList = x509Certs;
            return arrayList;
        }
    }

    public static PGPPublicKey readPGPPublicKey(String filePath) throws IOException, PGPException {
        BatchUploadUtility.validatePathAndFile(filePath, "pgp public key path");
        logger.debug("Reading pgp public key from file: {}", (Object)filePath);
        try (BufferedInputStream keyIn = new BufferedInputStream(new FileInputStream(filePath));){
            PGPPublicKeyRingCollection pgpPub = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)keyIn), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            Iterator keyRingIter = pgpPub.getKeyRings();
            while (keyRingIter.hasNext()) {
                PGPPublicKeyRing keyRing = (PGPPublicKeyRing)keyRingIter.next();
                Iterator keyIter = keyRing.getPublicKeys();
                while (keyIter.hasNext()) {
                    PGPPublicKey key = (PGPPublicKey)keyIter.next();
                    if (!key.isEncryptionKey()) continue;
                    PGPPublicKey pGPPublicKey = key;
                    return pGPPublicKey;
                }
            }
        }
        throw new PGPException("No encryption key found in the provided key ring: " + filePath);
    }

    public static String getEndpointUrl(String environmentHostname, String endpoint) {
        String baseUrl = environmentHostname.startsWith("https://") ? environmentHostname.trim() : "https://" + environmentHostname.trim();
        return baseUrl + endpoint;
    }

    public static void validateBatchApiJKSInputs(File inputFile, String environmentHostname, String pgpEncryptionCertPath, String keystorePath, String truststorePath) throws Exception {
        BatchUploadUtility.validateInputFile(inputFile);
        if (StringUtils.isEmpty((CharSequence)environmentHostname)) {
            logger.error("Environment Host Name for Batch Upload API cannot be null or empty.");
            throw new IllegalArgumentException("Environment Host Name for Batch Upload API cannot be null or empty.");
        }
        BatchUploadUtility.validatePathAndFile(pgpEncryptionCertPath, "PGP Encryption Cert Path");
        BatchUploadUtility.validatePathAndFile(keystorePath, "Keystore Path");
        if (!StringUtils.isEmpty((CharSequence)truststorePath)) {
            BatchUploadUtility.validatePathAndFile(truststorePath, "Truststore Path");
        }
    }

    public static void validateBatchApiP12Inputs(File inputFile, String environmentHostname, String pgpEncryptionCertPath, String clientCertP12FilePath, String serverTrustCertPath) throws Exception {
        BatchUploadUtility.validateInputFile(inputFile);
        if (StringUtils.isEmpty((CharSequence)environmentHostname)) {
            logger.error("Environment Host Name for Batch Upload API cannot be null or empty.");
            throw new IllegalArgumentException("Environment Host Name for Batch Upload API cannot be null or empty.");
        }
        BatchUploadUtility.validatePathAndFile(pgpEncryptionCertPath, "PGP Encryption Cert Path");
        BatchUploadUtility.validatePathAndFile(clientCertP12FilePath, "Client Cert P12 File Path");
        if (!StringUtils.isEmpty((CharSequence)serverTrustCertPath)) {
            BatchUploadUtility.validatePathAndFile(serverTrustCertPath, "Server Trust Cert Path");
        }
    }

    public static void validateBatchApiKeysInputs(File inputFile, String environmentHostname, PGPPublicKey pgpPublicKey, PrivateKey clientPrivateKey, X509Certificate clientCert, Collection<X509Certificate> serverTrustCert) throws Exception {
        BatchUploadUtility.validateInputFile(inputFile);
        if (StringUtils.isEmpty((CharSequence)environmentHostname)) {
            logger.error("Environment Host Name for Batch Upload API cannot be null or empty.");
            throw new IllegalArgumentException("Environment Host Name for Batch Upload API cannot be null or empty.");
        }
        if (pgpPublicKey == null) {
            throw new IllegalArgumentException("PGP Public Key is null");
        }
        if (clientPrivateKey == null) {
            throw new IllegalArgumentException("Client Private Key is null");
        }
        if (clientCert == null) {
            throw new IllegalArgumentException("Client Certificate is null");
        }
    }

    private static void validateInputFile(File inputFile) {
        if (inputFile == null || !inputFile.exists() || !inputFile.isFile()) {
            logger.error("Input file is invalid or does not exist: " + (inputFile != null ? inputFile : "null"));
            throw new IllegalArgumentException("Input file is invalid or does not exist: " + inputFile);
        }
        if (!inputFile.getName().toLowerCase().endsWith(".csv")) {
            logger.error("Only CSV file type is allowed: " + inputFile.getName());
            throw new IllegalArgumentException("Only CSV file type is allowed: " + inputFile.getName());
        }
        if (inputFile.length() > 0x4B00000L) {
            logger.error("Input file size exceeds the maximum allowed size of 75MB: " + inputFile.length() + " fileName=" + inputFile.getName());
            throw new IllegalArgumentException("Input file size exceeds the maximum allowed size of 75MB: " + inputFile.length());
        }
    }

    private static void validatePathAndFile(String filePath, String pathType) throws IOException {
        Path path;
        if (filePath == null || filePath.trim().isEmpty()) {
            logger.error(pathType + " path cannot be null or empty");
            throw new IllegalArgumentException(pathType + " path cannot be null or empty");
        }
        String normalizedPath = filePath;
        if (File.separatorChar == '\\' && normalizedPath.matches("^/[A-Za-z]:.*")) {
            normalizedPath = normalizedPath.substring(1);
        }
        if (!Files.exists(path = Paths.get(normalizedPath, new String[0]), new LinkOption[0])) {
            logger.error(pathType + " does not exist: " + path);
            throw new IOException(pathType + " does not exist: " + path);
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            logger.error(pathType + " does not have valid file: " + path);
            throw new IOException(pathType + " does not have valid file: " + path);
        }
        if (!Files.isReadable(path)) {
            logger.error(pathType + " is not readable: " + path);
            throw new IOException(pathType + " is not readable: " + path);
        }
    }
}

