/*
 * Decompiled with CFR 0.152.
 */
package utilities.pgpBatchUpload;

import Invokers.ApiException;
import Invokers.ApiResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import utilities.pgpBatchUpload.BatchUploadUtility;

public class MutualAuthUploadUtility {
    private static final Logger logger = LogManager.getLogger(MutualAuthUploadUtility.class);
    private static boolean disableSslVerification = false;

    public static ApiResponse<String> handleUploadOperationWithJKS(byte[] encryptedPgpBytes, String endpointUrl, String fileName, String keystorePath, char[] keystorePassword, String truststorePath, char[] truststorePassword) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, KeyManagementException, UnrecoverableKeyException {
        KeyStore clientKeyStore = KeyStore.getInstance("JKS");
        KeyStore serverTrustStore = null;
        try (FileInputStream keyStoreFile = new FileInputStream(keystorePath);){
            clientKeyStore.load(keyStoreFile, keystorePassword);
        }
        if (!StringUtils.isEmpty((CharSequence)truststorePath)) {
            serverTrustStore = KeyStore.getInstance("JKS");
            var10_11 = null;
            try (FileInputStream trustStoreFile = new FileInputStream(truststorePath);){
                serverTrustStore.load(trustStoreFile, truststorePassword);
            }
            catch (Throwable throwable) {
                var10_11 = throwable;
                throw throwable;
            }
        }
        try {
            OkHttpClient client = MutualAuthUploadUtility.getOkHttpClientForMutualAuth(clientKeyStore, serverTrustStore, keystorePassword);
            return MutualAuthUploadUtility.uploadFile(encryptedPgpBytes, fileName, endpointUrl, client);
        }
        catch (Exception e) {
            logger.error("Error during mutual auth upload operation", (Throwable)e);
            throw new IOException("Failed to perform upload operation with JKS", e);
        }
    }

    public static ApiResponse<String> handleUploadOperationUsingP12orPfx(byte[] encryptedPgpBytes, String endpointUrl, String fileName, String p12FilePath, char[] p12FilePassword, String serverTrustCertPath) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, KeyManagementException, UnrecoverableKeyException {
        KeyStore serverTrustStore = null;
        if (!StringUtils.isEmpty((CharSequence)serverTrustCertPath)) {
            Collection<X509Certificate> serverTrustCert;
            try {
                serverTrustCert = BatchUploadUtility.loadCertificatesFromPemFile(serverTrustCertPath);
            }
            catch (CertificateException e) {
                logger.error("Error loading certificate from PEM file", (Throwable)e);
                throw new CertificateException("Failed to load certificate from PEM file: " + serverTrustCertPath, e);
            }
            serverTrustStore = KeyStore.getInstance("JKS");
            serverTrustStore.load(null, null);
            int i = 0;
            for (X509Certificate cert : serverTrustCert) {
                serverTrustStore.setCertificateEntry("server-" + i, cert);
                ++i;
            }
        }
        KeyStore clientKeyStore = KeyStore.getInstance("PKCS12", (Provider)new BouncyCastleProvider());
        FileInputStream file = new FileInputStream(new File(p12FilePath));
        Object object = null;
        try {
            clientKeyStore.load(file, p12FilePassword);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (file != null) {
                if (object != null) {
                    try {
                        file.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    file.close();
                }
            }
        }
        try {
            OkHttpClient client = MutualAuthUploadUtility.getOkHttpClientForMutualAuth(clientKeyStore, serverTrustStore, p12FilePassword);
            return MutualAuthUploadUtility.uploadFile(encryptedPgpBytes, fileName, endpointUrl, client);
        }
        catch (Exception e) {
            logger.error("Error during P12/PFX upload operation", (Throwable)e);
            throw new IOException("Failed to perform upload operation with P12/PFX", e);
        }
    }

    public static ApiResponse<String> handleUploadOperationUsingPrivateKeyAndCerts(byte[] encryptedPgpBytes, String endpointUrl, String fileName, PrivateKey clientPrivateKey, X509Certificate clientCert, Collection<X509Certificate> serverTrustCerts) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        KeyStore clientKeyStore = KeyStore.getInstance("PKCS12");
        clientKeyStore.load(null, null);
        clientKeyStore.setKeyEntry("client", clientPrivateKey, new char[0], new Certificate[]{clientCert});
        KeyStore serverTrustStore = null;
        if (serverTrustCerts != null && !serverTrustCerts.isEmpty()) {
            serverTrustStore = KeyStore.getInstance("JKS");
            serverTrustStore.load(null, null);
            int i = 0;
            for (X509Certificate cert : serverTrustCerts) {
                serverTrustStore.setCertificateEntry("server-" + i, cert);
                ++i;
            }
        }
        try {
            OkHttpClient client = MutualAuthUploadUtility.getOkHttpClientForMutualAuth(clientKeyStore, serverTrustStore, new char[0]);
            return MutualAuthUploadUtility.uploadFile(encryptedPgpBytes, fileName, endpointUrl, client);
        }
        catch (Exception e) {
            logger.error("Error during upload operation using private/cert keys ", (Throwable)e);
            throw new IOException("Failed to perform upload operation with private/cert keys ", e);
        }
    }

    public static void setDisableSslVerification(boolean disable) {
        logger.warn("Setting disableSslVerification to: " + disable);
        if (disable) {
            logger.warn("SSL verification is DISABLED. This setting is NOT SAFE for production and should NOT be used in production environments!");
        }
        disableSslVerification = disable;
    }

    private static OkHttpClient getOkHttpClientForMutualAuth(KeyStore clientKeyStore, KeyStore serverTrustStore, char[] keyPassword) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, KeyManagementException {
        if (disableSslVerification) {
            logger.warn("SSL verification is DISABLED. This setting is NOT SAFE for production and should NOT be used in production environments!");
            X509TrustManager trustAllManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(clientKeyStore, keyPassword);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), new TrustManager[]{trustAllManager}, new SecureRandom());
            return new OkHttpClient.Builder().sslSocketFactory(sslContext.getSocketFactory(), trustAllManager).hostnameVerifier((hostname, session) -> true).build();
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(clientKeyStore, keyPassword);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(serverTrustStore);
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), new SecureRandom());
        return new OkHttpClient.Builder().sslSocketFactory(sslContext.getSocketFactory(), (X509TrustManager)tmf.getTrustManagers()[0]).build();
    }

    private static ApiResponse<String> uploadFile(byte[] encryptedPgpBytes, String fileName, String endpointUrl, OkHttpClient okHttpClient) throws IOException, ApiException {
        logger.info("Starting file upload process");
        fileName = StringUtils.isEmpty((CharSequence)fileName) ? "file.pgp" : (fileName.contains(".") ? fileName.substring(0, fileName.lastIndexOf(46)) : fileName) + ".pgp";
        RequestBody fileBody = RequestBody.create((byte[])encryptedPgpBytes, (MediaType)MediaType.parse((String)"application/octet-stream"));
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", fileName, fileBody).build();
        String correlationId = UUID.randomUUID().toString();
        Request request = new Request.Builder().url(endpointUrl).addHeader("v-c-correlation-id", correlationId).post((RequestBody)requestBody).build();
        logger.info("Executing HTTP POST request to URL: {} with correlation ID: {} for file: {}", (Object)endpointUrl, (Object)correlationId, (Object)fileName);
        Throwable throwable = null;
        try (Response response = okHttpClient.newCall(request).execute();){
            int statusCode = response.code();
            String responseBody = response.body() != null ? response.body().string() : "";
            logger.info("Upload completed for correlationId: {}. Response status code: {}", (Object)correlationId, (Object)statusCode);
            if (statusCode >= 200 && statusCode < 300) {
                logger.info("File uploaded successfully for correlationId: {}", (Object)correlationId);
                ApiResponse<String> apiResponse = new ApiResponse<String>(response.code(), response.headers().toMultimap(), response.message(), responseBody);
                return apiResponse;
            }
            try {
                logger.error("File upload failed for correlationId: {}. Status code: {}, response: {}", (Object)correlationId, (Object)statusCode, (Object)responseBody);
                String errorMessage = "File upload failed. Status code: " + statusCode + ", body: " + responseBody;
                throw new ApiException(errorMessage, statusCode, (Map<String, List<String>>)response.headers().toMultimap(), responseBody);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

