/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.InlineResponse2002;
import Model.InlineResponse2013;
import Model.PostRegistrationBody;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.util.mle.MLEException;
import com.cybersource.authsdk.util.mle.MLEUtility;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class MerchantBoardingApi {
    private static Logger logger = LogManager.getLogger(MerchantBoardingApi.class);
    private ApiClient apiClient;

    public MerchantBoardingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public MerchantBoardingApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getRegistrationCall(String registrationId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String inboundMLEStatus;
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (String)(inboundMLEStatus = "false"), (String)"getRegistration,getRegistrationAsync,getRegistrationWithHttpInfo,getRegistrationCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/boarding/v1/registrations/{registrationId}".replaceAll("\\{registrationId\\}", this.apiClient.escapeString(registrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getRegistrationValidateBeforeCall(String registrationId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (registrationId == null) {
            logger.error("Missing the required parameter 'registrationId' when calling getRegistration(Async)");
            throw new ApiException("Missing the required parameter 'registrationId' when calling getRegistration(Async)");
        }
        Call call = this.getRegistrationCall(registrationId, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse2002 getRegistration(String registrationId) throws ApiException {
        logger.info("CALL TO METHOD 'getRegistration' STARTED");
        ApiResponse<InlineResponse2002> resp = this.getRegistrationWithHttpInfo(registrationId);
        logger.info("CALL TO METHOD 'getRegistration' ENDED");
        return resp.getData();
    }

    public ApiResponse<InlineResponse2002> getRegistrationWithHttpInfo(String registrationId) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.getRegistrationValidateBeforeCall(registrationId, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2002>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getRegistrationAsync(String registrationId, final ApiCallback<InlineResponse2002> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getRegistrationValidateBeforeCall(registrationId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2002>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postRegistrationCall(PostRegistrationBody postRegistrationBody, String vCIdempotencyId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(postRegistrationBody, PostRegistrationBody.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        String inboundMLEStatus = "false";
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (String)inboundMLEStatus, (String)"postRegistration,postRegistrationAsync,postRegistrationWithHttpInfo,postRegistrationCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/boarding/v1/registrations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (vCIdempotencyId != null) {
            localVarHeaderParams.put("v-c-idempotency-id", this.apiClient.parameterToString(vCIdempotencyId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postRegistrationValidateBeforeCall(PostRegistrationBody postRegistrationBody, String vCIdempotencyId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (postRegistrationBody == null) {
            logger.error("Missing the required parameter 'postRegistrationBody' when calling postRegistration(Async)");
            throw new ApiException("Missing the required parameter 'postRegistrationBody' when calling postRegistration(Async)");
        }
        Call call = this.postRegistrationCall(postRegistrationBody, vCIdempotencyId, progressListener, progressRequestListener);
        return call;
    }

    public InlineResponse2013 postRegistration(PostRegistrationBody postRegistrationBody, String vCIdempotencyId) throws ApiException {
        logger.info("CALL TO METHOD 'postRegistration' STARTED");
        ApiResponse<InlineResponse2013> resp = this.postRegistrationWithHttpInfo(postRegistrationBody, vCIdempotencyId);
        logger.info("CALL TO METHOD 'postRegistration' ENDED");
        return resp.getData();
    }

    public ApiResponse<InlineResponse2013> postRegistrationWithHttpInfo(PostRegistrationBody postRegistrationBody, String vCIdempotencyId) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.postRegistrationValidateBeforeCall(postRegistrationBody, vCIdempotencyId, null, null);
        Type localVarReturnType = new TypeToken<InlineResponse2013>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postRegistrationAsync(PostRegistrationBody postRegistrationBody, String vCIdempotencyId, final ApiCallback<InlineResponse2013> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postRegistrationValidateBeforeCall(postRegistrationBody, vCIdempotencyId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<InlineResponse2013>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

