/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.TokenizedcardRequest;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.util.mle.MLEException;
import com.cybersource.authsdk.util.mle.MLEUtility;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class TokenizedCardApi {
    private static Logger logger = LogManager.getLogger(TokenizedCardApi.class);
    private ApiClient apiClient;

    public TokenizedCardApi() {
        this(Configuration.getDefaultApiClient());
    }

    public TokenizedCardApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteTokenizedCardCall(String tokenizedCardId, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String inboundMLEStatus;
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = null;
        if ("DELETE".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (String)(inboundMLEStatus = "false"), (String)"deleteTokenizedCard,deleteTokenizedCardAsync,deleteTokenizedCardWithHttpInfo,deleteTokenizedCardCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/tms/v2/tokenized-cards/{tokenizedCardId}".replaceAll("\\{tokenizedCardId\\}", this.apiClient.escapeString(tokenizedCardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteTokenizedCardValidateBeforeCall(String tokenizedCardId, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tokenizedCardId == null) {
            logger.error("Missing the required parameter 'tokenizedCardId' when calling deleteTokenizedCard(Async)");
            throw new ApiException("Missing the required parameter 'tokenizedCardId' when calling deleteTokenizedCard(Async)");
        }
        Call call = this.deleteTokenizedCardCall(tokenizedCardId, profileId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteTokenizedCard(String tokenizedCardId, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'deleteTokenizedCard' STARTED");
        this.deleteTokenizedCardWithHttpInfo(tokenizedCardId, profileId);
    }

    public ApiResponse<Void> deleteTokenizedCardWithHttpInfo(String tokenizedCardId, String profileId) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.deleteTokenizedCardValidateBeforeCall(tokenizedCardId, profileId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteTokenizedCardAsync(String tokenizedCardId, String profileId, final ApiCallback<Void> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteTokenizedCardValidateBeforeCall(tokenizedCardId, profileId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getTokenizedCardCall(String tokenizedCardId, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String inboundMLEStatus;
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (String)(inboundMLEStatus = "false"), (String)"getTokenizedCard,getTokenizedCardAsync,getTokenizedCardWithHttpInfo,getTokenizedCardCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/tms/v2/tokenized-cards/{tokenizedCardId}".replaceAll("\\{tokenizedCardId\\}", this.apiClient.escapeString(tokenizedCardId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getTokenizedCardValidateBeforeCall(String tokenizedCardId, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tokenizedCardId == null) {
            logger.error("Missing the required parameter 'tokenizedCardId' when calling getTokenizedCard(Async)");
            throw new ApiException("Missing the required parameter 'tokenizedCardId' when calling getTokenizedCard(Async)");
        }
        Call call = this.getTokenizedCardCall(tokenizedCardId, profileId, progressListener, progressRequestListener);
        return call;
    }

    public TokenizedcardRequest getTokenizedCard(String tokenizedCardId, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'getTokenizedCard' STARTED");
        ApiResponse<TokenizedcardRequest> resp = this.getTokenizedCardWithHttpInfo(tokenizedCardId, profileId);
        logger.info("CALL TO METHOD 'getTokenizedCard' ENDED");
        return resp.getData();
    }

    public ApiResponse<TokenizedcardRequest> getTokenizedCardWithHttpInfo(String tokenizedCardId, String profileId) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.getTokenizedCardValidateBeforeCall(tokenizedCardId, profileId, null, null);
        Type localVarReturnType = new TypeToken<TokenizedcardRequest>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getTokenizedCardAsync(String tokenizedCardId, String profileId, final ApiCallback<TokenizedcardRequest> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getTokenizedCardValidateBeforeCall(tokenizedCardId, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TokenizedcardRequest>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postTokenizedCardCall(TokenizedcardRequest tokenizedcardRequest, String profileId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(tokenizedcardRequest, TokenizedcardRequest.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        String inboundMLEStatus = "false";
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (String)inboundMLEStatus, (String)"postTokenizedCard,postTokenizedCardAsync,postTokenizedCardWithHttpInfo,postTokenizedCardCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/tms/v2/tokenized-cards";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        if (profileId != null) {
            localVarHeaderParams.put("profile-id", this.apiClient.parameterToString(profileId));
        }
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postTokenizedCardValidateBeforeCall(TokenizedcardRequest tokenizedcardRequest, String profileId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (tokenizedcardRequest == null) {
            logger.error("Missing the required parameter 'tokenizedcardRequest' when calling postTokenizedCard(Async)");
            throw new ApiException("Missing the required parameter 'tokenizedcardRequest' when calling postTokenizedCard(Async)");
        }
        Call call = this.postTokenizedCardCall(tokenizedcardRequest, profileId, progressListener, progressRequestListener);
        return call;
    }

    public TokenizedcardRequest postTokenizedCard(TokenizedcardRequest tokenizedcardRequest, String profileId) throws ApiException {
        logger.info("CALL TO METHOD 'postTokenizedCard' STARTED");
        ApiResponse<TokenizedcardRequest> resp = this.postTokenizedCardWithHttpInfo(tokenizedcardRequest, profileId);
        logger.info("CALL TO METHOD 'postTokenizedCard' ENDED");
        return resp.getData();
    }

    public ApiResponse<TokenizedcardRequest> postTokenizedCardWithHttpInfo(TokenizedcardRequest tokenizedcardRequest, String profileId) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.postTokenizedCardValidateBeforeCall(tokenizedcardRequest, profileId, null, null);
        Type localVarReturnType = new TypeToken<TokenizedcardRequest>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postTokenizedCardAsync(TokenizedcardRequest tokenizedcardRequest, String profileId, final ApiCallback<TokenizedcardRequest> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postTokenizedCardValidateBeforeCall(tokenizedcardRequest, profileId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<TokenizedcardRequest>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

