/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiException;
import Invokers.ApiResponse;
import java.io.File;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.openpgp.PGPPublicKey;
import utilities.pgpBatchUpload.BatchUploadUtility;
import utilities.pgpBatchUpload.MutualAuthUploadUtility;
import utilities.pgpBatchUpload.PgpEncryptionUtility;

public class BatchUploadwithMTLSApi {
    private static Logger logger = LogManager.getLogger(BatchUploadwithMTLSApi.class);

    public ApiResponse<String> uploadBatchAPI(File inputFile, String environmentHostname, String pgpEncryptionCertPath, String keystorePath, char[] keystorePassword, String truststorePath, char[] truststorePassword) throws ApiException, Exception {
        logger.info("Starting batch upload with JKS for given file");
        BatchUploadUtility.validateBatchApiJKSInputs(inputFile, environmentHostname, pgpEncryptionCertPath, keystorePath, truststorePath);
        String endpoint = "/pts/v1/transaction-batch-upload";
        String endpointUrl = BatchUploadUtility.getEndpointUrl(environmentHostname, endpoint);
        byte[] encryptedPgpBytes = PgpEncryptionUtility.handlePGPEncrypt(inputFile, pgpEncryptionCertPath);
        return MutualAuthUploadUtility.handleUploadOperationWithJKS(encryptedPgpBytes, endpointUrl, inputFile.getName(), keystorePath, keystorePassword, truststorePath, truststorePassword);
    }

    public ApiResponse<String> uploadBatchAPI(File inputFile, String environmentHostname, String pgpEncryptionCertPath, String clientCertP12FilePath, char[] clientCertP12Password, String serverTrustCertPath) throws ApiException, Exception {
        logger.info("Starting batch upload with p12/pfx for given file");
        BatchUploadUtility.validateBatchApiP12Inputs(inputFile, environmentHostname, pgpEncryptionCertPath, clientCertP12FilePath, serverTrustCertPath);
        String endpoint = "/pts/v1/transaction-batch-upload";
        String endpointUrl = BatchUploadUtility.getEndpointUrl(environmentHostname, endpoint);
        byte[] encryptedPgpBytes = PgpEncryptionUtility.handlePGPEncrypt(inputFile, pgpEncryptionCertPath);
        return MutualAuthUploadUtility.handleUploadOperationUsingP12orPfx(encryptedPgpBytes, endpointUrl, inputFile.getName(), clientCertP12FilePath, clientCertP12Password, serverTrustCertPath);
    }

    public ApiResponse<String> uploadBatchAPI(File inputFile, String environmentHostname, PGPPublicKey pgpPublicKey, PrivateKey clientPrivateKey, X509Certificate clientCert, Collection<X509Certificate> serverTrustCerts) throws ApiException, Exception {
        logger.info("Starting batch upload with client private key and certs for given file");
        BatchUploadUtility.validateBatchApiKeysInputs(inputFile, environmentHostname, pgpPublicKey, clientPrivateKey, clientCert, serverTrustCerts);
        String endpoint = "/pts/v1/transaction-batch-upload";
        String endpointUrl = BatchUploadUtility.getEndpointUrl(environmentHostname, endpoint);
        byte[] encryptedPgpBytes = PgpEncryptionUtility.handlePGPEncrypt(inputFile, pgpPublicKey);
        return MutualAuthUploadUtility.handleUploadOperationUsingPrivateKeyAndCerts(encryptedPgpBytes, endpointUrl, inputFile.getName(), clientPrivateKey, clientCert, serverTrustCerts);
    }
}

