/*
 * Decompiled with CFR 0.152.
 */
package Api;

import Invokers.ApiCallback;
import Invokers.ApiClient;
import Invokers.ApiException;
import Invokers.ApiResponse;
import Invokers.Configuration;
import Invokers.Pair;
import Invokers.ProgressRequestBody;
import Invokers.ProgressResponseBody;
import Model.CreateSubscriptionRequest1;
import Model.CreateSubscriptionResponse;
import Model.GetSubscriptionResponse1;
import com.cybersource.authsdk.core.MerchantConfig;
import com.cybersource.authsdk.util.mle.MLEException;
import com.cybersource.authsdk.util.mle.MLEUtility;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utilities.tracking.SdkTracker;

public class SubscriptionsFollowOnsApi {
    private static Logger logger = LogManager.getLogger(SubscriptionsFollowOnsApi.class);
    private ApiClient apiClient;

    public SubscriptionsFollowOnsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SubscriptionsFollowOnsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createFollowOnSubscriptionCall(String requestId, CreateSubscriptionRequest1 createSubscriptionRequest, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = sdkTracker.insertDeveloperIdTracker(createSubscriptionRequest, CreateSubscriptionRequest1.class.getSimpleName(), this.apiClient.merchantConfig.getRunEnvironment(), this.apiClient.merchantConfig.getDefaultDeveloperId());
        String inboundMLEStatus = "false";
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (String)inboundMLEStatus, (String)"createFollowOnSubscription,createFollowOnSubscriptionAsync,createFollowOnSubscriptionWithHttpInfo,createFollowOnSubscriptionCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/rbs/v1/subscriptions/follow-ons/{requestId}".replaceAll("\\{requestId\\}", this.apiClient.escapeString(requestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/hal+json", "application/json;charset=utf-8", "application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createFollowOnSubscriptionValidateBeforeCall(String requestId, CreateSubscriptionRequest1 createSubscriptionRequest, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (requestId == null) {
            logger.error("Missing the required parameter 'requestId' when calling createFollowOnSubscription(Async)");
            throw new ApiException("Missing the required parameter 'requestId' when calling createFollowOnSubscription(Async)");
        }
        if (createSubscriptionRequest == null) {
            logger.error("Missing the required parameter 'createSubscriptionRequest' when calling createFollowOnSubscription(Async)");
            throw new ApiException("Missing the required parameter 'createSubscriptionRequest' when calling createFollowOnSubscription(Async)");
        }
        Call call = this.createFollowOnSubscriptionCall(requestId, createSubscriptionRequest, progressListener, progressRequestListener);
        return call;
    }

    public CreateSubscriptionResponse createFollowOnSubscription(String requestId, CreateSubscriptionRequest1 createSubscriptionRequest) throws ApiException {
        logger.info("CALL TO METHOD 'createFollowOnSubscription' STARTED");
        ApiResponse<CreateSubscriptionResponse> resp = this.createFollowOnSubscriptionWithHttpInfo(requestId, createSubscriptionRequest);
        logger.info("CALL TO METHOD 'createFollowOnSubscription' ENDED");
        return resp.getData();
    }

    public ApiResponse<CreateSubscriptionResponse> createFollowOnSubscriptionWithHttpInfo(String requestId, CreateSubscriptionRequest1 createSubscriptionRequest) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.createFollowOnSubscriptionValidateBeforeCall(requestId, createSubscriptionRequest, null, null);
        Type localVarReturnType = new TypeToken<CreateSubscriptionResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createFollowOnSubscriptionAsync(String requestId, CreateSubscriptionRequest1 createSubscriptionRequest, final ApiCallback<CreateSubscriptionResponse> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createFollowOnSubscriptionValidateBeforeCall(requestId, createSubscriptionRequest, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreateSubscriptionResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFollowOnSubscriptionCall(String requestId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        String inboundMLEStatus;
        SdkTracker sdkTracker = new SdkTracker();
        Object localVarPostBody = null;
        if ("GET".equalsIgnoreCase("POST")) {
            localVarPostBody = "{}";
        }
        if (MLEUtility.checkIsMLEForAPI((MerchantConfig)this.apiClient.merchantConfig, (String)(inboundMLEStatus = "false"), (String)"getFollowOnSubscription,getFollowOnSubscriptionAsync,getFollowOnSubscriptionWithHttpInfo,getFollowOnSubscriptionCall")) {
            try {
                localVarPostBody = MLEUtility.encryptRequestPayload((MerchantConfig)this.apiClient.merchantConfig, (Object)localVarPostBody);
            }
            catch (MLEException e) {
                logger.error("Failed to encrypt request body {}", (Object)e.getMessage(), (Object)e);
                throw new ApiException("Failed to encrypt request body : " + e.getMessage());
            }
        }
        String localVarPath = "/rbs/v1/subscriptions/follow-ons/{requestId}".replaceAll("\\{requestId\\}", this.apiClient.escapeString(requestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/hal+json", "application/json;charset=utf-8", "application/hal+json;charset=utf-8"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json;charset=utf-8"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().newBuilder().addNetworkInterceptor(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFollowOnSubscriptionValidateBeforeCall(String requestId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (requestId == null) {
            logger.error("Missing the required parameter 'requestId' when calling getFollowOnSubscription(Async)");
            throw new ApiException("Missing the required parameter 'requestId' when calling getFollowOnSubscription(Async)");
        }
        Call call = this.getFollowOnSubscriptionCall(requestId, progressListener, progressRequestListener);
        return call;
    }

    public GetSubscriptionResponse1 getFollowOnSubscription(String requestId) throws ApiException {
        logger.info("CALL TO METHOD 'getFollowOnSubscription' STARTED");
        ApiResponse<GetSubscriptionResponse1> resp = this.getFollowOnSubscriptionWithHttpInfo(requestId);
        logger.info("CALL TO METHOD 'getFollowOnSubscription' ENDED");
        return resp.getData();
    }

    public ApiResponse<GetSubscriptionResponse1> getFollowOnSubscriptionWithHttpInfo(String requestId) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        Call call = this.getFollowOnSubscriptionValidateBeforeCall(requestId, null, null);
        Type localVarReturnType = new TypeToken<GetSubscriptionResponse1>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFollowOnSubscriptionAsync(String requestId, final ApiCallback<GetSubscriptionResponse1> callback) throws ApiException {
        this.apiClient.setComputationStartTime(System.nanoTime());
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFollowOnSubscriptionValidateBeforeCall(requestId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GetSubscriptionResponse1>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

