/*
 * Decompiled with CFR 0.152.
 */
package utilities.pgpBatchUpload;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import utilities.pgpBatchUpload.BatchUploadUtility;

public class PgpEncryptionUtility {
    private static final Logger logger = LogManager.getLogger(PgpEncryptionUtility.class);
    private static int bufferSize = 65536;

    public static byte[] handlePGPEncrypt(File inputFile, String pgpPublicKeyPath) throws IOException, PGPException, IllegalArgumentException {
        PGPPublicKey publicKey = BatchUploadUtility.readPGPPublicKey(pgpPublicKeyPath);
        return PgpEncryptionUtility.handlePGPEncrypt(inputFile, publicKey);
    }

    public static byte[] handlePGPEncrypt(File inputFile, PGPPublicKey pgpPublicKey) throws IOException, PGPException {
        if (inputFile == null || pgpPublicKey == null) {
            throw new IllegalArgumentException("Missing required options for encrypt operation");
        }
        String inputFileName = inputFile.getName();
        logger.info("Starting file encryption: {}", (Object)inputFileName);
        byte[] encryptedPgpBytes = PgpEncryptionUtility.encryptFile(inputFile, pgpPublicKey);
        logger.info("File encrypted successfully for {}", (Object)inputFileName);
        return encryptedPgpBytes;
    }

    private static byte[] encryptFile(File inputFile, PGPPublicKey publicKey) throws IOException, PGPException {
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();){
            PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)new JcePGPDataEncryptorBuilder(9).setWithIntegrityPacket(true).setSecureRandom(new SecureRandom()).setProvider("BC"));
            encGen.addMethod((PGPKeyEncryptionMethodGenerator)new JcePublicKeyKeyEncryptionMethodGenerator(publicKey).setProvider("BC"));
            try (OutputStream encOut = encGen.open((OutputStream)byteOut, new byte[bufferSize]);){
                PGPCompressedDataGenerator comData = new PGPCompressedDataGenerator(1);
                try (OutputStream comOut = comData.open(encOut);){
                    PGPUtil.writeFileToLiteralData((OutputStream)comOut, (char)'b', (File)inputFile);
                }
            }
            byte[] byArray = byteOut.toByteArray();
            return byArray;
        }
    }

    public static void setBufferSize(int size) {
        bufferSize = size;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

