/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.ConfigException;
import com.cybersource.ws.client.Logger;
import com.cybersource.ws.client.MerchantConfig;
import com.cybersource.ws.client.SignException;
import com.cybersource.ws.client.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ApacheSignatureWrapper {
    private static final String KEY_FILE_TYPE = "PKCS12";
    private static X509Certificate merchantCertificate = null;
    private static PrivateKey merchantPrivateKey = null;
    private static String currentMerchantId = null;
    public static final String SIGNATURE_ALGORITHM = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    public static final String DIGEST_ALGORITHM = "http://www.w3.org/2001/04/xmlenc#sha256";

    ApacheSignatureWrapper() {
    }

    public static Document soapWrapAndSign(String trxnDataXml, MerchantConfig merchantConfig, Logger logger) throws SignException {
        Document soapDocument;
        String[] keySerialrray;
        Document doc = ApacheSignatureWrapper.getDocumentFromString(trxnDataXml, logger);
        ApacheSignatureWrapper.loadMerchantP12File(merchantConfig, logger);
        WSSecSignature wsSecSignature = new WSSecSignature();
        wsSecSignature.setX509Certificate(merchantCertificate);
        wsSecSignature.setUseSingleCertificate(true);
        wsSecSignature.setDigestAlgo(DIGEST_ALGORITHM);
        wsSecSignature.setSignatureAlgorithm(SIGNATURE_ALGORITHM);
        wsSecSignature.setKeyIdentifierType(1);
        WSEncryptionPart msgBodyPart = new WSEncryptionPart("Body", "http://schemas.xmlsoap.org/soap/envelope/", "");
        wsSecSignature.setParts(Collections.singletonList(msgBodyPart));
        WSSecHeader secHeader = new WSSecHeader();
        try {
            secHeader.insertSecurityHeader(doc);
        }
        catch (WSSecurityException e) {
            logger.log("EXCEPTION", "Exception while signing XML document");
            throw new SignException((Exception)((Object)e));
        }
        String keyFileName = "";
        if (merchantConfig.getKeyFilename() != null) {
            if (merchantConfig.getKeysDirectory() != null) {
                keyFileName = merchantConfig.getKeysDirectory() + File.separatorChar + merchantConfig.getKeyFilename();
            }
        } else {
            keyFileName = merchantConfig.getKeysDirectory() + File.separatorChar + merchantConfig.getMerchantID() + ".p12";
        }
        Properties properties = new Properties();
        properties.setProperty("org.apache.ws.security.crypto.merlin.keystore.provider", "BC");
        properties.setProperty("org.apache.ws.security.crypto.merlin.cert.provider", "BC");
        properties.setProperty("org.apache.ws.security.crypto.merlin.keystore.file", keyFileName);
        properties.setProperty("org.apache.ws.security.crypto.merlin.keystore.password", merchantConfig.getKeyPassword());
        properties.setProperty("org.apache.ws.security.crypto.merlin.keystore.type", KEY_FILE_TYPE);
        String keySerial = merchantCertificate.getSubjectDN().getName();
        if (keySerial != null) {
            keySerialrray = keySerial.split("SERIALNUMBER=");
            if (keySerialrray.length != 2) {
                logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
                throw new SignException("Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
            }
        } else {
            logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
            throw new SignException("Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
        }
        keySerial = keySerialrray[1];
        String keyAlias = "serialNumber=" + keySerial + ",CN=" + merchantConfig.getMerchantID();
        properties.setProperty("org.apache.ws.security.crypto.merlin.keystore.alias", keyAlias);
        wsSecSignature.setUserInfo(keyAlias, merchantConfig.getKeyPassword());
        try {
            soapDocument = wsSecSignature.build(doc, CryptoFactory.getInstance((Properties)properties), secHeader);
        }
        catch (WSSecurityException e) {
            logger.log("EXCEPTION", "Exception while signing XML document");
            throw new SignException((Exception)((Object)e));
        }
        return soapDocument;
    }

    private static Document getDocumentFromString(String trxnDataXml, Logger logger) throws SignException {
        Document doc;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder builder = Utility.newDocumentBuilder();
            StringReader sr = new StringReader(trxnDataXml);
            doc = builder.parse(new InputSource(sr));
            sr.close();
        }
        catch (ParserConfigurationException e) {
            logger.log("EXCEPTION", "Exception while signing XML document");
            throw new SignException(e);
        }
        catch (SAXException e) {
            logger.log("EXCEPTION", "Exception while signing XML document");
            throw new SignException(e);
        }
        catch (IOException e) {
            logger.log("EXCEPTION", "Exception while signing XML document");
            throw new SignException(e);
        }
        return doc;
    }

    private static void loadMerchantP12File(MerchantConfig merchantConfig, Logger logger) throws SignException {
        if (merchantCertificate == null || merchantPrivateKey == null) {
            ApacheSignatureWrapper.readAndStoreCertificateAndPrivateKey(merchantConfig, logger);
        } else if (!currentMerchantId.equals(merchantConfig.getMerchantID())) {
            ApacheSignatureWrapper.readAndStoreCertificateAndPrivateKey(merchantConfig, logger);
        }
    }

    private static void readAndStoreCertificateAndPrivateKey(MerchantConfig merchantConfig, Logger logger) throws SignException {
        KeyStore.PrivateKeyEntry keyEntry;
        KeyStore merchantKeyStore;
        try {
            merchantKeyStore = KeyStore.getInstance(KEY_FILE_TYPE, (Provider)new BouncyCastleProvider());
        }
        catch (KeyStoreException e) {
            logger.log("EXCEPTION", "Exception while instantiating KeyStore");
            throw new SignException(e);
        }
        try {
            merchantKeyStore.load(new FileInputStream(merchantConfig.getKeyFile()), merchantConfig.getKeyPassword().toCharArray());
        }
        catch (IOException e) {
            logger.log("EXCEPTION", "Exception while loading KeyStore, '" + merchantConfig.getKeyFilename() + "'");
            throw new SignException(e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.log("EXCEPTION", "Exception while loading KeyStore, '" + merchantConfig.getKeyFilename() + "'");
            throw new SignException(e);
        }
        catch (CertificateException e) {
            logger.log("EXCEPTION", "Exception while loading KeyStore, '" + merchantConfig.getKeyFilename() + "'");
            throw new SignException(e);
        }
        catch (ConfigException e) {
            logger.log("EXCEPTION", "Exception while loading KeyStore, '" + merchantConfig.getKeyFilename() + "'");
            throw new SignException(e);
        }
        String merchantKeyAlias = null;
        try {
            Enumeration<String> enumKeyStore = merchantKeyStore.aliases();
            while (enumKeyStore.hasMoreElements() && !(merchantKeyAlias = enumKeyStore.nextElement()).contains(merchantConfig.getKeyAlias())) {
            }
        }
        catch (KeyStoreException e) {
            logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
            throw new SignException(e);
        }
        try {
            keyEntry = (KeyStore.PrivateKeyEntry)merchantKeyStore.getEntry(merchantKeyAlias, new KeyStore.PasswordProtection(merchantConfig.getKeyPassword().toCharArray()));
        }
        catch (NoSuchAlgorithmException e) {
            logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
            throw new SignException(e);
        }
        catch (UnrecoverableEntryException e) {
            logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
            throw new SignException(e);
        }
        catch (KeyStoreException e) {
            logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
            throw new SignException(e);
        }
        merchantCertificate = (X509Certificate)keyEntry.getCertificate();
        merchantPrivateKey = keyEntry.getPrivateKey();
        currentMerchantId = merchantConfig.getMerchantID();
        if (merchantCertificate == null || merchantPrivateKey == null) {
            logger.log("EXCEPTION", "No valid entries found in the KeyStore, check alias, '" + merchantConfig.getKeyAlias() + "'");
            throw new SignException("No valid entries found in the KeyStore, check alias, '" + merchantConfig.getKeyAlias() + "'");
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

