/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.ApacheSignatureWrapper;
import com.cybersource.ws.client.ClientException;
import com.cybersource.ws.client.ConfigException;
import com.cybersource.ws.client.Connection;
import com.cybersource.ws.client.FaultException;
import com.cybersource.ws.client.Logger;
import com.cybersource.ws.client.LoggerWrapper;
import com.cybersource.ws.client.MerchantConfig;
import com.cybersource.ws.client.SignException;
import com.cybersource.ws.client.Utility;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client {
    private static final String HEADER_FORMAT = "{0}={1}";
    private static final String SOAP_ENVELOPE1 = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">\n<soap:Body id=\"body1\">\n<nvpRequest xmlns=\"{0}\">\n{1}</nvpRequest>\n</soap:Body>\n</soap:Envelope>";
    private static final String ELEM_NVP_REPLY = "nvpReply";
    private static final String MERCHANT_ID = "merchantID";

    public static Map runTransaction(Map<String, String> request, Properties props) throws FaultException, ClientException {
        return Client.runTransaction(request, props, null, true, true);
    }

    public static Map runTransaction(Map<String, String> request, Properties props, Logger _logger, boolean prepare, boolean logTranStart) throws FaultException, ClientException {
        LoggerWrapper logger = null;
        Connection con = null;
        try {
            MerchantConfig mc;
            Client.setVersionInformation(request);
            String merchantID = request.get(MERCHANT_ID);
            if (merchantID == null) {
                mc = new MerchantConfig(props, null);
                merchantID = mc.getMerchantID();
                request.put(MERCHANT_ID, merchantID);
            } else {
                mc = new MerchantConfig(props, merchantID);
            }
            logger = new LoggerWrapper(_logger, prepare, logTranStart, mc);
            DocumentBuilder builder = Utility.newDocumentBuilder();
            Document signedDoc = Client.soapWrapAndSign(request, mc, logger);
            con = Connection.getInstance(mc, builder, logger);
            Document wrappedReply = con.post(signedDoc);
            HashMap hashMap = Client.soapUnwrap(wrappedReply, mc, logger);
            return hashMap;
        }
        catch (IOException e) {
            throw new ClientException(e, con != null && con.isRequestSent(), logger);
        }
        catch (ParserConfigurationException e) {
            throw new ClientException(e, con != null && con.isRequestSent(), logger);
        }
        catch (SignException e) {
            throw new ClientException(e, con != null && con.isRequestSent(), logger);
        }
        catch (ConfigException e) {
            throw new ClientException(e, con != null && con.isRequestSent(), logger);
        }
        finally {
            if (con != null) {
                con.release();
            }
        }
    }

    private static void setVersionInformation(Map<String, String> request) {
        request.put("clientLibrary", "Java Basic");
        request.put("clientLibraryVersion", "6.1.0");
        request.put("clientEnvironment", Utility.ENVIRONMENT);
    }

    private static Document soapWrapAndSign(Map request, MerchantConfig mc, LoggerWrapper logger) throws IOException, SignException {
        boolean logSignedData = mc.getLogSignedData();
        if (!logSignedData) {
            logger.log("REQUEST  ", Client.mapToString(request, true, 0));
        }
        Object[] arguments = new Object[]{mc.getEffectiveNamespaceURI(), Client.mapToString(request, false, 0)};
        String xmlString = MessageFormat.format(SOAP_ENVELOPE1, arguments);
        Document doc = ApacheSignatureWrapper.soapWrapAndSign(xmlString, mc, logger);
        if (logSignedData) {
            logger.log("REQUEST  ", Utility.nodeToString(doc, 0));
        }
        return doc;
    }

    private static HashMap soapUnwrap(Document doc, MerchantConfig mc, LoggerWrapper logger) {
        boolean logSignedData = mc.getLogSignedData();
        if (logSignedData) {
            logger.log("REPLY    ", Utility.nodeToString(doc, 1));
        }
        Element nvpReply = Utility.getElement(doc, ELEM_NVP_REPLY, mc.getEffectiveNamespaceURI());
        Text nvpString = (Text)nvpReply.getFirstChild();
        String replyString = nvpString.getNodeValue();
        HashMap reply = Utility.stringToMap(replyString);
        if (!logSignedData) {
            logger.log("REPLY    ", Client.mapToString(reply, true, 1));
        }
        return reply;
    }

    static String mapToString(Map src, boolean mask, int type) {
        return Utility.mapToString(src, mask, type);
    }
}

