/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.Logger;
import com.cybersource.ws.client.Utility;

public class ClientException
extends Exception {
    private Exception innerException = null;
    private boolean critical = false;
    private int httpStatusCode = -1;
    private String httpError = null;

    public ClientException(Exception _innerException, Logger logger) {
        this.innerException = _innerException;
        this.log(logger);
    }

    public ClientException(Exception _innerException, boolean _critical, Logger logger) {
        this.innerException = _innerException;
        this.critical = _critical;
        this.log(logger);
    }

    public ClientException(int _httpStatusCode, Logger logger) {
        this.httpStatusCode = _httpStatusCode;
        this.critical = _httpStatusCode == 504;
        this.log(logger);
    }

    public ClientException(int _httpStatusCode, String _httpError, Logger logger) {
        this(_httpStatusCode, logger);
        this.httpError = _httpError;
        this.log(logger);
    }

    public ClientException(int _httpStatusCode, String _httpError, boolean _critical, Logger logger) {
        this(_httpStatusCode, logger);
        this.httpError = _httpError;
        if (!this.critical) {
            this.critical = _critical;
        }
        this.log(logger);
    }

    public Exception getInnerException() {
        return this.innerException;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getHttpError() {
        return this.httpError;
    }

    void log(Logger logger) {
        if (logger != null) {
            logger.log("EXCEPTION", this.getLogString());
        }
    }

    String getLogString() {
        StringBuffer sb = new StringBuffer("ClientException details:\n");
        if (this.critical) {
            sb.append("CRITICAL\n");
        }
        if (this.httpStatusCode != -1) {
            sb.append("httpStatusCode = " + this.httpStatusCode + "\n");
        }
        if (this.httpError != null) {
            sb.append("httpError = " + this.httpError + "\n");
        }
        if (this.innerException != null) {
            sb.append("innerException: \n" + Utility.getStackTrace(this.innerException));
        } else {
            sb.append("Stack trace: \n" + Utility.getStackTrace(this));
        }
        return sb.toString();
    }

    public String getMessage() {
        if (this.innerException != null) {
            return this.innerException.getMessage();
        }
        StringBuffer sb = new StringBuffer("ClientException:");
        if (this.httpStatusCode != -1) {
            sb.append(" (" + this.httpStatusCode + ")");
        }
        if (this.httpError != null) {
            sb.append(" " + this.httpError);
        }
        if (this.critical) {
            sb.append(" (CRITICAL)");
        }
        return sb.toString();
    }
}

