/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.Logger;
import com.cybersource.ws.client.Utility;
import org.w3c.dom.Document;

public class FaultException
extends Exception {
    private final Document faultDocument;
    private String faultCode = null;
    private String faultString = null;
    private String requestID = null;
    private boolean critical = true;

    public FaultException(Document _faultDocument, String nsURI, Logger logger) {
        this.faultDocument = _faultDocument;
        this.extractFields(nsURI);
        this.log(logger);
    }

    public Document getFaultDocument() {
        return this.faultDocument;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public String getRequestID() {
        return this.requestID;
    }

    public boolean isCritical() {
        return this.critical;
    }

    private void extractFields(String nsURI) {
        if (this.faultDocument != null) {
            this.faultString = Utility.getElementText(this.faultDocument, "faultstring", null);
            this.requestID = Utility.getElementText(this.faultDocument, "requestID", nsURI);
            this.faultCode = Utility.getElementText(this.faultDocument, "faultcode", null);
            int colonPos = this.faultCode.indexOf(":");
            String localPart = colonPos != -1 ? this.faultCode.substring(colonPos + 1) : this.faultCode;
            this.critical = "CriticalServerError".equalsIgnoreCase(localPart);
        }
    }

    void log(Logger logger) {
        if (logger != null) {
            logger.log("FAULT    ", this.getLogString());
        }
    }

    String getLogString() {
        StringBuffer sb = new StringBuffer("FaultException details:\n");
        if (this.critical) {
            sb.append("CRITICAL\n");
        }
        if (this.requestID != null) {
            sb.append("requestID = " + this.requestID + "\n");
        }
        sb.append(Utility.nodeToString(this.faultDocument));
        return sb.toString();
    }

    public String getMessage() {
        StringBuffer sb = new StringBuffer("Fault:");
        if (this.faultString != null) {
            sb.append(" " + this.faultString);
        }
        if (this.requestID != null) {
            sb.append(" (requestID=" + this.requestID + ")");
        }
        if (this.critical) {
            sb.append(" (CRITICAL)");
        }
        return sb.toString();
    }
}

