/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.ConfigException;
import com.cybersource.ws.client.Logger;
import com.cybersource.ws.client.LoggerImpl;
import com.cybersource.ws.client.MerchantConfig;

public class LoggerWrapper
implements Logger {
    private Logger logger = null;

    public LoggerWrapper(Logger _logger, boolean _prepare, boolean _logTranStart, MerchantConfig _mc) throws ConfigException {
        MerchantConfig mc = _mc;
        boolean prepare = false;
        boolean logTranStart = false;
        if (_logger != null) {
            this.logger = _logger;
            prepare = _prepare;
            logTranStart = _logTranStart;
        } else if (mc.getEnableLog()) {
            this.logger = new LoggerImpl(mc);
            prepare = true;
            logTranStart = true;
        }
        if (prepare) {
            this.prepare();
        }
        if (logTranStart) {
            this.logTransactionStart();
        }
    }

    public void prepare() throws ConfigException {
        if (this.logger != null) {
            this.logger.prepare();
        }
    }

    public void logTransactionStart() {
        if (this.logger != null) {
            this.logger.logTransactionStart();
        }
    }

    public void log(String type, String text) {
        if (this.logger != null) {
            this.logger.log(type, text);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }
}

