/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.ConfigException;
import com.cybersource.ws.client.ConnectionHelper;
import java.io.File;
import java.text.MessageFormat;
import java.util.Properties;

public class MerchantConfig {
    private final String SYSPROP_PREFIX = "cybs.";
    private static final int DEFAULT_TIMEOUT = 130;
    private static final int DEFAULT_PROXY_PORT = 8080;
    private final Properties props;
    private final String merchantID;
    private String keysDirectory;
    private String keyAlias;
    private String keyPassword;
    private boolean sendToProduction;
    private String targetAPIVersion;
    private String keyFilename;
    private String serverURL;
    private String namespaceURI;
    private String password;
    private boolean enableLog;
    private boolean logSignedData;
    private String logDirectory;
    private String logFilename;
    private int logMaximumSize;
    private boolean useHttpClient;
    private int timeout;
    private String proxyHost;
    private int proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private String effectiveServerURL;
    private String effectiveNamespaceURI;
    private String effectivePassword;

    public String getMerchantID() {
        return this.merchantID;
    }

    public String getKeysDirectory() {
        return this.keysDirectory;
    }

    public String getKeyAlias() {
        if (this.keyAlias != null) {
            return this.keyAlias;
        }
        return this.getMerchantID();
    }

    public String getKeyPassword() {
        if (this.keyPassword != null) {
            return this.keyPassword;
        }
        return this.getMerchantID();
    }

    public boolean getSendToProduction() {
        return this.sendToProduction;
    }

    public String getTargetAPIVersion() {
        return this.targetAPIVersion;
    }

    public String getKeyFilename() {
        return this.keyFilename;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getEnableLog() {
        return this.enableLog;
    }

    public boolean getLogSignedData() {
        return this.logSignedData;
    }

    public String getLogDirectory() {
        return this.logDirectory;
    }

    public String getLogFilename() {
        return this.logFilename;
    }

    public int getLogMaximumSize() {
        return this.logMaximumSize;
    }

    public boolean getUseHttpClient() {
        return this.useHttpClient;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPassword() {
        return this.proxyPassword != null ? this.proxyPassword : "";
    }

    public String getEffectiveServerURL() {
        return this.effectiveServerURL;
    }

    public String getEffectiveNamespaceURI() {
        return this.effectiveNamespaceURI;
    }

    public String getEffectivePassword() {
        return this.effectivePassword;
    }

    public MerchantConfig(Properties _props, String _merchantID) throws ConfigException {
        this.props = _props;
        String string = this.merchantID = _merchantID != null ? _merchantID : this.getProperty(null, "merchantID");
        if (this.merchantID == null) {
            throw new ConfigException("merchantID is required.");
        }
        this.keysDirectory = this.getProperty(this.merchantID, "keysDirectory");
        this.keyAlias = this.getProperty(this.merchantID, "keyAlias");
        this.keyPassword = this.getProperty(this.merchantID, "keyPassword");
        this.sendToProduction = this.getBooleanProperty(this.merchantID, "sendToProduction", false);
        this.targetAPIVersion = this.getProperty(this.merchantID, "targetAPIVersion");
        this.keyFilename = this.getProperty(this.merchantID, "keyFilename");
        this.serverURL = this.getProperty(this.merchantID, "serverURL");
        this.namespaceURI = this.getProperty(this.merchantID, "namespaceURI");
        this.password = this.getProperty(this.merchantID, "password");
        this.enableLog = this.getBooleanProperty(this.merchantID, "enableLog", false);
        this.logSignedData = this.getBooleanProperty(this.merchantID, "logNonPCICompliantSignedData", false);
        this.logDirectory = this.getProperty(this.merchantID, "logDirectory");
        this.logFilename = this.getProperty(this.merchantID, "logFilename");
        this.logMaximumSize = this.getIntegerProperty(this.merchantID, "logMaximumSize", 10);
        this.useHttpClient = this.getBooleanProperty(this.merchantID, "useHttpClient", ConnectionHelper.getDefaultUseHttpClient());
        this.timeout = this.getIntegerProperty(this.merchantID, "timeout", 130);
        this.proxyHost = this.getProperty(this.merchantID, "proxyHost");
        this.proxyPort = this.getIntegerProperty(this.merchantID, "proxyPort", 8080);
        this.proxyUser = this.getProperty(this.merchantID, "proxyUser");
        this.proxyPassword = this.getProperty(this.merchantID, "proxyPassword");
        if (this.namespaceURI == null && this.targetAPIVersion == null) {
            throw new ConfigException("namespaceURI or targetAPIVersion must be supplied.");
        }
        String string2 = this.effectiveNamespaceURI = this.namespaceURI != null ? this.namespaceURI : "urn:schemas-cybersource-com:transaction-data-" + this.targetAPIVersion;
        if (this.serverURL == null && this.targetAPIVersion == null) {
            throw new ConfigException("serverURL or targetAPIVersion must be supplied.");
        }
        if (this.serverURL != null) {
            this.effectiveServerURL = this.serverURL;
        } else {
            int dotPos = this.targetAPIVersion.indexOf(46);
            String majorVersion = dotPos >= 0 ? this.targetAPIVersion.substring(0, dotPos) : this.targetAPIVersion;
            Object[] arguments = new Object[]{majorVersion};
            this.effectiveServerURL = MessageFormat.format(this.sendToProduction ? "https://ics2ws.ic3.com/commerce/{0}.x/transactionProcessor" : "https://ics2wstest.ic3.com/commerce/{0}.x/transactionProcessor", arguments);
        }
        this.effectivePassword = this.password != null ? this.password : this.merchantID;
    }

    public File getKeyFile() throws ConfigException {
        File file = new File(this.keysDirectory, this.keyFilename != null ? this.keyFilename : this.merchantID + ".p12");
        String fullPath = file.getAbsolutePath();
        if (!file.isFile()) {
            throw new ConfigException("The file \"" + fullPath + "\" is missing or is not a file.");
        }
        if (!file.canRead()) {
            throw new ConfigException("This application does not have permission to read the file \"" + fullPath + "\".");
        }
        return file;
    }

    public File getLogFile() throws ConfigException {
        File dir = new File(this.logDirectory);
        String fullPath = dir.getAbsolutePath();
        if (!dir.isDirectory()) {
            throw new ConfigException("The log directory \"" + fullPath + "\" is missing or is not a directory.");
        }
        return new File(this.logDirectory, this.logFilename != null ? this.logFilename : "cybs.log");
    }

    public String getProperty(String merchantID, String prop) {
        return this.getProperty(merchantID, prop, null);
    }

    public String getProperty(String merchantID, String prop, String defaultVal) {
        String merchantSpecificProp;
        String val = null;
        String string = merchantSpecificProp = merchantID != null ? merchantID + "." + prop : null;
        if (this.props != null && merchantSpecificProp != null) {
            val = this.props.getProperty(merchantSpecificProp);
        }
        if (this.props != null && val == null) {
            val = this.props.getProperty(prop);
        }
        if (val == null && merchantSpecificProp != null) {
            val = System.getProperty("cybs." + merchantSpecificProp);
        }
        if (val == null) {
            val = System.getProperty("cybs." + prop);
        }
        if (val == null) {
            val = defaultVal;
        }
        return val;
    }

    public String getLogString() {
        StringBuffer sb = new StringBuffer();
        MerchantConfig.appendPair(sb, "merchantID", this.merchantID);
        MerchantConfig.appendPair(sb, "keysDirectory", this.keysDirectory);
        MerchantConfig.appendPair(sb, "keyAlias", this.keyAlias);
        MerchantConfig.appendPair(sb, "keyPassword", this.keyPassword);
        MerchantConfig.appendPair(sb, "sendToProduction", this.sendToProduction);
        MerchantConfig.appendPair(sb, "targetAPIVersion", this.targetAPIVersion);
        MerchantConfig.appendPair(sb, "keyFilename", this.keyFilename);
        MerchantConfig.appendPair(sb, "serverURL", this.serverURL);
        MerchantConfig.appendPair(sb, "namespaceURI", this.namespaceURI);
        MerchantConfig.appendPair(sb, "enableLog", this.enableLog);
        MerchantConfig.appendPair(sb, "logDirectory", this.logDirectory);
        MerchantConfig.appendPair(sb, "logFilename", this.logFilename);
        MerchantConfig.appendPair(sb, "logMaximumSize", this.logMaximumSize);
        MerchantConfig.appendPair(sb, "useHttpClient", this.useHttpClient);
        MerchantConfig.appendPair(sb, "timeout", this.timeout);
        if (this.proxyHost != null) {
            MerchantConfig.appendPair(sb, "proxyHost", this.proxyHost);
            MerchantConfig.appendPair(sb, "proxyPort", this.proxyPort);
            if (this.proxyUser != null) {
                MerchantConfig.appendPair(sb, "proxyUser", this.proxyUser);
                MerchantConfig.appendPair(sb, "proxyPassword", this.proxyPassword != null ? "(masked)" : null);
            }
        }
        return sb.toString();
    }

    private static void appendPair(StringBuffer sb, String key, boolean value) {
        MerchantConfig.appendPair(sb, key, String.valueOf(value));
    }

    private static void appendPair(StringBuffer sb, String key, int value) {
        MerchantConfig.appendPair(sb, key, String.valueOf(value));
    }

    private static void appendPair(StringBuffer sb, String key, String value) {
        if (sb.length() > 0) {
            sb.append(", ");
        }
        sb.append(key + "=");
        sb.append(value != null ? value : "(null)");
    }

    private boolean getBooleanProperty(String merchantID, String prop, boolean defaultVal) throws ConfigException {
        String strValue = this.getProperty(merchantID, prop);
        if (strValue == null) {
            return defaultVal;
        }
        if ("1".equals(strValue) || "true".equalsIgnoreCase(strValue)) {
            return true;
        }
        if ("0".equals(strValue) || "false".equalsIgnoreCase(strValue)) {
            return false;
        }
        throw new ConfigException(prop + " has an invalid value.");
    }

    private int getIntegerProperty(String merchantID, String prop, int defaultVal) throws ConfigException {
        String strValue = this.getProperty(merchantID, prop);
        if (strValue == null) {
            return defaultVal;
        }
        try {
            return Integer.parseInt(strValue);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigException(prop + " has an invalid value.");
        }
    }
}

