/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.ClientException;
import com.cybersource.ws.client.PCI;
import com.cybersource.ws.client.XMLClient;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Utility {
    public static final String SERVER_ALIAS = "CyberSource_SJC_US";
    public static final String CYBS_CERT_AUTH = "CyberSourceCertAuth";
    public static final String VERSION = "6.2.13";
    public static final String ORIGIN_TIMESTAMP = "v-c-client-iat";
    public static final String SDK_ELAPSED_TIMESTAMP = "v-c-client-computetime";
    public static final String RESPONSE_TIME_REPLY = "v-c-response-time";
    public static final String MERCHANT_TRANSACTION_IDENTIFIER = "merchantTransactionIdentifier";
    public static final String AUTH_SERVICE = "ccAuthService";
    public static final String AUTH_SERVICE_XML_RUN_ATT = "run";
    public static final String AUTH_SERVICE_NVP = "ccAuthService_run";
    public static final String ELEM_MERCHANT_ID = "merchantID";
    public static final String KEY_ALIAS = "keyAlias";
    public static final String ELEM_MERCHANT_REFERENCE_CODE = "merchantReferenceCode";
    public static final String ELEM_CLIENT_LIBRARY = "clientLibrary";
    public static final String ELEM_CLIENT_LIBRARY_VERSION = "clientLibraryVersion";
    public static final String ELEM_CLIENT_ENVIRONMENT = "clientEnvironment";
    public static final int HTTP_BAD_REQUEST = 400;
    public static final String MTI_FIELD_ERR_MSG = "merchantTransactionIdentifier field is mandatory if useHttpClientWithConnectionPool is set to true";
    private static final String HAS_ESCAPES = "_has_escapes";
    public static final String NVP_LIBRARY = "Java NVP" + "/" + "6.2.13";
    public static final String XML_LIBRARY = "Java XML" + "/" + "6.2.13";
    public static final String ENVIRONMENT = System.getProperty("os.name") + "/" + System.getProperty("os.version") + "/" + System.getProperty("java.vendor") + "/" + System.getProperty("java.version");
    private static final String CYBS_ROOT_FIELDS = "requestMessage replyMessage nvpRequest nvpReply";

    private Utility() {
    }

    public static String nodeToString(Node node, int type) {
        node = node.cloneNode(true);
        Utility.maskXml(type, node, null);
        return Utility.nodeToString(node);
    }

    public static String nodeToString(Node node) {
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(node), new StreamResult(stream));
            String str = stream.toString("UTF-8");
            stream.close();
            return str;
        }
        catch (TransformerConfigurationException e) {
            return e.getMessage();
        }
        catch (TransformerException e) {
            return e.getMessage();
        }
        catch (UnsupportedEncodingException e) {
            return e.getMessage();
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    public static Properties readProperties(String[] commandLineArgs) {
        Properties props = new Properties();
        try {
            String filename = commandLineArgs.length > 0 ? commandLineArgs[0] : "cybs.properties";
            FileInputStream fis = new FileInputStream(filename);
            props.load(fis);
            fis.close();
            return props;
        }
        catch (IOException iOException) {
            return props;
        }
    }

    public static byte[] read(String filename) throws IOException {
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(filename));
        byte[] content = Utility.read(stream);
        stream.close();
        return content;
    }

    public static byte[] read(File file) throws IOException {
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        byte[] content = Utility.read(stream);
        stream.close();
        return content;
    }

    public static byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        boolean more = true;
        int totalBytes = 0;
        while (more) {
            byte[] buf;
            int numRead;
            int avail = in.available();
            if (avail <= 0) {
                avail = 1;
            }
            if ((numRead = in.read(buf = new byte[avail], 0, avail)) != -1) {
                baos.write(buf, 0, numRead);
                totalBytes += numRead;
                continue;
            }
            more = false;
        }
        if (totalBytes == 0) {
            return new byte[0];
        }
        byte[] ba = baos.toByteArray();
        baos.close();
        return ba;
    }

    public static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return dbf.newDocumentBuilder();
    }

    public static Element getElement(Document owner, String elementName, String nsURI) {
        NodeList nodes;
        NodeList nodeList = nodes = nsURI != null ? owner.getElementsByTagNameNS(nsURI, elementName) : owner.getElementsByTagName(elementName);
        if (nodes != null && nodes.getLength() > 0) {
            return (Element)nodes.item(0);
        }
        return null;
    }

    public static String getElementText(Document owner, String elementName, String nsURI) {
        Element elem = Utility.getElement(owner, elementName, nsURI);
        if (elem != null) {
            return elem.getFirstChild().getNodeValue();
        }
        return null;
    }

    public static String getStackTrace(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        String stackTrace = sw.toString();
        pw.close();
        return stackTrace;
    }

    private static void maskXml(int type, Node node, String parentName) {
        block10: {
            short nodeType;
            block9: {
                if (node == null) {
                    return;
                }
                nodeType = node.getNodeType();
                if (nodeType != 3) break block9;
                if (PCI.isSafe(type, parentName)) break block10;
                String origVal = node.getNodeValue();
                if (origVal != null) {
                    origVal = origVal.trim();
                }
                if (origVal == null || origVal.length() <= 0) break block10;
                node.setNodeValue(PCI.mask(parentName, origVal));
                break block10;
            }
            if (nodeType == 1 || nodeType == 9) {
                if (!node.hasChildNodes()) {
                    return;
                }
                String localName = node.getLocalName();
                if (localName == null) {
                    localName = "";
                }
                String fieldFullName = null;
                if (parentName == null) {
                    if (localName.length() > 0 && CYBS_ROOT_FIELDS.indexOf(localName) != -1) {
                        fieldFullName = "";
                    }
                } else {
                    fieldFullName = parentName.length() == 0 ? localName : parentName + "_" + localName;
                }
                NodeList children = node.getChildNodes();
                int numChildren = children.getLength();
                for (int i = 0; i < numChildren; ++i) {
                    Utility.maskXml(type, children.item(i), fieldFullName);
                }
            }
        }
    }

    public static HashMap<String, String> stringToMap(String src) {
        HashMap<String, String> dest = new HashMap<String, String>();
        if (src == null) {
            return dest;
        }
        int startPos = 0;
        int len = src.length();
        while (startPos < len) {
            String val;
            String key;
            String line;
            int equalsPos;
            int newLinePos = src.indexOf(10, startPos);
            if (newLinePos == -1) {
                newLinePos = len;
            }
            if ((equalsPos = (line = src.substring(startPos, newLinePos)).indexOf(61)) != -1) {
                key = line.substring(0, equalsPos);
                val = line.substring(equalsPos + 1);
            } else {
                key = line;
                val = null;
            }
            dest.put(key, val);
            startPos = newLinePos + 1;
        }
        return dest;
    }

    public static String mapToString(Map src, boolean mask, int type) {
        StringBuilder dest = new StringBuilder();
        if (src != null && !src.isEmpty()) {
            for (String key : src.keySet()) {
                String val = mask ? PCI.maskIfNotSafe(type, key, (String)src.get(key)) : (String)src.get(key);
                dest.append(key).append("=").append(val).append("\n");
            }
        } else {
            return dest.toString();
        }
        String hasEscapes = (String)src.get(HAS_ESCAPES);
        return "1".equals(hasEscapes) || "true".equalsIgnoreCase(hasEscapes) ? dest.toString() : StringEscapeUtils.escapeXml11((String)dest.toString());
    }

    public static Document readRequest(Properties props, String filename) {
        return Utility.readRequest(props, filename, null);
    }

    public static Document readRequest(Properties props, String filename, String merchantId) {
        Document doc = null;
        try {
            byte[] xmlBytes = Utility.read(filename);
            String xmlString = new String(xmlBytes, "UTF-8");
            int pos = xmlString.indexOf("_NSURI_");
            if (pos != -1) {
                StringBuilder sb = new StringBuilder(xmlString);
                sb.replace(pos, pos + 7, XMLClient.getEffectiveNamespaceURI(props, merchantId));
                xmlBytes = sb.toString().getBytes("UTF-8");
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(xmlBytes);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            DocumentBuilder builder = dbf.newDocumentBuilder();
            doc = builder.parse(bais);
            bais.close();
        }
        catch (ClientException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    public static Element createElement(Document owner, String nsURI, String elementName, String textValue) {
        Attr attr = owner.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        attr.setValue(nsURI);
        Element elem = owner.createElementNS(nsURI, elementName);
        elem.setAttributeNodeNS(attr);
        elem.appendChild(owner.createTextNode(textValue));
        return elem;
    }

    public static long getResponseIssuedAtTime(String responseTime) {
        return Utility.parseLong(responseTime, 0L);
    }

    public static long getResponseTransitTime(long resIssuedAtTime) {
        if (resIssuedAtTime > 0L) {
            if (Utility.checkIfEpochTimeInSecs(resIssuedAtTime)) {
                return System.currentTimeMillis() / 1000L - resIssuedAtTime;
            }
            return System.currentTimeMillis() - resIssuedAtTime;
        }
        return 0L;
    }

    private static boolean checkIfEpochTimeInSecs(long resIssuedAtTime) {
        return String.valueOf(resIssuedAtTime).length() == 10;
    }

    private static long parseLong(String val, long defaultValue) {
        long result = defaultValue;
        if (val != null) {
            try {
                result = Long.parseLong(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static String checkIfMTIFiledExist(Document request, String nsURI) {
        String mtiFieldValue = Utility.getElementText(request, MERCHANT_TRANSACTION_IDENTIFIER, nsURI);
        if (StringUtils.isBlank((CharSequence)mtiFieldValue)) {
            mtiFieldValue = Utility.getElementText(request, MERCHANT_TRANSACTION_IDENTIFIER, null);
        }
        return mtiFieldValue;
    }

    public static String checkIfAuthServiceFieldExist(Document request, String nsURI) {
        Element authServiceElement = Utility.getElement(request, AUTH_SERVICE, nsURI);
        if (authServiceElement == null) {
            authServiceElement = Utility.getElement(request, AUTH_SERVICE, null);
        }
        String isAuthService = null;
        if (authServiceElement != null) {
            isAuthService = authServiceElement.getAttribute(AUTH_SERVICE_XML_RUN_ATT);
        }
        return isAuthService;
    }
}

