/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.Client;
import com.cybersource.ws.client.ClientException;
import com.cybersource.ws.client.ConfigException;
import com.cybersource.ws.client.Connection;
import com.cybersource.ws.client.FaultException;
import com.cybersource.ws.client.Logger;
import com.cybersource.ws.client.LoggerWrapper;
import com.cybersource.ws.client.MerchantConfig;
import com.cybersource.ws.client.SecurityUtil;
import com.cybersource.ws.client.SignEncryptException;
import com.cybersource.ws.client.SignException;
import com.cybersource.ws.client.Utility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLClient {
    private static final String SOAP_ENVELOPE = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\"><soap:Body></soap:Body></soap:Envelope>";
    private static final String ELEM_REQUEST_MESSAGE = "requestMessage";
    private static final String ELEM_REPLY_MESSAGE = "replyMessage";
    private static final String[] VERSION_FIELDS = new String[]{"clientLibrary", "clientLibraryVersion", "clientEnvironment"};
    private static Document soapEnvelope;
    private static Exception initException;
    private static ConcurrentHashMap<String, MerchantConfig> mcObjects;

    public static Document runTransaction(Document request, Properties props) throws FaultException, ClientException {
        return XMLClient.runTransaction(request, props, null, true, true);
    }

    public static Document runTransaction(Document request, Properties props, Logger _logger, boolean prepare, boolean logTranStart) throws FaultException, ClientException {
        if (initException != null) {
            throw new ClientException(initException, false, null);
        }
        LoggerWrapper logger = null;
        Connection con = null;
        try {
            String mtiField;
            long requestSentTime = System.currentTimeMillis();
            boolean isMerchantConfigCacheEnabled = Boolean.parseBoolean(props.getProperty("merchantConfigCacheEnabled", "false"));
            MerchantConfig mc = isMerchantConfigCacheEnabled ? XMLClient.getInstanceMap(request, props) : XMLClient.getMerchantConfigObject(request, props);
            String nsURI = mc.getEffectiveNamespaceURI();
            logger = new LoggerWrapper(_logger, prepare, logTranStart, mc);
            String isAuthService = Utility.checkIfAuthServiceFieldExist(request, nsURI);
            if (Boolean.valueOf(isAuthService).booleanValue() && mc.getUseHttpClientWithConnectionPool() && StringUtils.isBlank((CharSequence)(mtiField = Utility.checkIfMTIFiledExist(request, nsURI)))) {
                throw new ClientException(400, "merchantTransactionIdentifier field is mandatory if useHttpClientWithConnectionPool is set to true", false, logger);
            }
            XMLClient.setVersionInformation(request, nsURI);
            DocumentBuilder builder = Utility.newDocumentBuilder();
            Document signedDoc = XMLClient.soapWrapAndSign(request, mc, builder, logger);
            if (mc.isCustomHttpClassEnabled()) {
                try {
                    Class<?> customConnectionClass = Class.forName(mc.getCustomHttpClass());
                    Class[] constructor_Args = new Class[]{MerchantConfig.class, DocumentBuilder.class, LoggerWrapper.class};
                    con = (Connection)customConnectionClass.getDeclaredConstructor(constructor_Args).newInstance(mc, builder, logger);
                }
                catch (InstantiationException e) {
                    logger.log("INFO     ", "Failed to instantiate the class " + e);
                    throw new ClientException(e, false, null);
                }
                catch (IllegalAccessException e) {
                    logger.log("INFO     ", "Could not access the method invoked " + e);
                    throw new ClientException(e, false, null);
                }
                catch (ClassNotFoundException e) {
                    logger.log("INFO     ", "Could not load the custom HTTP class " + e);
                    throw new ClientException(e, false, null);
                }
                catch (IllegalArgumentException e) {
                    logger.log("INFO     ", "Method invoked with illegal argument list  " + e);
                    throw new ClientException(e, false, null);
                }
                catch (SecurityException e) {
                    logger.log("INFO     ", "Security exception " + e);
                    throw new ClientException(e, false, null);
                }
                catch (InvocationTargetException e) {
                    logger.log("INFO     ", "Exception occurred while calling the method " + e);
                    throw new ClientException(e, false, null);
                }
                catch (NoSuchMethodException e) {
                    logger.log("INFO     ", "Method not found " + e);
                    throw new ClientException(e, false, null);
                }
            } else {
                con = Connection.getInstance(mc, builder, logger);
            }
            Document wrappedReply = con.post(signedDoc, requestSentTime);
            Document doc = XMLClient.soapUnwrap(wrappedReply, mc, builder, logger);
            logger.log("INFO     ", "Client, End of runTransaction Call   ", false);
            Document document = doc;
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new ClientException(e, con != null && con.isRequestSent(), logger);
        }
        catch (SignException e) {
            throw new ClientException(e, con != null && con.isRequestSent(), logger);
        }
        catch (ConfigException e) {
            throw new ClientException(e, con != null && con.isRequestSent(), logger);
        }
        catch (SignEncryptException e) {
            throw new ClientException(e, con != null && con.isRequestSent(), logger);
        }
        finally {
            if (con != null) {
                con.release();
            }
        }
    }

    public static String getEffectiveNamespaceURI(Properties props, String merchantID) throws ClientException {
        try {
            MerchantConfig mc = new MerchantConfig(props, merchantID);
            return mc.getEffectiveNamespaceURI();
        }
        catch (ConfigException ce) {
            throw new ClientException(ce, false, null);
        }
    }

    private static void setMerchantID(Document request, String merchantID, String nsURI) {
        Element merchantIDElem = Utility.createElement(request, nsURI, "merchantID", merchantID);
        Element requestMessage = Utility.getElement(request, ELEM_REQUEST_MESSAGE, nsURI);
        requestMessage.insertBefore(merchantIDElem, requestMessage.getFirstChild());
    }

    private static void setVersionInformation(Document request, String nsURI) {
        Element requestMessage = Utility.getElement(request, ELEM_REQUEST_MESSAGE, nsURI);
        Element previous = Utility.getElement(request, "merchantReferenceCode", nsURI);
        if (previous == null) {
            previous = Utility.getElement(request, "merchantID", nsURI);
        }
        Node currElem = previous != null ? previous.getNextSibling() : requestMessage.getFirstChild();
        for (int i = 0; i < VERSION_FIELDS.length && currElem != null; ++i) {
            if (!VERSION_FIELDS[i].equals(currElem.getNodeName())) continue;
            Node save = currElem.getNextSibling();
            requestMessage.removeChild(currElem);
            currElem = save;
        }
        DocumentFragment versionsFragment = request.createDocumentFragment();
        versionsFragment.appendChild(Utility.createElement(request, nsURI, "clientLibrary", Utility.XML_LIBRARY));
        versionsFragment.appendChild(Utility.createElement(request, nsURI, "clientLibraryVersion", "6.2.13"));
        versionsFragment.appendChild(Utility.createElement(request, nsURI, "clientEnvironment", Utility.ENVIRONMENT));
        if (currElem != null) {
            requestMessage.insertBefore(versionsFragment, currElem);
        } else {
            requestMessage.appendChild(versionsFragment);
        }
    }

    private static Document soapWrapAndSign(Document doc, MerchantConfig mc, DocumentBuilder builder, LoggerWrapper logger) throws SignException, SignEncryptException, ConfigException {
        boolean logSignedData = mc.getLogSignedData();
        if (!logSignedData) {
            logger.log("REQUEST  ", "UUID   >  " + logger.getUniqueKey() + "\nInput request is\n======================================= \n" + Utility.nodeToString(doc, 0));
        }
        Document wrappedDoc = XMLClient.soapWrap(doc, mc, builder, logger);
        logger.log("INFO     ", "Client, End of soapWrap   ", true);
        SecurityUtil.loadMerchantP12File(mc, logger);
        logger.log("INFO     ", "Client, End of loading Merchant Certificate   ", true);
        Document resultDocument = SecurityUtil.createSignedDoc(wrappedDoc, mc.getKeyAlias(), mc.getKeyPassword(), logger);
        logger.log("INFO     ", "Client, End of createSignedDoc   ", true);
        if (mc.getUseSignAndEncrypted()) {
            resultDocument = SecurityUtil.handleMessageCreation(resultDocument, Utility.getElementText(doc, "merchantID", "*"), logger);
            logger.log("INFO     ", "Client, End of handleMessageCreation   ", true);
        }
        if (logSignedData) {
            logger.log("REQUEST  ", Utility.nodeToString(resultDocument, 0));
        }
        return resultDocument;
    }

    private static Document soapWrap(Document doc, MerchantConfig mc, DocumentBuilder builder, LoggerWrapper logger) throws SignException {
        Element requestMessage = Utility.getElement(doc, ELEM_REQUEST_MESSAGE, mc.getEffectiveNamespaceURI());
        Document wrappedDoc = builder.newDocument();
        wrappedDoc.appendChild(wrappedDoc.importNode(soapEnvelope.getFirstChild(), true));
        if (requestMessage != null) {
            wrappedDoc.getFirstChild().getFirstChild().appendChild(wrappedDoc.importNode(requestMessage, true));
        }
        return wrappedDoc;
    }

    private static String documentToString(Document doc) throws TransformerConfigurationException, TransformerException, IOException {
        ByteArrayOutputStream baos = null;
        try {
            baos = XMLClient.makeStream(doc);
            String string = baos.toString("utf-8");
            return string;
        }
        finally {
            if (baos != null) {
                baos.close();
            }
        }
    }

    private static ByteArrayOutputStream makeStream(Document doc) throws TransformerConfigurationException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(doc), new StreamResult(baos));
        return baos;
    }

    private static Document soapUnwrap(Document doc, MerchantConfig mc, DocumentBuilder builder, LoggerWrapper logger) {
        boolean logSignedData = mc.getLogSignedData();
        if (logSignedData) {
            logger.log("REPLY    ", Utility.nodeToString(doc, 1));
        }
        Element replyMessage = Utility.getElement(doc, ELEM_REPLY_MESSAGE, mc.getEffectiveNamespaceURI());
        Document unwrappedDoc = builder.newDocument();
        if (replyMessage != null) {
            unwrappedDoc.appendChild(unwrappedDoc.importNode(replyMessage, true));
        }
        if (!logSignedData) {
            logger.log("REPLY    ", Utility.nodeToString(unwrappedDoc, 1));
        }
        return unwrappedDoc;
    }

    private static MerchantConfig getMerchantConfigObject(Document request, Properties props) throws ConfigException {
        MerchantConfig mc;
        String merchantID = Utility.getElementText(request, "merchantID", "*");
        if (merchantID == null) {
            mc = new MerchantConfig(props, null);
            merchantID = mc.getMerchantID();
            String nsURI = mc.getEffectiveNamespaceURI();
            XMLClient.setMerchantID(request, merchantID, nsURI);
        } else {
            mc = new MerchantConfig(props, merchantID);
        }
        return mc;
    }

    private static String getMerchantId(Document request, Properties props) {
        String merchantID = Utility.getElementText(request, "merchantID", "*");
        if (merchantID == null) {
            merchantID = props.getProperty("merchantID");
        }
        return merchantID;
    }

    private static String getKeyForInstanceMap(Document request, Properties props) {
        String keyAlias = props.getProperty("keyAlias");
        if (keyAlias != null) {
            return keyAlias;
        }
        return XMLClient.getMerchantId(request, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static MerchantConfig getInstanceMap(Document request, Properties props) throws ConfigException {
        String midOrKeyAlias = XMLClient.getKeyForInstanceMap(request, props);
        if (!mcObjects.containsKey(midOrKeyAlias)) {
            Class<Client> clazz = Client.class;
            // MONITORENTER : com.cybersource.ws.client.Client.class
            if (!mcObjects.containsKey(midOrKeyAlias)) {
                mcObjects.put(midOrKeyAlias, XMLClient.getMerchantConfigObject(request, props));
            }
            // MONITOREXIT : clazz
        }
        MerchantConfig mc = mcObjects.get(midOrKeyAlias);
        String merchantID = Utility.getElementText(request, "merchantID", "*");
        if (!StringUtils.isEmpty((CharSequence)merchantID)) return mc;
        merchantID = mc.getMerchantID();
        String nsURI = mc.getEffectiveNamespaceURI();
        XMLClient.setMerchantID(request, merchantID, nsURI);
        return mc;
    }

    static {
        initException = null;
        mcObjects = new ConcurrentHashMap();
        try {
            DocumentBuilder builder = Utility.newDocumentBuilder();
            StringReader sr = new StringReader(SOAP_ENVELOPE);
            soapEnvelope = builder.parse(new InputSource(sr));
            sr.close();
        }
        catch (ParserConfigurationException e) {
            initException = e;
        }
        catch (SAXException e) {
            initException = e;
        }
        catch (IOException e) {
            initException = e;
        }
    }
}

