/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.Connection;
import com.cybersource.ws.client.LoggerWrapper;
import com.cybersource.ws.client.MerchantConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.w3c.dom.Document;

class HttpClientConnection
extends Connection {
    private PostMethod postMethod = null;

    HttpClientConnection(MerchantConfig mc, DocumentBuilder builder, LoggerWrapper logger) {
        super(mc, builder, logger);
        logger.log("INFO     ", "Using HttpClient for connections.");
    }

    @Override
    void postDocument(Document request) throws IOException, TransformerConfigurationException, TransformerException, MalformedURLException, ProtocolException {
        HttpClient httpClient = new HttpClient((HttpConnectionManager)new SimpleHttpConnectionManager(true));
        this.setTimeout(httpClient, this.mc.getTimeout() * 1000);
        this.setProxy(httpClient);
        String serverURL = this.mc.getEffectiveServerURL();
        this.postMethod = new PostMethod(serverURL);
        this.postMethod.getParams().setParameter("http.method.retry-handler", (Object)new MyRetryHandler());
        String requestString = HttpClientConnection.documentToString(request);
        this.logger.log("INFO     ", "Sending " + requestString.length() + " bytes to " + serverURL);
        this.postMethod.setRequestEntity((RequestEntity)new StringRequestEntity(requestString, null, "UTF-8"));
        httpClient.executeMethod((HttpMethod)this.postMethod);
    }

    @Override
    public boolean isRequestSent() {
        return this.postMethod != null && this.postMethod.isRequestSent();
    }

    @Override
    public void release() {
        if (this.postMethod != null) {
            this.postMethod.releaseConnection();
            this.postMethod = null;
        }
    }

    @Override
    int getHttpResponseCode() throws IOException {
        return this.postMethod != null ? this.postMethod.getStatusCode() : -1;
    }

    @Override
    InputStream getResponseStream() throws IOException {
        return this.postMethod != null ? this.postMethod.getResponseBodyAsStream() : null;
    }

    @Override
    InputStream getResponseErrorStream() throws IOException {
        return this.getResponseStream();
    }

    private void setTimeout(HttpClient httpClient, int timeoutInMs) {
        HttpConnectionManagerParams params = httpClient.getHttpConnectionManager().getParams();
        params.setConnectionTimeout(timeoutInMs);
        params.setSoTimeout(timeoutInMs);
    }

    private void setProxy(HttpClient httpClient) {
        if (this.mc.getProxyHost() != null) {
            httpClient.getHostConfiguration().setProxy(this.mc.getProxyHost(), this.mc.getProxyPort());
            if (this.mc.getProxyUser() != null) {
                ArrayList<String> authPrefs = new ArrayList<String>();
                authPrefs.add("Basic");
                httpClient.getParams().setParameter("http.auth.scheme-priority", authPrefs);
                HttpState state = new HttpState();
                state.setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.mc.getProxyUser(), this.mc.getProxyPassword()));
                httpClient.setState(state);
            }
        }
    }

    private static String documentToString(Document doc) throws TransformerConfigurationException, TransformerException, IOException {
        ByteArrayOutputStream baos = null;
        try {
            baos = HttpClientConnection.makeStream(doc);
            String string = baos.toString("utf-8");
            return string;
        }
        finally {
            if (baos != null) {
                baos.close();
            }
        }
    }

    private class MyRetryHandler
    implements HttpMethodRetryHandler {
        long retryWaitInterval;
        int maxRetries;

        private MyRetryHandler() {
            this.retryWaitInterval = HttpClientConnection.this.mc.getRetryInterval();
            this.maxRetries = HttpClientConnection.this.mc.getNumberOfRetries();
        }

        public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
            if (executionCount > this.maxRetries) {
                return false;
            }
            if (exception instanceof NoHttpResponseException) {
                return false;
            }
            if (!method.isRequestSent()) {
                try {
                    Thread.sleep(this.retryWaitInterval);
                    HttpClientConnection.this.logger.log("INFO      Retrying Request -- ", HttpClientConnection.this.mc.getUniqueKey().toString() + " Retry Count -- " + executionCount);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return true;
            }
            return false;
        }
    }
}

