/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.ConfigException;
import com.cybersource.ws.client.Logger;
import com.cybersource.ws.client.LoggerImpl;
import com.cybersource.ws.client.MerchantConfig;
import com.cybersource.ws.client.MyStopWatch;

public class LoggerWrapper
implements Logger {
    private Logger logger = null;
    private MyStopWatch stopWatch = new MyStopWatch();

    public LoggerWrapper(Logger _logger, boolean _prepare, boolean _logTranStart, MerchantConfig _mc) throws ConfigException {
        MerchantConfig mc = _mc;
        boolean prepare = false;
        boolean logTranStart = false;
        if (_logger != null) {
            this.logger = _logger;
            prepare = _prepare;
            logTranStart = _logTranStart;
            this.stopWatch.start();
        } else if (mc.getEnableLog()) {
            this.logger = new LoggerImpl(mc);
            prepare = true;
            logTranStart = true;
            this.stopWatch.start();
        }
        if (prepare) {
            this.prepare();
        }
        if (logTranStart) {
            this.logTransactionStart();
        }
    }

    @Override
    public void prepare() throws ConfigException {
        if (this.logger != null) {
            this.logger.prepare();
        }
    }

    @Override
    public void logTransactionStart() {
        if (this.logger != null) {
            this.logger.logTransactionStart();
        }
    }

    @Override
    public void log(String type, String text) {
        if (this.logger != null) {
            this.logger.log(type, text);
        }
    }

    public void log(String type, String text, boolean splitTimer) {
        if (this.logger != null) {
            if (splitTimer) {
                this.logger.log(type, text + this.stopWatch.getMethodElapsedTime() + "ms");
            } else {
                this.logger.log(type, text + this.stopWatch.getElapsedTimeForTransaction() + "ms");
            }
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public MyStopWatch getStopWatch() {
        return this.stopWatch;
    }
}

