/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.Identity;
import com.cybersource.ws.client.Logger;
import com.cybersource.ws.client.SignEncryptException;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Properties;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.Merlin;

public class MessageHandlerKeyStore
extends Merlin {
    public MessageHandlerKeyStore() throws CredentialException, IOException {
        super(null);
        this.properties = new Properties();
    }

    public void addIdentityToKeyStore(Identity id, Logger logger) throws SignEncryptException {
        if (id == null) {
            return;
        }
        X509Certificate certificate = id.getX509Cert();
        PrivateKey privateKey = id.getPrivateKey();
        try {
            if (privateKey != null) {
                Certificate[] certChain = new X509Certificate[]{certificate};
                this.getKeyStore().setKeyEntry(id.getKeyAlias(), privateKey, id.getName().toCharArray(), certChain);
            } else {
                this.getKeyStore().setCertificateEntry(id.getKeyAlias(), certificate);
            }
        }
        catch (KeyStoreException e) {
            logger.log("EXCEPTION", "MessageHandlerKeyStore cannot parse identity, " + id + "'");
            throw new SignEncryptException("MessageHandlerKeyStore, cannot parse identity, " + id + "'", e);
        }
    }
}

