/*
 * Decompiled with CFR 0.152.
 */
package com.cybersource.ws.client;

import com.cybersource.ws.client.ConfigException;
import com.cybersource.ws.client.Identity;
import com.cybersource.ws.client.Logger;
import com.cybersource.ws.client.MerchantConfig;
import com.cybersource.ws.client.MessageHandlerKeyStore;
import com.cybersource.ws.client.SignEncryptException;
import com.cybersource.ws.client.SignException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.CredentialException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.WSSecEncrypt;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSignature;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.w3c.dom.Document;

public class SecurityUtil {
    private static final String KEY_FILE_TYPE = "PKCS12";
    private static final String SERVER_ALIAS = "CyberSource_SJC_US";
    private static MessageHandlerKeyStore localKeyStoreHandler = null;
    private static ConcurrentHashMap<String, Identity> identities = new ConcurrentHashMap();
    private static final String SIGNATURE_ALGORITHM = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
    private static final String DIGEST_ALGORITHM = "http://www.w3.org/2001/04/xmlenc#sha256";
    private static BouncyCastleProvider bcProvider = new BouncyCastleProvider();

    private static void initKeystore() throws KeyStoreException, CredentialException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance("jks");
        keyStore.load(null, null);
        localKeyStoreHandler = new MessageHandlerKeyStore();
        localKeyStoreHandler.setKeyStore(keyStore);
    }

    public static void loadMerchantP12File(MerchantConfig merchantConfig, Logger logger) throws SignException, SignEncryptException, ConfigException {
        Identity identity = identities.get(merchantConfig.getMerchantID());
        if (!merchantConfig.isCertificateCacheEnabled() || identity == null || !identity.isValid(merchantConfig.getKeyFile())) {
            try {
                if (localKeyStoreHandler == null) {
                    SecurityUtil.initKeystore();
                }
            }
            catch (Exception e) {
                logger.log("EXCEPTION", "SecurityUtil, cannot instantiate class with keystore error. " + e.getMessage());
                throw new SignException(e.getMessage());
            }
            if (merchantConfig.isJdkCertEnabled()) {
                logger.log("INFO     ", " Loading the certificate from JDK Cert");
                SecurityUtil.readJdkCert(merchantConfig, logger);
            } else if (merchantConfig.isCacertEnabled()) {
                logger.log("INFO     ", " Loading the certificate from JRE security cacert file");
                SecurityUtil.loadJavaKeystore(merchantConfig, logger);
            } else {
                logger.log("INFO     ", "Loading the certificate from p12 file ");
                SecurityUtil.readAndStoreCertificateAndPrivateKey(merchantConfig, logger);
            }
        }
    }

    private static void readAndStoreCertificateAndPrivateKey(MerchantConfig merchantConfig, Logger logger) throws SignException, SignEncryptException {
        KeyStore merchantKeyStore;
        try {
            merchantKeyStore = KeyStore.getInstance(KEY_FILE_TYPE, (Provider)bcProvider);
        }
        catch (KeyStoreException e) {
            logger.log("EXCEPTION", "Exception while instantiating KeyStore");
            throw new SignException(e);
        }
        try {
            merchantKeyStore.load(new FileInputStream(merchantConfig.getKeyFile()), merchantConfig.getKeyPassword().toCharArray());
        }
        catch (IOException e) {
            logger.log("EXCEPTION", "Exception while loading KeyStore, '" + merchantConfig.getKeyFilename() + "'");
            throw new SignException(e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.log("EXCEPTION", "Exception while loading KeyStore, '" + merchantConfig.getKeyFilename() + "'");
            throw new SignException(e);
        }
        catch (CertificateException e) {
            logger.log("EXCEPTION", "Exception while loading KeyStore, '" + merchantConfig.getKeyFilename() + "'");
            throw new SignException(e);
        }
        catch (ConfigException e) {
            logger.log("EXCEPTION", "Exception while loading KeyStore, '" + merchantConfig.getKeyFilename() + "'");
            throw new SignException(e);
        }
        String merchantKeyAlias = null;
        try {
            Enumeration<String> enumKeyStore = merchantKeyStore.aliases();
            while (enumKeyStore.hasMoreElements()) {
                Identity identity;
                KeyStore.PrivateKeyEntry keyEntry = null;
                merchantKeyAlias = enumKeyStore.nextElement();
                if (merchantKeyAlias.contains(merchantConfig.getKeyAlias())) {
                    try {
                        keyEntry = (KeyStore.PrivateKeyEntry)merchantKeyStore.getEntry(merchantKeyAlias, new KeyStore.PasswordProtection(merchantConfig.getKeyPassword().toCharArray()));
                    }
                    catch (NoSuchAlgorithmException e) {
                        logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
                        throw new SignException(e);
                    }
                    catch (UnrecoverableEntryException e) {
                        logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
                        throw new SignException(e);
                    }
                    catch (KeyStoreException e) {
                        logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
                        throw new SignException(e);
                    }
                    identity = new Identity(merchantConfig, (X509Certificate)keyEntry.getCertificate(), keyEntry.getPrivateKey(), logger);
                    localKeyStoreHandler.addIdentityToKeyStore(identity, logger);
                    identities.put(identity.getName(), identity);
                    continue;
                }
                identity = new Identity(merchantConfig, (X509Certificate)merchantKeyStore.getCertificate(merchantKeyAlias), logger);
                localKeyStoreHandler.addIdentityToKeyStore(identity, logger);
                identities.put(identity.getName(), identity);
            }
        }
        catch (KeyStoreException e) {
            logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
            throw new SignException(e);
        }
    }

    public static Document handleMessageCreation(Document signedDoc, String merchantID, Logger logger) throws SignEncryptException, SignException {
        Document signedEncryptedDoc;
        logger.log("INFO     ", "Encrypting Signed doc ...");
        WSSecHeader secHeader = new WSSecHeader();
        try {
            secHeader.insertSecurityHeader(signedDoc);
        }
        catch (WSSecurityException e) {
            logger.log("EXCEPTION", "Exception while adding docuemnt in soap securiy header for MLE");
            throw new SignException((Exception)((Object)e));
        }
        WSSecEncrypt encrBuilder = new WSSecEncrypt();
        encrBuilder.setUserInfo(identities.get(SERVER_ALIAS).getKeyAlias());
        encrBuilder.setKeyIdentifierType(3);
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        try {
            signedEncryptedDoc = encrBuilder.build(signedDoc, (Crypto)localKeyStoreHandler, secHeader);
        }
        catch (WSSecurityException e) {
            logger.log("EXCEPTION", "Failed while encrypting signed requeest for , '" + merchantID + "'" + " with " + SERVER_ALIAS);
            throw new SignEncryptException("Failed while encrypting signed requeest for , '" + merchantID + "'" + " with " + SERVER_ALIAS, e);
        }
        encrBuilder.prependToHeader(secHeader);
        return signedEncryptedDoc;
    }

    public static Document createSignedDoc(Document workingDocument, String merchantID, String password, Logger logger) throws SignException {
        logger.log("INFO     ", "Signing request...");
        WSSecHeader secHeader = new WSSecHeader();
        try {
            secHeader.insertSecurityHeader(workingDocument);
        }
        catch (WSSecurityException e) {
            logger.log("EXCEPTION", "Exception while signing XML document");
            throw new SignException((Exception)((Object)e));
        }
        WSSecSignature sign = new WSSecSignature();
        sign.setUserInfo(identities.get(merchantID).getKeyAlias(), password);
        sign.setDigestAlgo(DIGEST_ALGORITHM);
        sign.setSignatureAlgorithm(SIGNATURE_ALGORITHM);
        sign.setKeyIdentifierType(1);
        sign.setUseSingleCertificate(true);
        WSEncryptionPart msgBodyPart = new WSEncryptionPart("Body", "http://schemas.xmlsoap.org/soap/envelope/", "");
        sign.setParts(Collections.singletonList(msgBodyPart));
        try {
            return sign.build(workingDocument, (Crypto)localKeyStoreHandler, secHeader);
        }
        catch (WSSecurityException e) {
            logger.log("EXCEPTION", "Failed while signing requeest for , '" + merchantID + "'");
            throw new SignException(e.getMessage());
        }
    }

    public static void readJdkCert(MerchantConfig merchantConfig, Logger logger) throws SignEncryptException, SignException, ConfigException {
        KeyStore keystore = null;
        try {
            FileInputStream is = new FileInputStream(merchantConfig.getKeyFile());
            keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(is, merchantConfig.getKeyPassword().toCharArray());
        }
        catch (Exception e) {
            logger.log("EXCEPTION", "Failed to load the key , '" + merchantConfig.getKeyAlias() + "'");
            throw new SignException(e);
        }
        String merchantKeyAlias = null;
        try {
            Enumeration<String> enumKeyStore = keystore.aliases();
            if (!enumKeyStore.hasMoreElements()) {
                throw new SignException("Empty Keystore or Missing Certificate ");
            }
            while (enumKeyStore.hasMoreElements()) {
                Identity identity;
                KeyStore.PrivateKeyEntry keyEntry = null;
                merchantKeyAlias = enumKeyStore.nextElement();
                if (merchantKeyAlias.contains(merchantConfig.getKeyAlias())) {
                    try {
                        keyEntry = (KeyStore.PrivateKeyEntry)keystore.getEntry(merchantKeyAlias, new KeyStore.PasswordProtection(merchantConfig.getKeyPassword().toCharArray()));
                    }
                    catch (NoSuchAlgorithmException e) {
                        logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
                        throw new SignException(e);
                    }
                    catch (UnrecoverableEntryException e) {
                        logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
                        throw new SignException(e);
                    }
                    catch (KeyStoreException e) {
                        logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
                        throw new SignException(e);
                    }
                    identity = new Identity(merchantConfig, (X509Certificate)keyEntry.getCertificate(), keyEntry.getPrivateKey(), logger);
                    localKeyStoreHandler.addIdentityToKeyStore(identity, logger);
                    identities.put(identity.getName(), identity);
                    continue;
                }
                identity = new Identity(merchantConfig, (X509Certificate)keystore.getCertificate(merchantKeyAlias), logger);
                localKeyStoreHandler.addIdentityToKeyStore(identity, logger);
                identities.put(identity.getName(), identity);
            }
        }
        catch (KeyStoreException e) {
            logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
            throw new SignException(e);
        }
    }

    private static void loadJavaKeystore(MerchantConfig merchantConfig, Logger logger) throws SignException, SignEncryptException, ConfigException {
        FileInputStream is = null;
        try {
            Identity identity;
            is = new FileInputStream(merchantConfig.getKeyFile());
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(is, merchantConfig.getCacertPassword().toCharArray());
            Certificate[] cert = keystore.getCertificateChain(merchantConfig.getKeyAlias());
            if (cert == null) {
                throw new SignException("Empty Keystore or Missing Certificate ");
            }
            PrivateKey key = null;
            try {
                key = (PrivateKey)keystore.getKey(merchantConfig.getKeyAlias(), merchantConfig.getKeyAlias().toCharArray());
            }
            catch (UnrecoverableKeyException e) {
                logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore with alias, '" + merchantConfig.getKeyAlias() + "'");
                throw new SignException(e);
            }
            for (int i = 0; i < cert.length; ++i) {
                if (merchantConfig.getKeyAlias().equals(keystore.getCertificateAlias(cert[i]))) {
                    identity = new Identity(merchantConfig, (X509Certificate)cert[i], key, logger);
                    localKeyStoreHandler.addIdentityToKeyStore(identity, logger);
                    identities.put(identity.getName(), identity);
                    continue;
                }
                identity = new Identity(merchantConfig, (X509Certificate)cert[i], logger);
                localKeyStoreHandler.addIdentityToKeyStore(identity, logger);
                identities.put(identity.getName(), identity);
            }
            Certificate serverCert = keystore.getCertificate(SERVER_ALIAS);
            if (serverCert == null) {
                throw new SignException("Missing Server Certificate ");
            }
            identity = new Identity(merchantConfig, (X509Certificate)serverCert, logger);
            localKeyStoreHandler.addIdentityToKeyStore(identity, logger);
            identities.put(identity.getName(), identity);
        }
        catch (CertificateException e) {
            logger.log("EXCEPTION", "Unable to load the certificate," + merchantConfig.getKeyFilename() + "'");
            throw new SignException(e);
        }
        catch (NoSuchAlgorithmException e) {
            logger.log("EXCEPTION", "Unable to find the certificate with the specified algorithm");
            throw new SignException(e);
        }
        catch (FileNotFoundException e) {
            logger.log("EXCEPTION", "File Not found ");
            throw new SignException(e);
        }
        catch (KeyStoreException e) {
            logger.log("EXCEPTION", "Exception while obtaining private key from KeyStore" + merchantConfig.getKeyFilename() + "'");
            throw new SignException(e);
        }
        catch (IOException e) {
            logger.log("EXCEPTION", "Exception while loading KeyStore, '" + merchantConfig.getKeyFilename() + "'");
            throw new SignException(e);
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.log("EXCEPTION", "Exception while closing FileStream, '" + merchantConfig.getKeyFilename() + "'");
                    throw new SignException(e);
                }
            }
        }
    }

    static {
        Security.addProvider((Provider)bcProvider);
        try {
            SecurityUtil.initKeystore();
        }
        catch (Exception e) {
            localKeyStoreHandler = null;
        }
    }
}

