package com.d0x7.utils.mysql;

import com.d0x7.utils.config.ConfigUtils;
import com.d0x7.utils.database.Database;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import lombok.Getter;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

/**
 * Copyright (c) 2015-2017 d0x7.com
 * <p>
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * <p>
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * <p>
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
public class MySQL {

    @Getter
    private static Connection connection;
    @Getter
    private static boolean initialized = false;

    public static ListenableFuture<Boolean> setup() {
        if (ConfigUtils.get(MySQLConfiguration.class) == null)
            try {
                ConfigUtils.loadConfigurationFile(new File(System.getProperty("user.home"), "mysql.database.json"), MySQLConfiguration.class);
            } catch (InvocationTargetException | IOException | NoSuchMethodException | IllegalAccessException | InstantiationException e) {
                return Futures.immediateFailedFuture(e);
            }
        return setup(ConfigUtils.get(MySQLConfiguration.class));
    }

    public static ListenableFuture<Boolean> setup(MySQLConfiguration mySQLConfiguration) {
        if (initialized)
            return Futures.immediateFuture(true);

        initialized = true;
        return Database.getExecutorService().submit(() -> {
            connection = DriverManager.getConnection(String.format("jdbc:mysql://%s:%s/%s?useUnicode=true&characterEncoding=utf8", mySQLConfiguration.getHostname(), mySQLConfiguration.getPort(), mySQLConfiguration.getDatabase()), mySQLConfiguration.getUsername(), mySQLConfiguration.getPassword());
            return !connection.isClosed();
        });
    }


    public static void shutdown() {
        try {
            connection.close();
        } catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static boolean isConnected() {
        try {
            return connection.isValid(3);
        } catch (SQLException e) {
            return false;
        }
    }
}