/*
 * Decompiled with CFR 0.152.
 */
package com.d0x7.utils.config;

import com.d0x7.utils.config.ConfigUtils;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class Config {
    private transient boolean singleInstance;
    @SerializedName(value="Config Version (DO NOT TOUCH!)")
    private String currentVersion;
    private transient String version;

    public Config(String version) {
        this(version, true);
    }

    public Config(String version, boolean singleInstance) {
        this.singleInstance = singleInstance;
        this.version = version;
        this.currentVersion = version;
    }

    public void postProcess() {
    }

    public void createDefaults() {
    }

    public static <T extends Config> T load(String file, Class<T> clazz) {
        return Config.load(new File(file), clazz, true);
    }

    public static <T extends Config> T load(File file, Class<T> clazz) {
        return Config.load(file, clazz, true);
    }

    public static <T extends Config> T load(String file, Class<T> clazz, boolean createFromDefaults) {
        return Config.load(new File(file), clazz, createFromDefaults);
    }

    public static <T extends Config> T load(File file, Class<T> clazz, boolean createFromDefaults) {
        try {
            return ConfigUtils.loadConfigurationFile(file, clazz);
        }
        catch (IOException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T extends Config> T get(Class<? extends T> clazz) {
        return ConfigUtils.get(clazz);
    }

    public boolean isSingleInstance() {
        return this.singleInstance;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public void setSingleInstance(boolean singleInstance) {
        this.singleInstance = singleInstance;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$currentVersion = this.getCurrentVersion();
        String other$currentVersion = other.getCurrentVersion();
        return !(this$currentVersion == null ? other$currentVersion != null : !this$currentVersion.equals(other$currentVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $currentVersion = this.getCurrentVersion();
        result = result * 59 + ($currentVersion == null ? 0 : $currentVersion.hashCode());
        return result;
    }

    public String toString() {
        return "Config(singleInstance=" + this.isSingleInstance() + ", currentVersion=" + this.getCurrentVersion() + ", version=" + this.getVersion() + ")";
    }
}

