/*
 * Decompiled with CFR 0.152.
 */
package com.d0x7.utils.config;

import com.d0x7.utils.config.Config;
import com.d0x7.utils.config.InvalidVersionException;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;

public class ConfigUtils {
    private static Gson prettyGson = new GsonBuilder().setPrettyPrinting().create();
    private static Map<Class<? extends Config>, Config> singleInstanceConfigs = Maps.newHashMap();

    public static <T extends Config> T loadConfigurationFile(File file, Class<T> clazz) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, IOException {
        return ConfigUtils.loadConfigurationFile(file, clazz, true);
    }

    public static <T extends Config> T loadConfigurationFile(File file, Class<T> clazz, boolean createFromDefaults) throws NoSuchMethodException, IOException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Config config;
        Preconditions.checkState(file.exists() || createFromDefaults, "Configuration File must already exists or createFromDefaults must be used");
        if (!file.exists()) {
            config = (Config)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            config.createDefaults();
            Files.write(file.toPath(), ConfigUtils.getPrettyGson().toJson(config).getBytes(Charsets.UTF_8), new OpenOption[0]);
        } else {
            config = (Config)ConfigUtils.getPrettyGson().fromJson(new String(Files.readAllBytes(file.toPath()), Charsets.UTF_8), clazz);
        }
        int version = ConfigUtils.versionCompare(config.getCurrentVersion(), config.getVersion());
        switch (version) {
            case 1: {
                throw new InvalidVersionException("Version in config must be equals or lower then " + config.getVersion() + " (Are you using an outdated library version?)");
            }
            case -1: {
                Config defaultConfig = (Config)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                defaultConfig.createDefaults();
                boolean updated = false;
                for (Field field : clazz.getDeclaredFields()) {
                    if (Modifier.isTransient(field.getModifiers())) continue;
                    field.setAccessible(true);
                    if (field.get(config) != null || field.get(defaultConfig) == null) continue;
                    field.set(config, field.get(defaultConfig));
                    updated = true;
                }
                config.setCurrentVersion(defaultConfig.getVersion());
                Files.write(file.toPath(), ConfigUtils.getPrettyGson().toJson(config).getBytes(Charsets.UTF_8), new OpenOption[0]);
            }
        }
        config.postProcess();
        if (config.isSingleInstance()) {
            singleInstanceConfigs.put(clazz, config);
        }
        return (T)config;
    }

    public static <T extends Config> T get(Class<? extends T> clazz) {
        return (T)singleInstanceConfigs.get(clazz);
    }

    public static int versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    public static Gson getPrettyGson() {
        return prettyGson;
    }
}

