/*
 * Decompiled with CFR 0.152.
 */
package com.d3x.morpheus.db;

import com.d3x.morpheus.frame.DataFrameException;
import com.d3x.morpheus.frame.DataFrameSource;
import com.d3x.morpheus.util.sql.SQLExtractor;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.sql.DataSource;

public class DbSourceOptions<R>
implements DataFrameSource.Options<R, String> {
    private String sql;
    private int rowCapacity = 1000;
    private int fetchSize;
    private Connection connection;
    private Object[] parameters;
    private boolean autoCommit = true;
    private boolean readOnly = false;
    private Set<String> excludeColumnSet = new HashSet<String>();
    private Function<ResultSet, R> rowKeyFunction;
    private Map<String, SQLExtractor> extractorMap = new HashMap<String, SQLExtractor>();

    public DbSourceOptions() {
        this.rowKeyFunction = rs -> {
            try {
                return rs.getObject(1);
            }
            catch (SQLException ex) {
                throw new RuntimeException("Failed to read row key from SQL ResultSet", ex);
            }
        };
    }

    public void validate() {
        Objects.requireNonNull(this.sql, "The SQL statement cannot be null");
        Objects.requireNonNull(this.connection, "The JDBC connection cannot be null");
    }

    public DbSourceOptions<R> withSql(String sql) {
        Objects.requireNonNull(sql, "The sql cannot be null");
        this.sql = sql;
        return this;
    }

    public DbSourceOptions<R> withParameters(Object ... parameters) {
        Objects.requireNonNull(parameters, "The sql parameters cannot be null, empty array is fine");
        this.parameters = parameters;
        return this;
    }

    public DbSourceOptions<R> withConnection(Connection connection) {
        Objects.requireNonNull(connection, "The SQL connection cannot be null");
        this.connection = connection;
        return this;
    }

    public DbSourceOptions<R> withConnection(DataSource dataSource) {
        Objects.requireNonNull(dataSource, "The SQL data source cannot be null");
        try {
            this.connection = dataSource.getConnection();
            return this;
        }
        catch (SQLException ex) {
            throw new RuntimeException("Failed to access a DB connection from DataSource", ex);
        }
    }

    public DbSourceOptions<R> withConnection(String url, String username, String password) {
        try {
            Objects.requireNonNull(url, "The JDBC URL cannnot be null");
            this.connection = DriverManager.getConnection(url, username, password);
            return this;
        }
        catch (SQLException ex) {
            throw new DataFrameException("Failed to create connection for URL:" + url, (Throwable)ex);
        }
    }

    public DbSourceOptions<R> withExcludeColumns(String ... columns) {
        this.excludeColumnSet.addAll(Arrays.asList(columns));
        return this;
    }

    public DbSourceOptions<R> withRowKeyFunction(Function<ResultSet, R> rowKeyFunction) {
        Objects.requireNonNull(rowKeyFunction, "The row key function cannot be null");
        this.rowKeyFunction = rowKeyFunction;
        return this;
    }

    public DbSourceOptions<R> withRowCapacity(int rowCapacity) {
        this.rowCapacity = rowCapacity;
        return this;
    }

    public DbSourceOptions<R> withFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public DbSourceOptions<R> withAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
        return this;
    }

    public DbSourceOptions<R> withReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public DbSourceOptions<R> withExtractor(String colName, SQLExtractor extractor) {
        Objects.requireNonNull(colName, "The column name cannot be null");
        Objects.requireNonNull(extractor, "The database extractor");
        this.extractorMap.put(colName, extractor);
        return this;
    }

    public String getSql() {
        return this.sql;
    }

    Optional<Object[]> getParameters() {
        return Optional.ofNullable(this.parameters);
    }

    Connection getConnection() {
        return this.connection;
    }

    int getRowCapacity() {
        return this.rowCapacity;
    }

    boolean isAutoCommit() {
        return this.autoCommit;
    }

    boolean isReadOnly() {
        return this.readOnly;
    }

    Set<String> getExcludeColumnSet() {
        return this.excludeColumnSet;
    }

    Optional<Integer> getFetchSize() {
        return this.fetchSize <= 0 ? Optional.empty() : Optional.of(this.fetchSize);
    }

    Function<ResultSet, R> getRowKeyFunction() {
        return this.rowKeyFunction;
    }

    Map<String, SQLExtractor> getExtractors() {
        return Collections.unmodifiableMap(this.extractorMap);
    }
}

