package com.dahuatech.icc.brm.model.v202010.card;

import com.dahuatech.hutool.http.Method;
import com.dahuatech.icc.brm.constant.BrmConstant;
import com.dahuatech.icc.exception.ClientException;
import com.dahuatech.icc.oauth.http.AbstractIccRequest;

/**
 * 批量ID生成
 *
 * @author 232676
 * @since 1.0.0 2020/11/5 11:27
 */
public class BrmCardBatchGenIdRequest extends AbstractIccRequest<BrmCardBatchGenIdResponse> {

  public BrmCardBatchGenIdRequest(Integer number) throws ClientException {
    super(BrmConstant.url(BrmConstant.BRM_URL_CARD_BATCH_GEN_ID_GET), Method.GET);
    form("count", number);
  }

  @Override
  public Class<BrmCardBatchGenIdResponse> getResponseClass() {
    return BrmCardBatchGenIdResponse.class;
  }
}
